/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.function;

import com.evolvedbinary.j8fu.function.TriFunctionE;
import java.io.IOException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.SyntaxException;
import org.xmldb.api.base.XMLDBException;

@FunctionalInterface
public interface LocalXmldbCollectionFunction<R>
extends TriFunctionE<Collection, DBBroker, Txn, R, XMLDBException> {
    default public R apply(Collection collection, DBBroker broker, Txn transaction) throws XMLDBException {
        try {
            return this.applyXmldb(collection, broker, transaction);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XMLDBException(202, e.getMessage(), (Throwable)e);
        }
        catch (IOException | TriggerException | SyntaxException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public R applyXmldb(Collection var1, DBBroker var2, Txn var3) throws XMLDBException, PermissionDeniedException, LockException, TriggerException, IOException, SyntaxException;
}

