/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.function;

import com.evolvedbinary.j8fu.function.TriFunctionE;
import java.io.IOException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.SyntaxException;
import org.xmldb.api.base.XMLDBException;

@FunctionalInterface
public interface LocalXmldbDocumentFunction<R>
extends TriFunctionE<DocumentImpl, DBBroker, Txn, R, XMLDBException> {
    default public R apply(DocumentImpl document, DBBroker broker, Txn transaction) throws XMLDBException {
        try {
            return this.applyXmldb(document, broker, transaction);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new XMLDBException(202, e.getMessage(), (Throwable)e);
        }
        catch (IOException | SyntaxException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public R applyXmldb(DocumentImpl var1, DBBroker var2, Txn var3) throws XMLDBException, PermissionDeniedException, LockException, IOException, SyntaxException;
}

