/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xmlrpc.AbstractCachedResult;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.SerializedResult;

@ThreadSafe
public class QueryResultCache {
    private static final Logger LOG = LogManager.getLogger(QueryResultCache.class);
    private static final int TIMEOUT = 180000;
    private final AtomicInteger cacheIdCounter = new AtomicInteger();
    private final Cache<Integer, AbstractCachedResult> cache = Caffeine.newBuilder().expireAfterAccess(180000L, TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> {
        AbstractCachedResult qr = (AbstractCachedResult)value;
        qr.free();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing cached result set: " + new Date(qr.getTimestamp()).toString());
        }
    }).build();

    public int add(AbstractCachedResult qr) {
        int cacheId = this.cacheIdCounter.getAndIncrement();
        this.cache.put((Object)cacheId, (Object)qr);
        return cacheId;
    }

    public AbstractCachedResult get(int cacheId) {
        if (cacheId < 0 || cacheId >= this.cacheIdCounter.get()) {
            return null;
        }
        return (AbstractCachedResult)this.cache.getIfPresent((Object)cacheId);
    }

    public QueryResult getResult(int cacheId) {
        AbstractCachedResult acr = this.get(cacheId);
        return acr != null && acr instanceof QueryResult ? (QueryResult)acr : null;
    }

    public SerializedResult getSerializedResult(int cacheId) {
        AbstractCachedResult acr = this.get(cacheId);
        return acr != null && acr instanceof SerializedResult ? (SerializedResult)acr : null;
    }

    public void remove(int cacheId) {
        if (cacheId < 0 || cacheId >= this.cacheIdCounter.get()) {
            return;
        }
        this.cache.invalidate((Object)cacheId);
    }

    public void remove(int cacheId, int hash) {
        if (cacheId < 0 || cacheId >= this.cacheIdCounter.get()) {
            return;
        }
        AbstractCachedResult qr = (AbstractCachedResult)this.cache.getIfPresent((Object)cacheId);
        if (qr != null && qr.hashCode() == hash) {
            this.cache.invalidate((Object)cacheId);
        }
    }
}

