/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.lazy.AtomicLazyValE;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Predicate;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.exist.EXistException;
import org.exist.http.Descriptor;
import org.exist.http.servlets.HttpServletRequestWrapper;
import org.exist.xmlrpc.RpcConnection;
import org.exist.xmlrpc.XmldbRequestProcessorFactory;

public class RpcServlet
extends XmlRpcServlet {
    private static final long serialVersionUID = -1003413291835771186L;
    private static final Logger LOG = LogManager.getLogger(RpcServlet.class);
    private static final boolean DEFAULT_USE_DEFAULT_USER = true;
    private boolean useDefaultUser = true;

    public void init(ServletConfig pConfig) throws ServletException {
        String useDefaultUser = pConfig.getInitParameter("useDefaultUser");
        this.useDefaultUser = useDefaultUser != null ? Boolean.parseBoolean(useDefaultUser) : true;
        super.init((ServletConfig)new FilteredServletConfig(pConfig, paramName -> !"useDefaultUser".equals(paramName)));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Descriptor descriptor = Descriptor.getDescriptorSingleton();
        if (descriptor.allowRequestLogging() && !descriptor.requestsFiltered()) {
            request = new HttpServletRequestWrapper(request, "utf-8");
            descriptor.doLogRequestInReplayLog(request);
        }
        try {
            super.doPost(request, response);
        }
        catch (Throwable e) {
            String exceptionMessage;
            LOG.error("Problem during XmlRpc execution", e);
            if (e instanceof XmlRpcException) {
                Throwable linkedException = ((XmlRpcException)e).linkedException;
                LOG.error(linkedException.getMessage(), linkedException);
                exceptionMessage = "An error occurred: " + e.getMessage() + ": " + linkedException.getMessage();
            } else {
                exceptionMessage = "An unknown error occurred: " + e.getMessage();
            }
            throw new ServletException(exceptionMessage, e);
        }
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        DefaultHandlerMapping mapping = new DefaultHandlerMapping();
        mapping.setVoidMethodEnabled(true);
        mapping.setRequestProcessorFactoryFactory((RequestProcessorFactoryFactory)new XmldbRequestProcessorFactoryFactory(this.useDefaultUser));
        mapping.loadDefault(RpcConnection.class);
        return mapping;
    }

    private static class FilteredServletConfig
    implements ServletConfig {
        private final ServletConfig config;
        private final Predicate<String> parameterPredicate;

        private FilteredServletConfig(ServletConfig config, Predicate<String> parameterPredicate) {
            this.config = config;
            this.parameterPredicate = parameterPredicate;
        }

        public String getServletName() {
            return this.config.getServletName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String s) {
            if (this.parameterPredicate.test(s)) {
                return this.config.getInitParameter(s);
            }
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            Enumeration names = this.config.getInitParameterNames();
            ArrayList<String> filteredNames = new ArrayList<String>();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!this.parameterPredicate.test(name)) continue;
                filteredNames.add(name);
            }
            return Collections.enumeration(filteredNames);
        }
    }

    private static class DefaultHandlerMapping
    extends AbstractReflectiveHandlerMapping {
        private DefaultHandlerMapping() throws XmlRpcException {
        }

        public void loadDefault(Class<?> clazz) throws XmlRpcException {
            this.registerPublicMethods("Default", clazz);
        }

        public XmlRpcHandler getHandler(String pHandlerName) throws XmlRpcException {
            if (pHandlerName.indexOf(46) < 0) {
                pHandlerName = "Default." + pHandlerName;
            }
            return super.getHandler(pHandlerName);
        }
    }

    private static class XmldbRequestProcessorFactoryFactory
    extends RequestProcessorFactoryFactory.RequestSpecificProcessorFactoryFactory {
        private final AtomicLazyValE<RequestProcessorFactoryFactory.RequestProcessorFactory, XmlRpcException> instance = new AtomicLazyValE(() -> {
            try {
                return Either.Right((Object)new XmldbRequestProcessorFactory("exist", useDefaultUser));
            }
            catch (EXistException e) {
                return Either.Left((Object)((Object)new XmlRpcException("Failed to initialize XMLRPC interface: " + e.getMessage(), (Throwable)e)));
            }
        });

        public XmldbRequestProcessorFactoryFactory(boolean useDefaultUser) {
        }

        public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
            return (RequestProcessorFactoryFactory.RequestProcessorFactory)this.instance.get();
        }
    }
}

