/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfig;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.exist.EXistException;
import org.exist.security.AuthenticationException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xmlrpc.QueryResultCache;
import org.exist.xmlrpc.RpcConnection;

public class XmldbRequestProcessorFactory
implements RequestProcessorFactoryFactory.RequestProcessorFactory {
    private static final Logger LOG = LogManager.getLogger(XmldbRequestProcessorFactory.class);
    public static final int CHECK_INTERVAL = 2000;
    private final boolean useDefaultUser;
    private final BrokerPool brokerPool;
    protected final QueryResultCache resultSets = new QueryResultCache();
    protected String databaseId = BrokerPool.DEFAULT_INSTANCE_NAME;

    public XmldbRequestProcessorFactory(String databaseId, boolean useDefaultUser) throws EXistException {
        this.useDefaultUser = useDefaultUser;
        if (databaseId != null && !databaseId.isEmpty()) {
            this.databaseId = databaseId;
        }
        this.brokerPool = BrokerPool.getInstance(this.databaseId);
    }

    public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
        XmlRpcHttpRequestConfig config = (XmlRpcHttpRequestConfig)pRequest.getConfig();
        Subject user = this.authenticate(config.getBasicUserName(), config.getBasicPassword());
        return new RpcConnection(this, user);
    }

    protected Subject authenticate(String username, String password) throws XmlRpcException {
        if (username == null) {
            password = username = "guest";
        }
        if (!this.useDefaultUser && username.equalsIgnoreCase("guest")) {
            String message = "The user guest is prohibited from logging in through XML-RPC.";
            LOG.debug("The user guest is prohibited from logging in through XML-RPC.");
            throw new XmlRpcException(0, "The user guest is prohibited from logging in through XML-RPC.");
        }
        try {
            return this.brokerPool.getSecurityManager().authenticate(username, password);
        }
        catch (AuthenticationException e) {
            LOG.debug(e.getMessage());
            throw new XmlRpcException(0, e.getMessage());
        }
    }

    protected BrokerPool getBrokerPool() {
        return this.brokerPool;
    }

    public synchronized void shutdown() {
        this.brokerPool.shutdown();
    }
}

