/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xqj;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.InMemoryNodeSet;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.DBBroker;
import org.exist.xquery.NameTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Marshaller {
    public static final String NAMESPACE = "http://exist-db.org/xquery/types/serialized";
    public static final String PREFIX = "sx";
    private static final Properties OUTPUT_PROPERTIES = new Properties();
    private static final String VALUE_ELEMENT = "value";
    private static final String VALUE_ELEMENT_QNAME = "sx:value";
    private static final org.exist.dom.QName VALUE_QNAME = new org.exist.dom.QName("value", "http://exist-db.org/xquery/types/serialized", "sx");
    private static final String SEQ_ELEMENT = "sequence";
    private static final String SEQ_ELEMENT_QNAME = "sx:sequence";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ITEM_TYPE = "item-type";
    public static final org.exist.dom.QName ROOT_ELEMENT_QNAME = new org.exist.dom.QName("sequence", "http://exist-db.org/xquery/types/serialized", "sx");

    public static void marshall(DBBroker broker, Sequence seq, ContentHandler handler) throws XPathException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", ATTR_ITEM_TYPE, ATTR_ITEM_TYPE, "CDATA", Type.getTypeName(seq.getItemType()));
        handler.startElement(NAMESPACE, SEQ_ELEMENT, SEQ_ELEMENT_QNAME, attrs);
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Marshaller.marshallItem(broker, i.nextItem(), handler);
        }
        handler.endElement(NAMESPACE, SEQ_ELEMENT, SEQ_ELEMENT_QNAME);
    }

    public static void marshall(DBBroker broker, Sequence seq, int start, int howmany, ContentHandler handler) throws XPathException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", ATTR_ITEM_TYPE, ATTR_ITEM_TYPE, "CDATA", Type.getTypeName(seq.getItemType()));
        handler.startElement(NAMESPACE, SEQ_ELEMENT, SEQ_ELEMENT_QNAME, attrs);
        for (int i = start; i < howmany && i < seq.getItemCount(); ++i) {
            Marshaller.marshallItem(broker, seq.itemAt(i), handler);
        }
        handler.endElement(NAMESPACE, SEQ_ELEMENT, SEQ_ELEMENT_QNAME);
    }

    public static void marshallItem(DBBroker broker, Item item, ContentHandler handler) throws SAXException, XPathException {
        AttributesImpl attrs = new AttributesImpl();
        int type = item.getType();
        if (type == -1) {
            type = ((NodeValue)item).getNode().getNodeType();
        }
        attrs.addAttribute("", ATTR_TYPE, ATTR_TYPE, "CDATA", Type.getTypeName(type));
        if (Type.subTypeOf(item.getType(), -1)) {
            handler.startElement(NAMESPACE, VALUE_ELEMENT, VALUE_ELEMENT_QNAME, attrs);
            NodeValue nv = (NodeValue)item;
            nv.toSAX(broker, handler, OUTPUT_PROPERTIES);
            handler.endElement(NAMESPACE, VALUE_ELEMENT, VALUE_ELEMENT_QNAME);
        } else {
            handler.startElement(NAMESPACE, VALUE_ELEMENT, VALUE_ELEMENT_QNAME, attrs);
            String value = item.getStringValue();
            handler.characters(value.toCharArray(), 0, value.length());
            handler.endElement(NAMESPACE, VALUE_ELEMENT, VALUE_ELEMENT_QNAME);
        }
    }

    public static Sequence demarshall(DBBroker broker, Reader reader) throws XMLStreamException, XPathException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XMLStreamReader parser = factory.createXMLStreamReader(reader);
        return Marshaller.demarshall(broker, parser);
    }

    public static Sequence demarshall(DBBroker broker, Node n) throws XMLStreamException, XPathException {
        DOMSource source = new DOMSource(n, null);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XMLStreamReader parser = factory.createXMLStreamReader(source);
        return Marshaller.demarshall(broker, parser);
    }

    public static Sequence demarshall(DBBroker broker, XMLStreamReader parser) throws XMLStreamException, XPathException {
        int event = parser.next();
        while (event != 1) {
            event = parser.next();
        }
        if (!NAMESPACE.equals(parser.getNamespaceURI())) {
            throw new XMLStreamException("Root element is not in the correct namespace. Expected: http://exist-db.org/xquery/types/serialized");
        }
        if (!SEQ_ELEMENT.equals(parser.getLocalName())) {
            throw new XMLStreamException("Root element should be a sx:sequence");
        }
        ValueSequence result = new ValueSequence();
        block5: while ((event = parser.next()) != 8) {
            switch (event) {
                case 1: {
                    if (!NAMESPACE.equals(parser.getNamespaceURI()) || !VALUE_ELEMENT.equals(parser.getLocalName())) break;
                    String typeName = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!ATTR_TYPE.equals(parser.getAttributeLocalName(i))) continue;
                        typeName = parser.getAttributeValue(i);
                        break;
                    }
                    if (typeName == null) continue block5;
                    int type = Type.getType(typeName);
                    Item item = Type.subTypeOf(type, -1) ? Marshaller.streamToDOM(type, parser) : new StringValue(parser.getElementText()).convertTo(type);
                    result.add(item);
                    break;
                }
                case 2: {
                    if (!NAMESPACE.equals(parser.getNamespaceURI()) || !SEQ_ELEMENT.equals(parser.getLocalName())) break;
                    return result;
                }
            }
        }
        return result;
    }

    public static Sequence demarshall(NodeImpl node) throws XMLStreamException, XPathException {
        String ns = node.getNamespaceURI();
        if (ns == null || !NAMESPACE.equals(ns)) {
            throw new XMLStreamException("Root element is not in the correct namespace. Expected: http://exist-db.org/xquery/types/serialized");
        }
        if (!SEQ_ELEMENT.equals(node.getLocalName())) {
            throw new XMLStreamException("Root element should be a sx:sequence");
        }
        ValueSequence result = new ValueSequence();
        InMemoryNodeSet values = new InMemoryNodeSet();
        node.selectChildren(new NameTest(1, VALUE_QNAME), values);
        SequenceIterator i = values.iterate();
        while (i.hasNext()) {
            Item item;
            ElementImpl child = (ElementImpl)i.nextItem();
            String typeName = child.getAttribute(ATTR_TYPE);
            if (typeName == null) continue;
            int type = Type.getType(typeName);
            if (Type.subTypeOf(type, -1)) {
                item = (Item)((Object)child.getFirstChild());
                if (type == 6) {
                    DocumentImpl n = (DocumentImpl)item;
                    DocumentBuilderReceiver receiver = new DocumentBuilderReceiver();
                    try {
                        receiver.startDocument();
                        n.copyTo(n, receiver);
                        receiver.endDocument();
                    }
                    catch (SAXException e) {
                        throw new XPathException("Error while demarshalling node: " + e.getMessage(), (Throwable)e);
                    }
                    item = (Item)((Object)receiver.getDocument());
                }
            } else {
                StringBuilder data = new StringBuilder();
                for (Node txt = child.getFirstChild(); txt != null; txt = txt.getNextSibling()) {
                    if (txt.getNodeType() != 3 && txt.getNodeType() != 4) {
                        throw new XMLStreamException("sx:value should only contain text if type is " + typeName);
                    }
                    data.append(txt.getNodeValue());
                }
                item = new StringValue(data.toString()).convertTo(type);
            }
            result.add(item);
        }
        return result;
    }

    public static Item streamToDOM(XMLStreamReader parser, XQItemType type) throws XMLStreamException, XQException {
        if (type.getBaseType() == 5 || type.getBaseType() == 6) {
            return Marshaller.streamToDOM(6, parser);
        }
        return Marshaller.streamToDOM(1, parser);
    }

    public static Item streamToDOM(int rootType, XMLStreamReader parser) throws XMLStreamException {
        int event;
        MemTreeBuilder builder = new MemTreeBuilder();
        builder.startDocument();
        boolean finish = false;
        while ((event = parser.next()) != 8) {
            switch (event) {
                case 1: {
                    AttributesImpl attribs = new AttributesImpl();
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        QName qn = parser.getAttributeName(i);
                        attribs.addAttribute(qn.getNamespaceURI(), qn.getLocalPart(), qn.getPrefix() + ':' + qn.getLocalPart(), parser.getAttributeType(i), parser.getAttributeValue(i));
                    }
                    builder.startElement(org.exist.dom.QName.fromJavaQName(parser.getName()), attribs);
                    break;
                }
                case 2: {
                    if (NAMESPACE.equals(parser.getNamespaceURI()) && VALUE_ELEMENT.equals(parser.getLocalName())) {
                        finish = true;
                        break;
                    }
                    builder.endElement();
                    break;
                }
                case 4: {
                    builder.characters(parser.getText());
                }
            }
            if (!finish) continue;
        }
        builder.endDocument();
        if (rootType == 6) {
            return builder.getDocument();
        }
        if (rootType == 1) {
            return (NodeImpl)((Object)builder.getDocument().getDocumentElement());
        }
        return (NodeImpl)builder.getDocument().getFirstChild();
    }

    public static Item streamToDOM(Reader reader, XQItemType type) throws XMLStreamException, XQException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XMLStreamReader parser = factory.createXMLStreamReader(reader);
        return Marshaller.streamToDOM(parser, type);
    }

    public static Node streamToNode(String content) throws XMLStreamException {
        StringReader reader = new StringReader(content);
        return Marshaller.streamToNode(reader);
    }

    public static Node streamToNode(Reader reader) throws XMLStreamException {
        int event;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XMLStreamReader parser = factory.createXMLStreamReader(reader);
        MemTreeBuilder builder = new MemTreeBuilder();
        builder.startDocument();
        boolean finish = false;
        while ((event = parser.next()) != 8) {
            switch (event) {
                case 1: {
                    AttributesImpl attribs = new AttributesImpl();
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        QName qn = parser.getAttributeName(i);
                        attribs.addAttribute(qn.getNamespaceURI(), qn.getLocalPart(), qn.getPrefix() + ':' + qn.getLocalPart(), parser.getAttributeType(i), parser.getAttributeValue(i));
                    }
                    builder.startElement(org.exist.dom.QName.fromJavaQName(parser.getName()), attribs);
                    break;
                }
                case 2: {
                    if (NAMESPACE.equals(parser.getNamespaceURI()) && VALUE_ELEMENT.equals(parser.getLocalName())) {
                        finish = true;
                        break;
                    }
                    builder.endElement();
                    break;
                }
                case 4: {
                    builder.characters(parser.getText());
                }
            }
            if (!finish) continue;
        }
        builder.endDocument();
        return builder.getDocument().getDocumentElement();
    }
}

