/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.source.Source;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class AbstractExpression
implements Expression {
    private int expressionId = -1;
    protected XQueryContext context;
    protected int line = -1;
    protected int column = -1;
    protected DocumentSet contextDocSet = null;
    protected int contextId = -1;
    protected boolean unordered = false;

    public AbstractExpression(XQueryContext context) {
        this.context = context;
        this.expressionId = context.nextExpressionId();
    }

    @Override
    public int getExpressionId() {
        return this.expressionId;
    }

    @Override
    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public int getContextId() {
        return this.contextId;
    }

    @Override
    public Sequence eval(Sequence contextSequence) throws XPathException {
        return this.eval(contextSequence, null);
    }

    @Override
    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    @Override
    public abstract int returnsType();

    @Override
    public void resetState(boolean postOptimization) {
        this.contextDocSet = null;
    }

    @Override
    public boolean needsReset() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public void setPrimaryAxis(int axis) {
    }

    @Override
    public int getPrimaryAxis() {
        return -1;
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        this.contextDocSet = contextSet;
    }

    @Override
    public DocumentSet getContextDocSet() {
        return this.contextDocSet;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setASTNode(XQueryAST ast) {
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    @Override
    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public Source getSource() {
        return this.context.getSource();
    }

    @Override
    public XQueryContext getContext() {
        return this.context;
    }

    @Override
    public int getSubExpressionCount() {
        return 0;
    }

    @Override
    public Expression getSubExpression(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSubExpressionCount());
    }

    @Override
    public Boolean match(Sequence contextSequence, Item item) throws XPathException {
        return false;
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return false;
    }

    @Override
    public Expression simplify() {
        return this;
    }

    @Override
    public Expression getParent() {
        return null;
    }
}

