/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public abstract class AbstractFLWORClause
extends AbstractExpression
implements FLWORClause {
    protected LocalVariable firstVar = null;
    private FLWORClause previousClause = null;
    protected Expression returnExpr;
    private int actualReturnType = 11;

    public AbstractFLWORClause(XQueryContext context) {
        super(context);
    }

    @Override
    public LocalVariable createVariable(String name) throws XPathException {
        try {
            LocalVariable var;
            this.firstVar = var = new LocalVariable(QName.parse(this.context, name, null));
            return var;
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + name);
        }
    }

    @Override
    public Sequence preEval(Sequence seq) throws XPathException {
        if (this.returnExpr instanceof FLWORClause) {
            return ((FLWORClause)this.returnExpr).preEval(seq);
        }
        return seq;
    }

    @Override
    public Sequence postEval(Sequence seq) throws XPathException {
        this.firstVar = null;
        return seq;
    }

    @Override
    public void setReturnExpression(Expression expr) {
        this.returnExpr = expr;
    }

    @Override
    public Expression getReturnExpression() {
        return this.returnExpr;
    }

    @Override
    public LocalVariable getStartVariable() {
        return this.firstVar;
    }

    @Override
    public void setPreviousClause(FLWORClause clause) {
        this.previousClause = clause;
    }

    @Override
    public FLWORClause getPreviousClause() {
        return this.previousClause;
    }

    protected void setActualReturnType(int type) {
        this.actualReturnType = type;
    }

    @Override
    public int returnsType() {
        return this.actualReturnType;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.firstVar = null;
    }

    @Override
    public int getDependencies() {
        return this.returnExpr.getDependencies();
    }
}

