/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.exist.dom.QName;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalModule;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public abstract class AbstractInternalModule
implements InternalModule {
    protected final FunctionDef[] mFunctions;
    protected final boolean ordered;
    private final Map<String, List<? extends Object>> parameters;
    protected final TreeMap<QName, Variable> mGlobalVariables = new TreeMap();

    public AbstractInternalModule(FunctionDef[] functions, Map<String, List<? extends Object>> parameters) {
        this(functions, parameters, false);
    }

    public AbstractInternalModule(FunctionDef[] functions, Map<String, List<? extends Object>> parameters, boolean functionsOrdered) {
        this.mFunctions = functions;
        this.ordered = functionsOrdered;
        this.parameters = parameters;
    }

    @Override
    public boolean isInternalModule() {
        return true;
    }

    protected List<? extends Object> getParameter(String paramName) {
        return this.parameters.get(paramName);
    }

    @Override
    public void setContextItem(Sequence contextItem) {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public FunctionSignature[] listFunctions() {
        FunctionSignature[] signatures = new FunctionSignature[this.mFunctions.length];
        for (int i = 0; i < signatures.length; ++i) {
            signatures[i] = this.mFunctions[i].getSignature();
        }
        return signatures;
    }

    @Override
    public Iterator<FunctionSignature> getSignaturesForFunction(QName qname) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        for (int i = 0; i < this.mFunctions.length; ++i) {
            FunctionSignature signature = this.mFunctions[i].getSignature();
            if (signature.getName().compareTo(qname) != 0) continue;
            signatures.add(signature);
        }
        return signatures.iterator();
    }

    @Override
    public FunctionDef getFunctionDef(QName qname, int arity) {
        FunctionId id = new FunctionId(qname, arity);
        if (this.ordered) {
            return this.binarySearch(id);
        }
        for (int i = 0; i < this.mFunctions.length; ++i) {
            if (id.compareTo(this.mFunctions[i].getSignature().getFunctionId()) != 0) continue;
            return this.mFunctions[i];
        }
        return null;
    }

    private FunctionDef binarySearch(FunctionId id) {
        int low = 0;
        int high = this.mFunctions.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            FunctionDef midVal = this.mFunctions[mid];
            int cmp = midVal.getSignature().getFunctionId().compareTo(id);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    @Override
    public List<FunctionSignature> getFunctionsByName(QName qname) {
        ArrayList<FunctionSignature> funcs = new ArrayList<FunctionSignature>();
        for (int i = 0; i < this.mFunctions.length; ++i) {
            FunctionSignature sig = this.mFunctions[i].getSignature();
            if (sig.getName().compareTo(qname) != 0) continue;
            funcs.add(sig);
        }
        return funcs;
    }

    @Override
    public Iterator<QName> getGlobalVariables() {
        return this.mGlobalVariables.keySet().iterator();
    }

    @Override
    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value, null);
        Variable var = this.mGlobalVariables.get(qname);
        if (var == null) {
            var = new VariableImpl(qname);
            this.mGlobalVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    @Override
    public Variable declareVariable(Variable var) {
        this.mGlobalVariables.put(var.getQName(), var);
        return var;
    }

    @Override
    public Variable resolveVariable(QName qname) throws XPathException {
        return this.mGlobalVariables.get(qname);
    }

    @Override
    public boolean isVarDeclared(QName qname) {
        return this.mGlobalVariables.get(qname) != null;
    }

    @Override
    public void reset(XQueryContext context) {
    }

    @Override
    public void reset(XQueryContext xqueryContext, boolean keepGlobals) {
        this.reset(xqueryContext);
        if (!keepGlobals) {
            this.mGlobalVariables.clear();
        }
    }

    public static class FunctionComparator
    implements Comparator<FunctionDef> {
        @Override
        public int compare(FunctionDef o1, FunctionDef o2) {
            return o1.getSignature().getFunctionId().compareTo(o2.getSignature().getFunctionId());
        }
    }
}

