/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ExtNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.xquery.NodeSelector;

public class AncestorSelector
implements NodeSelector {
    private NodeSet ancestors;
    private NodeSet descendants = null;
    private int contextId;
    private boolean includeSelf;
    private boolean copyMatches;

    public AncestorSelector(NodeSet descendants, int contextId, boolean includeSelf, boolean copyMatches) {
        this.contextId = contextId;
        this.includeSelf = includeSelf;
        this.copyMatches = copyMatches;
        if (descendants instanceof ExtNodeSet) {
            this.descendants = descendants;
        } else {
            this.ancestors = descendants.getAncestors(contextId, includeSelf);
        }
    }

    @Override
    public NodeProxy match(DocumentImpl doc, NodeId nodeId) {
        if (this.descendants == null) {
            return this.ancestors.get(doc, nodeId);
        }
        return ((ExtNodeSet)this.descendants).hasDescendantsInSet(doc, nodeId, this.includeSelf, this.contextId, this.copyMatches);
    }
}

