/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.xquery.Atomize;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.CastExpression;
import org.exist.xquery.ConditionalExpression;
import org.exist.xquery.DocumentConstructor;
import org.exist.xquery.DynamicAttributeConstructor;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicNameCheck;
import org.exist.xquery.DynamicTextConstructor;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.ElementConstructor;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FilteredExpression;
import org.exist.xquery.ForExpr;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.GroupByClause;
import org.exist.xquery.Intersect;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocationStep;
import org.exist.xquery.OpAnd;
import org.exist.xquery.OpOr;
import org.exist.xquery.OpSimpleMap;
import org.exist.xquery.OrderByClause;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.TryCatchExpression;
import org.exist.xquery.Union;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.VariableReference;
import org.exist.xquery.WhereClause;

public class BasicExpressionVisitor
implements ExpressionVisitor {
    @Override
    public void visit(Expression expression) {
        this.processWrappers(expression);
    }

    @Override
    public void visitCastExpr(CastExpression expression) {
    }

    @Override
    public void visitPathExpr(PathExpr expression) {
        if (expression.getLength() == 1) {
            Expression next = expression.getExpression(0);
            next.accept(this);
        }
    }

    @Override
    public void visitFunctionCall(FunctionCall call) {
    }

    @Override
    public void visitGeneralComparison(GeneralComparison comparison) {
    }

    @Override
    public void visitUnionExpr(Union union) {
    }

    @Override
    public void visitIntersectionExpr(Intersect intersect) {
    }

    @Override
    public void visitAndExpr(OpAnd and) {
    }

    @Override
    public void visitOrExpr(OpOr or) {
    }

    @Override
    public void visitLocationStep(LocationStep locationStep) {
    }

    @Override
    public void visitFilteredExpr(FilteredExpression filtered) {
    }

    @Override
    public void visitPredicate(Predicate predicate) {
    }

    @Override
    public void visitVariableReference(VariableReference ref) {
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration decl) {
    }

    protected void processWrappers(Expression expr) {
        if (expr instanceof Atomize || expr instanceof DynamicCardinalityCheck || expr instanceof DynamicNameCheck || expr instanceof DynamicTypeCheck || expr instanceof UntypedValueCheck) {
            expr.accept(this);
        }
    }

    public static LocationStep findFirstStep(Expression expr) {
        if (expr instanceof LocationStep) {
            return (LocationStep)expr;
        }
        FirstStepVisitor visitor = new FirstStepVisitor();
        expr.accept(visitor);
        return visitor.firstStep;
    }

    public static List<LocationStep> findLocationSteps(Expression expr) {
        final ArrayList<LocationStep> steps = new ArrayList<LocationStep>(5);
        if (expr instanceof LocationStep) {
            steps.add((LocationStep)expr);
            return steps;
        }
        expr.accept(new BasicExpressionVisitor(){

            @Override
            public void visitPathExpr(PathExpr expression) {
                for (int i = 0; i < expression.getLength(); ++i) {
                    Expression next = expression.getExpression(i);
                    next.accept(this);
                    if (steps.size() - 1 == i) continue;
                    steps.add(null);
                }
            }

            @Override
            public void visitLocationStep(LocationStep locationStep) {
                steps.add(locationStep);
            }
        });
        return steps;
    }

    public static VariableReference findVariableRef(Expression expr) {
        VariableRefVisitor visitor = new VariableRefVisitor();
        expr.accept(visitor);
        return visitor.ref;
    }

    @Override
    public void visitForExpression(ForExpr forExpr) {
    }

    @Override
    public void visitLetExpression(LetExpr letExpr) {
    }

    @Override
    public void visitOrderByClause(OrderByClause orderBy) {
    }

    @Override
    public void visitGroupByClause(GroupByClause groupBy) {
    }

    @Override
    public void visitWhereClause(WhereClause where) {
    }

    @Override
    public void visitBuiltinFunction(Function function) {
    }

    @Override
    public void visitUserFunction(UserDefinedFunction function) {
    }

    @Override
    public void visitConditional(ConditionalExpression conditional) {
    }

    @Override
    public void visitTryCatch(TryCatchExpression conditional) {
    }

    @Override
    public void visitDocumentConstructor(DocumentConstructor constructor) {
    }

    @Override
    public void visitElementConstructor(ElementConstructor constructor) {
    }

    @Override
    public void visitTextConstructor(DynamicTextConstructor constructor) {
    }

    @Override
    public void visitAttribConstructor(AttributeConstructor constructor) {
    }

    @Override
    public void visitAttribConstructor(DynamicAttributeConstructor constructor) {
    }

    @Override
    public void visitSimpleMapOperator(OpSimpleMap simpleMap) {
    }

    public static class VariableRefVisitor
    extends BasicExpressionVisitor {
        private VariableReference ref = null;

        @Override
        public void visitVariableReference(VariableReference ref) {
            this.ref = ref;
        }

        @Override
        public void visitPathExpr(PathExpr expression) {
            for (int i = 0; i < expression.getLength(); ++i) {
                Expression next = expression.getExpression(i);
                next.accept(this);
            }
        }
    }

    public static class FirstStepVisitor
    extends BasicExpressionVisitor {
        private LocationStep firstStep = null;

        public LocationStep getFirstStep() {
            return this.firstStep;
        }

        @Override
        public void visitLocationStep(LocationStep locationStep) {
            this.firstStep = locationStep;
        }
    }
}

