/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.xquery.AbstractFLWORClause;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public abstract class BindingExpression
extends AbstractFLWORClause
implements RewritableExpression {
    protected static final Logger LOG = LogManager.getLogger(BindingExpression.class);
    protected static final SequenceType POSITIONAL_VAR_TYPE = new SequenceType(31, 2);
    protected String varName;
    protected SequenceType sequenceType = null;
    protected Expression inputSequence;
    private ExprUpdateListener listener;

    public BindingExpression(XQueryContext context) {
        super(context);
    }

    public void setVariable(String qname) {
        this.varName = qname;
    }

    public String getVariable() {
        return this.varName;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public void setInputSequence(Expression sequence) {
        this.inputSequence = sequence.simplify();
    }

    public Expression getInputSequence() {
        return this.inputSequence;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
    }

    @Override
    public Sequence postEval(Sequence seq) throws XPathException {
        if (this.returnExpr instanceof FLWORClause) {
            seq = ((FLWORClause)this.returnExpr).postEval(seq);
        }
        return super.postEval(seq);
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.inputSequence.resetState(postOptimization);
        this.returnExpr.resetState(postOptimization);
    }

    public static final void setContext(int contextId, Sequence seq) throws XPathException {
        if (seq instanceof VirtualNodeSet) {
            ((VirtualNodeSet)seq).setInPredicate(true);
            ((VirtualNodeSet)seq).setSelfIsContext();
        } else {
            SequenceIterator i = seq.unorderedIterator();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (!(next instanceof NodeProxy)) continue;
                ((NodeProxy)next).addContextNode(contextId, (NodeProxy)next);
            }
        }
    }

    public static final void clearContext(int contextId, Sequence seq) throws XPathException {
        if (seq != null && !(seq instanceof VirtualNodeSet)) {
            seq.clearContext(contextId);
        }
    }

    protected void registerUpdateListener(Sequence sequence) {
        if (this.listener == null) {
            this.listener = new ExprUpdateListener(sequence);
            this.context.registerUpdateListener(this.listener);
        } else {
            this.listener.setSequence(sequence);
        }
    }

    @Override
    public int returnsType() {
        if (this.sequenceType != null) {
            return this.sequenceType.getPrimaryType();
        }
        return super.returnsType();
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        if (this.inputSequence == oldExpr) {
            this.inputSequence = newExpr;
        } else if (this.returnExpr == oldExpr) {
            this.returnExpr = newExpr;
        }
    }

    @Override
    public Expression getPrevious(Expression current) {
        return null;
    }

    @Override
    public Expression getFirst() {
        return null;
    }

    @Override
    public void remove(Expression oldExpr) throws XPathException {
    }

    private class ExprUpdateListener
    implements UpdateListener {
        private Sequence sequence;

        public ExprUpdateListener(Sequence sequence) {
            this.sequence = sequence;
        }

        public void setSequence(Sequence sequence) {
            this.sequence = sequence;
        }

        @Override
        public void documentUpdated(DocumentImpl document, int event) {
        }

        @Override
        public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
            this.sequence.nodeMoved(oldNodeId, newNode);
        }

        @Override
        public void unsubscribe() {
            BindingExpression.this.listener = null;
        }

        @Override
        public void debug() {
        }
    }
}

