/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class CDATAConstructor
extends NodeConstructor {
    private final String cdata;
    private boolean literalCharacters = false;

    public CDATAConstructor(XQueryContext context, String content) {
        super(context);
        this.cdata = content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            int nodeNr;
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            if (this.literalCharacters) {
                if (this.cdata.isEmpty()) {
                    Sequence sequence = Sequence.EMPTY_SEQUENCE;
                    return sequence;
                }
                nodeNr = builder.characters(this.cdata);
            } else {
                nodeNr = builder.cdataSection(this.cdata);
            }
            NodeImpl node = builder.getDocument().getNode(nodeNr);
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "", node);
            }
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.literalCharacters = (contextInfo.getFlags() & 0x100) != 0;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("<![CDATA[").display(this.cdata).display("]]>");
    }

    public String toString() {
        return "<![CDATA[" + this.cdata + "]]>";
    }
}

