/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CastableExpression
extends AbstractExpression {
    private Expression expression;
    private int requiredCardinality;
    private final int requiredType;

    public CastableExpression(XQueryContext context, Expression expr, int requiredType, int requiredCardinality) {
        super(context);
        this.expression = expr;
        this.requiredType = requiredType;
        this.requiredCardinality = requiredCardinality;
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.requiredType == 20 || this.requiredType == 28 && this.expression.returnsType() != 28) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0080, "cannot convert to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 13 || this.expression.returnsType() == 13 || this.requiredType == 14 || this.expression.returnsType() == 14) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0051, "cannot convert to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 24 && Dependency.dependsOnVar(this.expression)) {
            result = BooleanValue.FALSE;
        } else {
            Sequence seq = Atomize.atomize(this.expression.eval(contextSequence, contextItem));
            if (seq.isEmpty()) {
                result = Cardinality.checkCardinality(this.requiredCardinality, 1) ? BooleanValue.TRUE : BooleanValue.FALSE;
            } else {
                try {
                    seq.itemAt(0).convertTo(this.requiredType);
                    result = Cardinality.checkCardinality(this.requiredCardinality, seq.getCardinality()) ? BooleanValue.TRUE : BooleanValue.FALSE;
                }
                catch (XPathException e) {
                    result = BooleanValue.FALSE;
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" castable as ");
        dumper.display(Type.getTypeName(this.requiredType));
    }

    public String toString() {
        return this.expression.toString() + " castable as " + Type.getTypeName(this.requiredType);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }
}

