/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class CombiningExpression
extends AbstractExpression {
    protected final PathExpr left;
    protected final PathExpr right;

    public CombiningExpression(XQueryContext context, PathExpr left, PathExpr right) {
        super(context);
        this.left = left;
        this.right = right;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.left.analyze(contextInfo);
        this.right.analyze(contextInfo);
    }

    @Override
    public final Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence ls = this.left.eval(contextSequence, contextItem);
        Sequence rs = this.right.eval(contextSequence, contextItem);
        ls.removeDuplicates();
        rs.removeDuplicates();
        Sequence result = this.combine(ls, rs);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    protected abstract Sequence combine(Sequence var1, Sequence var2) throws XPathException;

    @Override
    public final void dump(ExpressionDumper dumper) {
        this.left.dump(dumper);
        dumper.display(" " + this.getOperatorName() + " ");
        this.right.dump(dumper);
    }

    public String toString() {
        return this.left.toString() + " " + this.getOperatorName() + " " + this.right.toString();
    }

    protected abstract String getOperatorName();

    @Override
    public int returnsType() {
        return -1;
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.left.setContextDocSet(contextSet);
        this.right.setContextDocSet(contextSet);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.left.resetState(postOptimization);
        this.right.resetState(postOptimization);
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.left.setPrimaryAxis(axis);
        this.right.setPrimaryAxis(axis);
    }

    @Override
    public int getPrimaryAxis() {
        return this.left.getPrimaryAxis();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.left.accept(visitor);
        this.right.accept(visitor);
    }
}

