/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class ConditionalExpression
extends AbstractExpression
implements RewritableExpression {
    private Expression testExpr;
    private Expression thenExpr;
    private Expression elseExpr;

    public ConditionalExpression(XQueryContext context, Expression testExpr, Expression thenExpr, Expression elseExpr) {
        super(context);
        this.testExpr = testExpr.simplify();
        this.thenExpr = thenExpr.simplify();
        this.elseExpr = elseExpr.simplify();
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    public Expression getTestExpr() {
        return this.testExpr;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    @Override
    public int getCardinality() {
        return this.thenExpr.getCardinality() | this.elseExpr.getCardinality();
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo myContextInfo = new AnalyzeContextInfo(contextInfo);
        myContextInfo.setFlags(myContextInfo.getFlags() & 0xFFFFFFFD);
        myContextInfo.setParent(this);
        this.testExpr.analyze(myContextInfo);
        myContextInfo.setParent(this);
        this.thenExpr.analyze(myContextInfo);
        myContextInfo.setParent(this);
        this.elseExpr.analyze(myContextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.expressionStart(this);
        Sequence testSeq = this.testExpr.eval(contextSequence, contextItem);
        try {
            if (testSeq.effectiveBooleanValue()) {
                Sequence sequence = this.thenExpr.eval(contextSequence, contextItem);
                return sequence;
            }
            Sequence sequence = this.elseExpr.eval(contextSequence, contextItem);
            return sequence;
        }
        catch (XPathException e) {
            if (e.getLine() == 0) {
                e.setLocation(this.line, this.column);
            }
            throw e;
        }
        finally {
            this.context.expressionEnd(this);
        }
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("if (");
        dumper.startIndent();
        this.testExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display(") then");
        dumper.startIndent();
        this.thenExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("else");
        dumper.startIndent();
        this.elseExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        return "if ( " + this.testExpr.toString() + " ) then " + this.thenExpr.toString() + " else " + this.elseExpr.toString();
    }

    @Override
    public int returnsType() {
        return Type.getCommonSuperType(this.thenExpr.returnsType(), this.elseExpr.returnsType());
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.testExpr.resetState(postOptimization);
        this.thenExpr.resetState(postOptimization);
        this.elseExpr.resetState(postOptimization);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitConditional(this);
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        if (this.testExpr == oldExpr) {
            this.testExpr = newExpr;
        } else if (this.thenExpr == oldExpr) {
            this.thenExpr = newExpr;
        } else if (this.elseExpr == oldExpr) {
            this.elseExpr = newExpr;
        }
    }

    @Override
    public Expression getPrevious(Expression current) {
        return null;
    }

    @Override
    public Expression getFirst() {
        return null;
    }

    @Override
    public void remove(Expression oldExpr) throws XPathException {
    }
}

