/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class ContextItemDeclaration
extends AbstractExpression
implements RewritableExpression {
    private static final Logger LOG = LogManager.getLogger(ContextItemDeclaration.class);
    private final Optional<SequenceType> itemType;
    private final boolean external;
    private Optional<Expression> value;

    public ContextItemDeclaration(XQueryContext context, SequenceType itemType, boolean external, Expression value) {
        super(context);
        this.itemType = Optional.ofNullable(itemType);
        this.external = external;
        this.value = Optional.ofNullable(value);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        if (this.value.isPresent()) {
            this.value.get().analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (this.external) {
            if (this.value.isPresent()) {
                return this.value.get().eval(null, null);
            }
            return null;
        }
        return this.value.get().eval(null, null);
    }

    @Override
    public int returnsType() {
        return this.itemType.map(it -> it.getPrimaryType()).orElseGet(() -> this.value.map(exp -> exp.returnsType()).orElse(11));
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.nl().display("declare context item", this.line);
        this.itemType.map(it -> dumper.display(" as ").display(it.toString()));
        if (this.external) {
            dumper.display(" external ");
        }
        if (this.value.isPresent()) {
            dumper.display(" := ");
            this.value.get().dump(dumper);
        }
        dumper.nl();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("declare context item");
        this.itemType.map(it -> result.append(" as ").append(it.toString()));
        if (this.external) {
            result.append(" external ");
        }
        this.value.map(v -> result.append(" := ").append(v.toString()));
        return result.toString();
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        if (this.value.isPresent() && this.value.get() == oldExpr) {
            this.value = Optional.ofNullable(newExpr);
        }
    }

    @Override
    public void remove(Expression oldExpr) throws XPathException {
    }

    @Override
    public Expression getPrevious(Expression current) {
        return null;
    }

    @Override
    public Expression getFirst() {
        return null;
    }
}

