/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public abstract class DeferredFunctionCall
implements Sequence {
    private static final Logger LOG = LogManager.getLogger(DeferredFunctionCall.class);
    private FunctionSignature signature;
    private Sequence sequence = null;
    private XPathException caughtException = null;

    protected DeferredFunctionCall(FunctionSignature signature) {
        this.signature = signature;
    }

    private void realize() throws XPathException {
        if (this.caughtException != null) {
            throw this.caughtException;
        }
        if (this.sequence == null) {
            this.sequence = this.execute();
        }
    }

    protected FunctionSignature getSignature() {
        return this.signature;
    }

    protected abstract Sequence execute() throws XPathException;

    @Override
    public void add(Item item) throws XPathException {
        this.realize();
        this.sequence.add(item);
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        this.realize();
        this.sequence.addAll(other);
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        if (this.sequence != null) {
            this.sequence.clearContext(contextId);
        }
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (this.sequence != null) {
            return this.sequence.conversionPreference(javaClass);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        this.realize();
        return this.sequence.convertTo(requiredType);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        this.realize();
        return this.sequence.effectiveBooleanValue();
    }

    @Override
    public int getCardinality() {
        try {
            this.realize();
            return this.sequence.getCardinality();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return 0;
        }
    }

    @Override
    public DocumentSet getDocumentSet() {
        try {
            this.realize();
            return this.sequence.getDocumentSet();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        try {
            this.realize();
            return this.sequence.getCollectionIterator();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return null;
        }
    }

    @Override
    public int getItemType() {
        try {
            this.realize();
            return this.sequence.getItemType();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return 12;
        }
    }

    @Override
    public int getItemCount() {
        try {
            this.realize();
            return this.sequence.getItemCount();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return 0;
        }
    }

    @Override
    public String getStringValue() throws XPathException {
        this.realize();
        return this.sequence.getStringValue();
    }

    @Override
    public Sequence tail() throws XPathException {
        this.realize();
        return this.sequence.tail();
    }

    @Override
    public boolean hasMany() {
        try {
            this.realize();
            return this.sequence.hasMany();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean hasOne() {
        try {
            this.realize();
            return this.sequence.hasOne();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isCached() {
        try {
            this.realize();
            return this.sequence.isCached();
        }
        catch (XPathException e) {
            this.caughtException = e;
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.realize();
            return this.sequence.isEmpty();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isPersistentSet() {
        try {
            this.realize();
            return this.sequence.isPersistentSet();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Item itemAt(int pos) {
        try {
            this.realize();
            return this.sequence.itemAt(pos);
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
            return null;
        }
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.realize();
        return this.sequence.iterate();
    }

    @Override
    public void removeDuplicates() {
        try {
            this.realize();
            this.sequence.removeDuplicates();
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
        }
    }

    @Override
    public void setIsCached(boolean cached) {
        try {
            this.realize();
            this.sequence.setIsCached(cached);
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
        }
    }

    @Override
    public void setSelfAsContext(int contextId) throws XPathException {
        try {
            this.realize();
            this.sequence.setSelfAsContext(contextId);
        }
        catch (XPathException e) {
            this.caughtException = e;
            LOG.error("Exception in deferred function: " + e.getMessage());
        }
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        this.realize();
        return this.sequence.toJavaObject(target);
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        this.realize();
        return this.sequence.toNodeSet();
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        this.realize();
        return this.sequence.toMemNodeSet();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        this.realize();
        return this.sequence.unorderedIterator();
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return true;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
    }
}

