/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicCommentConstructor
extends NodeConstructor {
    private final Expression content;

    public DynamicCommentConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = contentExpr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setParent(this);
        this.content.analyze(contextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            Sequence contentSeq = this.content.eval(contextSequence, contextItem);
            if (contentSeq.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else {
                MemTreeBuilder builder = this.context.getDocumentBuilder();
                this.context.proceed(this, builder);
                StringBuilder buf = new StringBuilder();
                SequenceIterator i = Atomize.atomize(contentSeq).iterate();
                while (i.hasNext()) {
                    this.context.proceed(this, builder);
                    Item next = i.nextItem();
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(next.toString());
                }
                if (buf.indexOf("--") != -1 || buf.toString().endsWith("-")) {
                    throw new XPathException((Expression)this, ErrorCodes.XQDY0072, "'" + buf.toString() + "' is not a valid comment");
                }
                int nodeNr = builder.comment(buf.toString());
                result = builder.getDocument().getNode(nodeNr);
            }
        }
        finally {
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("comment {");
        dumper.startIndent();
        this.content.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        return "comment {" + this.content.toString() + "} ";
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.content.resetState(postOptimization);
    }
}

