/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.DynamicAttributeConstructor;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.xml.sax.helpers.AttributesImpl;

public class ElementConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private PathExpr content = null;
    private AttributeConstructor[] attributes = null;
    private QName[] namespaceDecls = null;
    protected static final Logger LOG = LogManager.getLogger(ElementConstructor.class);

    public ElementConstructor(XQueryContext context) {
        super(context);
    }

    public ElementConstructor(XQueryContext context, String qname) {
        super(context);
        this.qnameExpr = new LiteralValue(context, new StringValue(qname));
    }

    public void setContent(PathExpr path) {
        this.content = path;
        this.content.setUseStaticContext(true);
    }

    public PathExpr getContent() {
        return this.content;
    }

    public AttributeConstructor[] getAttributes() {
        return this.attributes;
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = expr;
    }

    public Expression getNameExpr() {
        return this.qnameExpr;
    }

    public void addAttribute(AttributeConstructor attr) throws XPathException {
        if (attr.isNamespaceDeclaration()) {
            if ("xmlns".equals(attr.getQName())) {
                this.addNamespaceDecl("", attr.getLiteralValue());
            } else {
                try {
                    this.addNamespaceDecl(QName.extractLocalName(attr.getQName()), attr.getLiteralValue());
                }
                catch (QName.IllegalQNameException e) {
                    throw new XPathException(ErrorCodes.XPST0081, "Invalid qname " + attr.getQName());
                }
            }
        } else if (this.attributes == null) {
            this.attributes = new AttributeConstructor[1];
            this.attributes[0] = attr;
        } else {
            AttributeConstructor[] natts = new AttributeConstructor[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, natts, 0, this.attributes.length);
            natts[this.attributes.length] = attr;
            this.attributes = natts;
        }
    }

    public void addNamespaceDecl(String name, String uri) throws XPathException {
        QName qn = new QName(name, uri, "xmlns");
        if ("xml".equals(name) && !"http://www.w3.org/XML/1998/namespace".equals(uri) || "xmlns".equals(name) && !"".equals(uri)) {
            throw new XPathException((Expression)this, ErrorCodes.XQST0070, "can not redefine '" + qn + "'");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri) && !"xml".equals(name)) {
            throw new XPathException((Expression)this, ErrorCodes.XQST0070, "'http://www.w3.org/XML/1998/namespace' can bind only to 'xml' prefix");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri) && !"xmlns".equals(name)) {
            throw new XPathException((Expression)this, ErrorCodes.XQST0070, "'http://www.w3.org/2000/xmlns/' can bind only to 'xmlns' prefix");
        }
        if (name != null && !name.isEmpty() && uri.trim().isEmpty()) {
            throw new XPathException((Expression)this, ErrorCodes.XQST0085, "cannot undeclare a prefix " + name + ".");
        }
        this.addNamespaceDecl(qn);
    }

    private void addNamespaceDecl(QName qn) throws XPathException {
        if (this.namespaceDecls == null) {
            this.namespaceDecls = new QName[1];
            this.namespaceDecls[0] = qn;
        } else {
            for (int i = 0; i < this.namespaceDecls.length; ++i) {
                if (!qn.equals(this.namespaceDecls[i])) continue;
                throw new XPathException((Expression)this, ErrorCodes.XQST0071, "duplicate definition for '" + qn + "'");
            }
            QName[] decls = new QName[this.namespaceDecls.length + 1];
            System.arraycopy(this.namespaceDecls, 0, decls, 0, this.namespaceDecls.length);
            decls[this.namespaceDecls.length] = qn;
            this.namespaceDecls = decls;
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.context.pushInScopeNamespaces();
        if (this.namespaceDecls != null) {
            for (int i = 0; i < this.namespaceDecls.length; ++i) {
                if ("".equals(this.namespaceDecls[i].getNamespaceURI())) {
                    this.context.inScopeNamespaces.remove(this.namespaceDecls[i].getLocalPart());
                    continue;
                }
                this.context.declareInScopeNamespace(this.namespaceDecls[i].getLocalPart(), this.namespaceDecls[i].getNamespaceURI());
            }
        }
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setParent(this);
        newContextInfo.addFlag(256);
        this.qnameExpr.analyze(newContextInfo);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].analyze(newContextInfo);
            }
        }
        if (this.content != null) {
            this.content.analyze(newContextInfo);
        }
        this.context.popInScopeNamespaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.expressionStart(this);
        this.context.pushInScopeNamespaces();
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            NodeImpl node;
            QName qn;
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            if (this.namespaceDecls != null) {
                for (int i = 0; i < this.namespaceDecls.length; ++i) {
                    this.context.declareInScopeNamespace(this.namespaceDecls[i].getLocalPart(), this.namespaceDecls[i].getNamespaceURI());
                }
            }
            AttributesImpl attrs = new AttributesImpl();
            if (this.attributes != null) {
                for (int i = 0; i < this.attributes.length; ++i) {
                    AttributeConstructor constructor = this.attributes[i];
                    if (!constructor.isNamespaceDeclaration()) continue;
                    int p = constructor.getQName().indexOf(58);
                    if (p == -1) {
                        this.context.declareInScopeNamespace("", constructor.getLiteralValue());
                        continue;
                    }
                    String prefix = constructor.getQName().substring(p + 1);
                    this.context.declareInScopeNamespace(prefix, constructor.getLiteralValue());
                }
                String v = null;
                for (int i = 0; i < this.attributes.length; ++i) {
                    QName attrQName;
                    this.context.proceed(this, builder);
                    AttributeConstructor constructor = this.attributes[i];
                    Sequence attrValues = constructor.eval(contextSequence, contextItem);
                    try {
                        attrQName = QName.parse(this.context, constructor.getQName(), "");
                    }
                    catch (QName.IllegalQNameException e) {
                        throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + constructor.getQName() + "' is not a valid attribute name");
                    }
                    String namespaceURI = attrQName.getNamespaceURI();
                    if (namespaceURI != null && !namespaceURI.isEmpty() && attrQName.getPrefix() == null) {
                        String prefix = this.context.getPrefixForURI(namespaceURI);
                        if (prefix != null) {
                            attrQName = new QName(attrQName.getLocalPart(), attrQName.getNamespaceURI(), prefix);
                        } else {
                            boolean n = true;
                            while (i < 100) {
                                prefix = "eXnsp1";
                                if (this.context.getURIForPrefix(prefix) == null) {
                                    attrQName = new QName(attrQName.getLocalPart(), attrQName.getNamespaceURI(), prefix);
                                    break;
                                }
                                prefix = null;
                                ++i;
                            }
                            if (prefix == null) {
                                throw new XPathException((Expression)this, "Prefix can't be generated.");
                            }
                        }
                    }
                    if (attrs.getIndex(attrQName.getNamespaceURI(), attrQName.getLocalPart()) != -1) {
                        throw new XPathException((Expression)this, ErrorCodes.XQST0040, "'" + attrQName.getLocalPart() + "' is a duplicate attribute name");
                    }
                    v = DynamicAttributeConstructor.normalize(this, attrQName, attrValues.getStringValue());
                    attrs.addAttribute(attrQName.getNamespaceURI(), attrQName.getLocalPart(), attrQName.getStringValue(), "CDATA", v);
                }
            }
            this.context.proceed(this, builder);
            Sequence qnameSeq = this.qnameExpr.eval(contextSequence, contextItem);
            if (!qnameSeq.hasOne()) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Type error: the node name should evaluate to a single item");
            }
            Item qnitem = qnameSeq.itemAt(0);
            if (qnitem instanceof QNameValue) {
                qn = ((QNameValue)qnitem).getQName();
            } else {
                try {
                    qn = QName.parse(this.context, qnitem.getStringValue());
                }
                catch (QName.IllegalQNameException e) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + qnitem.getStringValue() + "' is not a valid element name");
                }
                catch (XPathException e) {
                    e.setLocation(this.getLine(), this.getColumn(), this.getSource());
                    throw e;
                }
                if (qn.getPrefix() == null && this.context.getInScopeNamespace("") != null) {
                    qn = new QName(qn.getLocalPart(), this.context.getInScopeNamespace(""), qn.getPrefix());
                }
            }
            if (!XMLChar.isValidName(qn.getLocalPart())) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + qnitem.getStringValue() + "' is not a valid element name");
            }
            int nodeNr = builder.startElement(qn, attrs);
            if (this.namespaceDecls != null) {
                for (int i = 0; i < this.namespaceDecls.length; ++i) {
                    builder.namespaceNode(this.namespaceDecls[i]);
                }
            }
            if (qn.hasNamespace()) {
                if (this.context.getInScopePrefix(qn.getNamespaceURI()) == null) {
                    String prefix = qn.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.context.declareInScopeNamespace(prefix, qn.getNamespaceURI());
                    builder.namespaceNode(new QName(prefix, qn.getNamespaceURI(), "xmlns"));
                }
            } else if ((qn.getPrefix() == null || qn.getPrefix().length() == 0) && this.context.getInheritedNamespace("") != null) {
                this.context.declareInScopeNamespace("", "");
                builder.namespaceNode(new QName("", "", "xmlns"));
            }
            if (this.content != null) {
                this.content.eval(contextSequence, contextItem);
            }
            builder.endElement();
            NodeImpl nodeImpl = node = builder.getDocument().getNode(nodeNr);
            return nodeImpl;
        }
        finally {
            this.context.popInScopeNamespaces();
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
            this.context.expressionEnd(this);
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("element ");
        dumper.display("{");
        this.qnameExpr.dump(dumper);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    dumper.nl();
                }
                AttributeConstructor attr = this.attributes[i];
                attr.dump(dumper);
            }
            dumper.endIndent();
            dumper.startIndent();
        }
        if (this.content != null) {
            Iterator<Expression> i = this.content.steps.iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.dump(dumper);
                if (!i.hasNext()) continue;
                dumper.nl();
            }
            dumper.endIndent().nl();
        }
        dumper.display("} ");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("element ");
        result.append("{");
        result.append(this.qnameExpr.toString());
        result.append("} ");
        result.append("{");
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                AttributeConstructor attr = this.attributes[i];
                result.append(attr.toString());
            }
        }
        if (this.content != null) {
            Iterator<Expression> i = this.content.steps.iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                result.append(expr.toString());
                if (!i.hasNext()) continue;
                result.append(" ");
            }
        }
        result.append("} ");
        return result.toString();
    }

    @Override
    public void setPrimaryAxis(int axis) {
    }

    @Override
    public int getPrimaryAxis() {
        if (this.content != null) {
            return this.content.getPrimaryAxis();
        }
        return -1;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.qnameExpr.resetState(postOptimization);
        if (this.content != null) {
            this.content.resetState(postOptimization);
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                AttributeConstructor next = this.attributes[i];
                next.resetState(postOptimization);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitElementConstructor(this);
    }

    @Override
    public int returnsType() {
        return 1;
    }
}

