/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.TextImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class EnclosedExpr
extends PathExpr {
    public EnclosedExpr(XQueryContext context) {
        super(context);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.removeFlag(256);
        super.analyze(newContextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        this.context.enterEnclosedExpr();
        try {
            this.context.pushDocumentContext();
            try {
                result = super.eval(contextSequence, null);
            }
            finally {
                this.context.popDocumentContext();
            }
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
            receiver.setCheckNS(true);
            try {
                result = ArrayType.flatten(result);
                SequenceIterator i = result.iterate();
                Item next = i.nextItem();
                StringBuilder buf = null;
                boolean allowAttribs = true;
                while (next != null) {
                    this.context.proceed(this, builder);
                    if (Type.subTypeOf(next.getType(), 101)) {
                        throw new XPathException(ErrorCodes.XQTY0105, "Enclosed expression contains function item");
                    }
                    if (Type.subTypeOf(next.getType(), 20)) {
                        if (buf == null) {
                            buf = new StringBuilder();
                        } else if (buf.length() > 0) {
                            buf.append(' ');
                        }
                        buf.append(next.getStringValue());
                        allowAttribs = false;
                        next = i.nextItem();
                        continue;
                    }
                    if (!Type.subTypeOf(next.getType(), -1)) continue;
                    if (next instanceof TextImpl && ((TextImpl)next).getStringValue().isEmpty()) {
                        next = i.nextItem();
                        continue;
                    }
                    if (buf != null && buf.length() > 0) {
                        receiver.characters(buf);
                        buf.setLength(0);
                    }
                    if (next.getType() == 2 && !allowAttribs) {
                        throw new XPathException((Expression)this, ErrorCodes.XQTY0024, "An attribute may not appear after another child node.");
                    }
                    try {
                        next.copyTo(this.context.getBroker(), receiver);
                    }
                    catch (DOMException e) {
                        if (e.code == 14) {
                            throw new XPathException((Expression)this, ErrorCodes.XQDY0102, e.getMessage());
                        }
                        throw new XPathException((Expression)this, e.getMessage(), (Throwable)e);
                    }
                    allowAttribs = next.getType() == 2 || next.getType() == 500;
                    next = i.nextItem();
                }
                if (buf != null && buf.length() > 0) {
                    receiver.characters(buf);
                }
            }
            catch (SAXException e) {
                LOG.warn("SAXException during serialization: " + e.getMessage(), (Throwable)e);
                throw new XPathException((Expression)this, (Throwable)e);
            }
        }
        finally {
            this.context.exitEnclosedExpr();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("{");
        dumper.startIndent();
        super.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    @Override
    public String toString() {
        return "{" + super.toString() + "}";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitPathExpr(this);
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return true;
    }

    @Override
    public Expression simplify() {
        return this;
    }
}

