/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class ExtensionExpression
extends AbstractExpression {
    private Expression innerExpression;
    private List<Pragma> pragmas = new ArrayList<Pragma>(3);

    public ExtensionExpression(XQueryContext context) {
        super(context);
    }

    public void setExpression(Expression inner) {
        this.innerExpression = inner;
    }

    public void addPragma(Pragma pragma) {
        this.pragmas.add(pragma);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.callBefore(contextSequence);
        Sequence result = null;
        for (Pragma pragma : this.pragmas) {
            Sequence temp = pragma.eval(contextSequence, contextItem);
            if (temp == null) continue;
            result = temp;
            break;
        }
        if (result == null) {
            result = this.innerExpression.eval(contextSequence, contextItem);
        }
        this.callAfter();
        return result;
    }

    private void callAfter() throws XPathException {
        for (Pragma pragma : this.pragmas) {
            pragma.after(this.context, this.innerExpression);
        }
    }

    private void callBefore(Sequence contextSequence) throws XPathException {
        for (Pragma pragma : this.pragmas) {
            pragma.before(this.context, this.innerExpression, contextSequence);
        }
    }

    @Override
    public int returnsType() {
        return this.innerExpression.returnsType();
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContext = new AnalyzeContextInfo(contextInfo);
        for (Pragma pragma : this.pragmas) {
            pragma.analyze(newContext);
        }
        this.innerExpression.analyze(newContext);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        for (Pragma pragma : this.pragmas) {
            dumper.display("(# " + pragma.getQName().getStringValue(), this.line);
            if (pragma.getContents() != null) {
                dumper.display(' ').display(pragma.getContents());
            }
            dumper.display("#)").nl();
        }
        dumper.display('{');
        dumper.startIndent();
        this.innerExpression.dump(dumper);
        dumper.endIndent();
        dumper.nl().display('}').nl();
    }

    @Override
    public int getDependencies() {
        return this.innerExpression.getDependencies();
    }

    @Override
    public int getCardinality() {
        return this.innerExpression.getCardinality();
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.innerExpression.setContextDocSet(contextSet);
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.innerExpression.setPrimaryAxis(axis);
    }

    @Override
    public int getPrimaryAxis() {
        return this.innerExpression.getPrimaryAxis();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.innerExpression.resetState(postOptimization);
        for (Pragma pragma : this.pragmas) {
            pragma.resetState(postOptimization);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this.innerExpression);
    }
}

