/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AnyNodeTest;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class FilteredExpression
extends AbstractExpression {
    protected final Expression expression;
    protected boolean abbreviated = false;
    protected final List<Predicate> predicates = new ArrayList<Predicate>(2);
    private Expression parent;

    public FilteredExpression(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr.simplify();
    }

    public void addPredicate(Predicate pred) {
        this.predicates.add(pred);
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public Expression getExpression() {
        if (this.expression instanceof PathExpr) {
            return ((PathExpr)this.expression).getExpression(0);
        }
        return this.expression;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        if (this.predicates.size() > 0) {
            AnalyzeContextInfo newContext = new AnalyzeContextInfo(contextInfo);
            newContext.setParent(this);
            newContext.setContextStep(this);
            newContext.setStaticType(this.expression.returnsType());
            for (Predicate pred : this.predicates) {
                pred.analyze(newContext);
            }
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.expression.eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Predicate pred = this.predicates.get(0);
            this.context.setContextSequencePosition(0, seq);
            if (this.abbreviated && (pred.getExecutionMode() != 0 || !seq.isPersistentSet())) {
                result = new ValueSequence();
                if (seq.isPersistentSet()) {
                    NodeSet contextSet = seq.toNodeSet();
                    NodeSet outerSequence = contextSet.getParents(this.getExpressionId());
                    SequenceIterator i = outerSequence.iterate();
                    while (i.hasNext()) {
                        NodeValue node = (NodeValue)i.nextItem();
                        NodeSet newContextSeq = contextSet.selectParentChild((NodeSet)((Object)node), 1, this.getExpressionId());
                        Sequence temp = this.processPredicate(outerSequence, newContextSeq);
                        result.addAll(temp);
                    }
                } else {
                    MemoryNodeSet nodes = seq.toMemNodeSet();
                    Sequence outerSequence = nodes.getParents(new AnyNodeTest());
                    SequenceIterator i = outerSequence.iterate();
                    while (i.hasNext()) {
                        NodeValue node = (NodeValue)i.nextItem();
                        Sequence newSet = nodes.getChildrenForParent((NodeImpl)node);
                        Sequence temp = this.processPredicate(outerSequence, newSet);
                        result.addAll(temp);
                    }
                }
            } else {
                result = this.processPredicate(contextSequence, seq);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence processPredicate(Sequence contextSequence, Sequence seq) throws XPathException {
        for (Predicate pred : this.predicates) {
            seq = pred.evalPredicate(contextSequence, seq, 8);
            contextSequence = null;
        }
        return seq;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        for (Predicate pred : this.predicates) {
            pred.dump(dumper);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.expression.toString());
        for (Predicate pred : this.predicates) {
            result.append(pred.toString());
        }
        return result.toString();
    }

    @Override
    public int returnsType() {
        return this.expression.returnsType();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
        for (Predicate pred : this.predicates) {
            pred.resetState(postOptimization);
        }
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }

    @Override
    public int getPrimaryAxis() {
        return this.expression.getPrimaryAxis();
    }

    public void setAbbreviated(boolean abbrev) {
        this.abbreviated = abbrev;
    }

    @Override
    public int getDependencies() {
        int deps = 1;
        deps |= this.expression.getDependencies();
        for (Predicate pred : this.predicates) {
            deps |= pred.getDependencies();
        }
        return deps;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitFilteredExpr(this);
    }

    @Override
    public Expression getParent() {
        return this.parent;
    }
}

