/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.WhereClause;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class ForExpr
extends BindingExpression {
    private String positionalVariable = null;
    private boolean allowEmpty = false;
    private boolean isOuterFor = true;

    public ForExpr(XQueryContext context, boolean allowingEmpty) {
        super(context);
        this.allowEmpty = allowingEmpty;
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return FLWORClause.ClauseType.FOR;
    }

    public void setPositionalVariable(String var) {
        this.positionalVariable = var;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            contextInfo.setParent(this);
            AnalyzeContextInfo varContextInfo = new AnalyzeContextInfo(contextInfo);
            this.inputSequence.analyze(varContextInfo);
            LocalVariable inVar = new LocalVariable(QName.parse(this.context, this.varName, null));
            inVar.setSequenceType(this.sequenceType);
            inVar.setStaticType(varContextInfo.getStaticReturnType());
            this.context.declareVariableBinding(inVar);
            if (this.positionalVariable != null) {
                if (this.varName.equals(this.positionalVariable)) {
                    throw new XPathException((Expression)this, ErrorCodes.XQST0089, "bound variable and positional variable have the same name");
                }
                LocalVariable posVar = new LocalVariable(QName.parse(this.context, this.positionalVariable, null));
                posVar.setSequenceType(POSITIONAL_VAR_TYPE);
                posVar.setStaticType(31);
                this.context.declareVariableBinding(posVar);
            }
            AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.addFlag(1);
            this.returnExpr.analyze(newContextInfo);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix");
        }
        finally {
            this.context.popLocalVariables(mark);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        LocalVariable var;
        Sequence in;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        this.context.expressionStart(this);
        LocalVariable mark = this.context.markLocalVariables(false);
        Sequence resultSequence = new ValueSequence(this.unordered);
        try {
            in = this.inputSequence.eval(contextSequence, null);
            ForExpr.clearContext(this.getExpressionId(), in);
            var = this.createVariable(this.varName);
            var.setSequenceType(this.sequenceType);
            this.context.declareVariableBinding(var);
            this.registerUpdateListener(in);
            LocalVariable at = null;
            if (this.positionalVariable != null) {
                at = new LocalVariable(QName.parse(this.context, this.positionalVariable, null));
                at.setSequenceType(POSITIONAL_VAR_TYPE);
                this.context.declareVariableBinding(at);
            }
            var.setValue(in);
            if (in instanceof NodeSet) {
                var.setContextDocs(in.getDocumentSet());
            } else {
                var.setContextDocs(null);
            }
            if (this.isOuterFor) {
                if (this.returnExpr instanceof WhereClause) {
                    if (at == null) {
                        in = ((WhereClause)this.returnExpr).preEval(in);
                    }
                } else if (this.returnExpr instanceof FLWORClause) {
                    in = ((FLWORClause)this.returnExpr).preEval(in);
                }
            }
            IntegerValue atVal = new IntegerValue(1L);
            if (this.positionalVariable != null) {
                at.setValue(atVal);
            }
            if (in.isEmpty() && this.sequenceType != null && !Cardinality.checkCardinality(this.sequenceType.getCardinality(), 1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(in.getCardinality()));
            }
            int p = 0;
            if (in.isEmpty() && this.allowEmpty) {
                this.processItem(var, AtomicValue.EMPTY_VALUE, Sequence.EMPTY_SEQUENCE, resultSequence, at, p);
            } else {
                SequenceIterator i = in.iterate();
                while (i.hasNext()) {
                    this.processItem(var, i.nextItem(), in, resultSequence, at, p);
                    ++p;
                }
            }
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + this.positionalVariable);
        }
        finally {
            this.context.popLocalVariables(mark, resultSequence);
        }
        ForExpr.clearContext(this.getExpressionId(), in);
        if (this.sequenceType != null) {
            if (resultSequence.isEmpty() && !Cardinality.checkCardinality(this.sequenceType.getCardinality(), 1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(1));
            }
            if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1)) {
                if (!resultSequence.isEmpty() && !Type.subTypeOf(resultSequence.getItemType(), this.sequenceType.getPrimaryType())) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(resultSequence.getItemType()));
                }
            } else {
                var.checkType();
            }
        }
        this.setActualReturnType(resultSequence.getItemType());
        if (this.callPostEval()) {
            resultSequence = this.postEval(resultSequence);
        }
        this.context.expressionEnd(this);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", resultSequence);
        }
        return resultSequence;
    }

    private void processItem(LocalVariable var, Item contextItem, Sequence in, Sequence resultSequence, LocalVariable at, int p) throws XPathException {
        this.context.proceed(this);
        this.context.setContextSequencePosition(p, in);
        if (this.positionalVariable != null) {
            at.setValue(new IntegerValue(p + 1));
        }
        Sequence contextSequence = contextItem.toSequence();
        var.setValue(contextSequence);
        if (this.sequenceType == null) {
            var.checkType();
        }
        this.context.setContextSequencePosition(0, null);
        resultSequence.addAll(this.returnExpr.eval(null));
        var.destroy(this.context, resultSequence);
    }

    private boolean callPostEval() {
        for (FLWORClause prev = this.getPreviousClause(); prev != null; prev = prev.getPreviousClause()) {
            switch (prev.getType()) {
                case LET: 
                case FOR: {
                    return false;
                }
                case ORDERBY: 
                case GROUPBY: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public Sequence preEval(Sequence seq) throws XPathException {
        this.isOuterFor = false;
        return super.preEval(seq);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("for ", this.line);
        dumper.startIndent();
        dumper.display("$").display(this.varName);
        if (this.sequenceType != null) {
            dumper.display(" as ").display(this.sequenceType);
        }
        if (this.allowEmpty) {
            dumper.display(" allowing empty ");
        }
        if (this.positionalVariable != null) {
            dumper.display(" at ").display(this.positionalVariable);
        }
        dumper.display(" in ");
        this.inputSequence.dump(dumper);
        dumper.endIndent().nl();
        if (this.returnExpr instanceof LetExpr) {
            dumper.display(" ", this.returnExpr.getLine());
        } else {
            dumper.display("return", this.returnExpr.getLine());
        }
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent().nl();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("for ");
        result.append("$").append(this.varName);
        if (this.sequenceType != null) {
            result.append(" as ").append(this.sequenceType);
        }
        if (this.allowEmpty) {
            result.append(" allowing empty ");
        }
        if (this.positionalVariable != null) {
            result.append(" at ").append(this.positionalVariable);
        }
        result.append(" in ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        if (this.returnExpr instanceof LetExpr) {
            result.append(" ");
        } else {
            result.append("return ");
        }
        result.append(this.returnExpr.toString());
        return result.toString();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitForExpression(this);
    }
}

