/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.lang.reflect.Constructor;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AtomicToString;
import org.exist.xquery.Atomize;
import org.exist.xquery.Cardinality;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicNameCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.NameTest;
import org.exist.xquery.PathExpr;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public abstract class Function
extends PathExpr {
    public static final String BUILTIN_FUNCTION_NS = "http://www.w3.org/2005/xpath-functions";
    protected FunctionSignature mySignature;
    private Expression parent;
    protected boolean argumentsChecked = true;

    protected Function(XQueryContext context, FunctionSignature signature) {
        super(context);
        this.mySignature = signature;
    }

    protected Function(XQueryContext context) {
        super(context);
    }

    protected Module getParentModule() {
        return this.context.getModule(this.mySignature.getName().getNamespaceURI());
    }

    @Override
    public int returnsType() {
        if (this.mySignature == null) {
            return 11;
        }
        if (this.mySignature.getReturnType() == null) {
            throw new IllegalArgumentException("Return type for function " + this.mySignature.getName() + " is not defined");
        }
        return this.mySignature.getReturnType().getPrimaryType();
    }

    @Override
    public int getCardinality() {
        if (this.mySignature.getReturnType() == null) {
            throw new IllegalArgumentException("Return type for function " + this.mySignature.getName() + " is not defined");
        }
        return this.mySignature.getReturnType().getCardinality();
    }

    public static Function createFunction(XQueryContext context, XQueryAST ast, FunctionDef def) throws XPathException {
        if (def == null) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Class for function is null");
        }
        Class<? extends Function> fclass = def.getImplementingClass();
        if (fclass == null) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Class for function is null");
        }
        try {
            Function obj;
            Object[] initArgs = new Object[]{context};
            Class[] constructorArgs = new Class[]{XQueryContext.class};
            Constructor<? extends Function> construct = null;
            try {
                construct = fclass.getConstructor(constructorArgs);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (construct == null) {
                constructorArgs = new Class[]{XQueryContext.class, FunctionSignature.class};
                construct = fclass.getConstructor(constructorArgs);
                if (construct == null) {
                    throw new XPathException(ast.getLine(), ast.getColumn(), "Constructor not found");
                }
                initArgs = new Object[]{context, def.getSignature()};
            }
            if ((obj = construct.newInstance(initArgs)) instanceof Function) {
                obj.setLocation(ast.getLine(), ast.getColumn());
                return obj;
            }
            throw new XPathException(ast.getLine(), ast.getColumn(), "Function object does not implement interface function");
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new XPathException(ast.getLine(), ast.getColumn(), "Function implementation class " + fclass.getName() + " not found");
        }
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    @Override
    public Expression getParent() {
        return this.parent;
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        if (!this.mySignature.isOverloaded() && arguments.size() != this.mySignature.getArgumentCount()) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0017, "Number of arguments of function " + this.getName() + " doesn't match function signature (expected " + this.mySignature.getArgumentCount() + ", got " + arguments.size() + ')');
        }
        this.steps.clear();
        for (Expression argument : arguments) {
            this.steps.add(argument.simplify());
        }
        this.argumentsChecked = false;
    }

    protected void checkArguments() throws XPathException {
        if (!this.argumentsChecked) {
            SequenceType[] argumentTypes = this.mySignature.getArgumentTypes();
            SequenceType argType = null;
            for (int i = 0; i < this.getArgumentCount(); ++i) {
                if (argumentTypes != null && i < argumentTypes.length) {
                    argType = argumentTypes[i];
                }
                Expression next = this.checkArgument(this.getArgument(i), argType, i + 1);
                this.steps.set(i, next);
            }
        }
        this.argumentsChecked = true;
    }

    protected Expression checkArgument(Expression expr, SequenceType type, int argPosition) throws XPathException {
        int returnType;
        boolean cardinalityMatches;
        if (type == null || expr instanceof Placeholder) {
            return expr;
        }
        boolean bl = cardinalityMatches = expr instanceof VariableReference || type.getCardinality() == 7;
        if (!cardinalityMatches) {
            boolean bl2 = cardinalityMatches = (expr.getCardinality() | type.getCardinality()) == type.getCardinality();
            if (!cardinalityMatches && expr.getCardinality() == 1 && (type.getCardinality() & 1) == 0) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, Messages.getMessage("S01", argPosition, ExpressionDumper.dump(expr)));
            }
        }
        if ((returnType = (expr = new DynamicCardinalityCheck(this.context, type.getCardinality(), expr, new Error("D02", argPosition, this.mySignature))).returnsType()) == 12 || returnType == 10) {
            returnType = 11;
        }
        boolean typeMatches = type.getPrimaryType() == 11;
        typeMatches = Type.subTypeOf(returnType, type.getPrimaryType());
        if (typeMatches && cardinalityMatches) {
            if (type.getNodeName() != null) {
                expr = new DynamicNameCheck(this.context, new NameTest(type.getPrimaryType(), type.getNodeName()), expr);
            }
            return expr;
        }
        if (this.context.isBackwardsCompatible()) {
            if (Type.subTypeOf(type.getPrimaryType(), 22)) {
                if (!Type.subTypeOf(returnType, 20)) {
                    expr = new Atomize(this.context, expr);
                    returnType = 20;
                }
                expr = new AtomicToString(this.context, expr);
                returnType = 22;
            } else if (type.getPrimaryType() == 30 || Type.subTypeOf(type.getPrimaryType(), 34)) {
                if (!Type.subTypeOf(returnType, 20)) {
                    expr = new Atomize(this.context, expr);
                    returnType = 20;
                }
                expr = new UntypedValueCheck(this.context, type.getPrimaryType(), expr, new Error("D06", String.valueOf(argPosition), this.mySignature));
                returnType = type.getPrimaryType();
            }
            if (Type.subTypeOf(type.getPrimaryType(), 20)) {
                if (!Type.subTypeOf(returnType, 20)) {
                    expr = new Atomize(this.context, expr);
                }
                if (type.getPrimaryType() != 20) {
                    expr = new UntypedValueCheck(this.context, type.getPrimaryType(), expr, new Error("D06", String.valueOf(argPosition), this.mySignature));
                }
                returnType = expr.returnsType();
            }
        } else if (Type.subTypeOf(type.getPrimaryType(), 20)) {
            if (!Type.subTypeOf(returnType, 20)) {
                expr = new Atomize(this.context, expr);
            }
            expr = new UntypedValueCheck(this.context, type.getPrimaryType(), expr, new Error("D06", String.valueOf(argPosition), this.mySignature));
            returnType = expr.returnsType();
        }
        if (!(returnType == 11 || Type.subTypeOf(returnType, type.getPrimaryType()) || Type.subTypeOf(type.getPrimaryType(), returnType) || Cardinality.checkCardinality(type.getCardinality(), 1) && returnType == -1)) {
            LOG.debug(ExpressionDumper.dump(expr));
            throw new XPathException((Expression)this, Messages.getMessage("S02", String.valueOf(argPosition), this.mySignature, type.toString(), Type.getTypeName(returnType)));
        }
        if (!typeMatches) {
            expr = type.getNodeName() != null ? new DynamicNameCheck(this.context, new NameTest(type.getPrimaryType(), type.getNodeName()), expr) : new DynamicTypeCheck(this.context, type.getPrimaryType(), expr);
        }
        return expr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.checkArguments();
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        this.contextId = contextInfo.getContextId();
        contextInfo.setParent(this);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            AnalyzeContextInfo argContextInfo = new AnalyzeContextInfo(contextInfo);
            this.getArgument(i).analyze(argContextInfo);
        }
    }

    @Override
    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public Sequence[] getArguments(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        int argCount = this.getArgumentCount();
        Sequence[] args = new Sequence[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = this.getArgument(i).eval(contextSequence, contextItem);
        }
        return args;
    }

    public Expression getArgument(int pos) {
        return this.getExpression(pos);
    }

    public int getArgumentCount() {
        return this.steps.size();
    }

    @Override
    public void setPrimaryAxis(int axis) {
    }

    public QName getName() {
        return this.mySignature.getName();
    }

    public FunctionSignature getSignature() {
        return this.mySignature;
    }

    public boolean isCalledAs(String localName) {
        return localName.equals(this.mySignature.getName().getLocalPart());
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display(this.getName());
        dumper.display('(');
        boolean moreThanOne = false;
        for (Expression e : this.steps) {
            if (moreThanOne) {
                dumper.display(", ");
            }
            moreThanOne = true;
            e.dump(dumper);
        }
        dumper.display(')');
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        result.append('(');
        boolean moreThanOne = false;
        for (Expression step : this.steps) {
            if (moreThanOne) {
                result.append(", ");
            }
            moreThanOne = true;
            result.append(step.toString());
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitBuiltinFunction(this);
    }

    @Override
    public Expression simplify() {
        return this;
    }

    public static class Placeholder
    extends AbstractExpression {
        public Placeholder(XQueryContext context) {
            super(context);
        }

        @Override
        public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        }

        @Override
        public void dump(ExpressionDumper dumper) {
            dumper.display('?');
        }

        @Override
        public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0001, "Internal error: function argument placeholder not expanded.");
        }

        @Override
        public int returnsType() {
            return 11;
        }
    }
}

