/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Arrays;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.DeferredFunctionCall;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Function;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.ModuleContext;
import org.exist.xquery.PathExpr;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunctionCall
extends Function {
    protected UserDefinedFunction functionDef;
    protected Expression expression;
    protected QName name = null;
    protected List<Expression> arguments = null;
    private boolean recursive = false;
    protected VariableReference[] varDeps;

    public FunctionCall(XQueryContext context, QName name, List<Expression> arguments) {
        super(context);
        this.name = name;
        this.arguments = arguments;
    }

    public FunctionCall(XQueryContext context, UserDefinedFunction functionDef) {
        super(context);
        this.setFunction(functionDef);
    }

    public FunctionCall(FunctionCall other) {
        super(other.getContext());
        this.name = other.name;
        this.recursive = other.recursive;
        this.functionDef = other.functionDef;
        this.expression = other.expression;
        this.mySignature = other.mySignature;
    }

    private void setFunction(UserDefinedFunction functionDef) {
        this.functionDef = (UserDefinedFunction)functionDef.clone();
        this.mySignature = this.functionDef.getSignature();
        this.expression = this.functionDef;
        this.functionDef.setCaller(this);
        SequenceType returnType = this.functionDef.getSignature().getReturnType();
        if (returnType.getCardinality() != 7) {
            this.expression = new DynamicCardinalityCheck(this.context, returnType.getCardinality(), this.expression, new Error("D01"));
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 20)) {
            this.expression = new Atomize(this.context, this.expression);
        }
        if (Type.subTypeOf(returnType.getPrimaryType(), 30)) {
            this.expression = new UntypedValueCheck(this.context, returnType.getPrimaryType(), this.expression, new Error("D03"));
        } else if (returnType.getPrimaryType() != 11) {
            this.expression = new DynamicTypeCheck(this.context, returnType.getPrimaryType(), this.expression);
        }
    }

    public UserDefinedFunction getFunction() {
        return this.functionDef;
    }

    private void updateFunction() throws XPathException {
        if (this.functionDef.getContext() instanceof ModuleContext) {
            UserDefinedFunction replacementFunctionDef;
            ExternalModule rootModule;
            ModuleContext modContext = (ModuleContext)this.functionDef.getContext();
            if (this.functionDef.getName() != null && this.functionDef.getName().getNamespaceURI().equals(modContext.getModuleNamespace()) && modContext.getRootContext() != this.context.getRootContext() && (rootModule = (ExternalModule)this.context.getRootModule(this.functionDef.getName().getNamespaceURI())) != null && (replacementFunctionDef = rootModule.getFunction(this.functionDef.getName(), this.getArgumentCount(), modContext)) != null) {
                this.functionDef = (UserDefinedFunction)replacementFunctionDef.clone();
                this.expression = this.functionDef;
                this.mySignature = this.functionDef.getSignature();
                this.functionDef.setCaller(this);
            }
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setParent(this);
        newContextInfo.removeFlag(256);
        super.analyze(newContextInfo);
        if (this.context.tailRecursiveCall(this.functionDef.getSignature())) {
            this.setRecursive(true);
        }
        this.context.functionStart(this.functionDef.getSignature());
        try {
            this.expression.analyze(newContextInfo);
        }
        finally {
            this.context.functionEnd();
        }
        this.varDeps = new VariableReference[this.getArgumentCount()];
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Expression arg = this.getArgument(i);
            VariableReference varRef = BasicExpressionVisitor.findVariableRef(arg);
            if (varRef == null) continue;
            this.varDeps[i] = varRef;
        }
    }

    public void resolveForwardReference(UserDefinedFunction functionDef) throws XPathException {
        this.setFunction(functionDef);
        this.setArguments(this.arguments);
        this.arguments = null;
        this.name = null;
    }

    @Override
    public int getArgumentCount() {
        if (this.arguments == null) {
            return super.getArgumentCount();
        }
        return this.arguments.size();
    }

    public QName getQName() {
        return this.name;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence[] seq = new Sequence[this.getArgumentCount()];
        DocumentSet[] contextDocs = new DocumentSet[this.getArgumentCount()];
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            try {
                Variable var;
                seq[i] = this.getArgument(i).eval(contextSequence, contextItem);
                if (this.varDeps == null || this.varDeps[i] == null || (var = this.varDeps[i].getVariable()) == null) continue;
                contextDocs[i] = var.getContextDocs();
                continue;
            }
            catch (XPathException e) {
                if (e.getLine() <= 0) {
                    e.setLocation(this.line, this.column, this.getSource());
                }
                e.addFunctionCall(this.functionDef, this);
                throw e;
            }
        }
        Sequence result = this.evalFunction(contextSequence, contextItem, seq, contextDocs);
        try {
            if (!(result instanceof DeferredFunctionCall || result instanceof VirtualNodeSet || result.isEmpty())) {
                this.getSignature().getReturnType().checkType(result.getItemType());
            }
        }
        catch (XPathException e) {
            throw new XPathException(this, ErrorCodes.XPTY0004, "err:XPTY0004: return type of function '" + this.getSignature().getName() + "'. " + e.getMessage(), Sequence.EMPTY_SEQUENCE, e);
        }
        return result;
    }

    public Sequence evalFunction(Sequence contextSequence, Item contextItem, Sequence[] seq) throws XPathException {
        return this.evalFunction(contextSequence, contextItem, seq, null);
    }

    public Sequence evalFunction(Sequence contextSequence, Item contextItem, Sequence[] seq, DocumentSet[] contextDocs) throws XPathException {
        this.context.proceed(this);
        if (this.context.isProfilingEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        this.functionDef.setArguments(seq, contextDocs);
        if (this.isRecursive()) {
            return new DeferredFunctionCallImpl(this, contextSequence, contextItem, seq, contextDocs);
        }
        this.context.stackEnter(this);
        long start = System.currentTimeMillis();
        if (this.context.getProfiler().traceFunctions()) {
            if (this.context.tailRecursiveCall(this.getSignature())) {
                start = -1L;
            }
            this.context.getProfiler().traceFunctionStart(this);
        }
        this.context.functionStart(this.functionDef.getSignature());
        LocalVariable mark = this.context.markLocalVariables(true);
        this.context.pushInScopeNamespaces(false);
        Sequence returnSeq = null;
        try {
            returnSeq = this.expression.eval(contextSequence, contextItem);
            while (returnSeq instanceof DeferredFunctionCall && this.functionDef.getSignature().equals(((DeferredFunctionCall)returnSeq).getSignature())) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Executing function: " + this.functionDef.getSignature());
                }
                returnSeq = ((DeferredFunctionCall)returnSeq).execute();
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceFunctionEnd(this, start < 0L ? 0L : System.currentTimeMillis() - start);
            }
            if (this.context.isProfilingEnabled()) {
                this.context.getProfiler().end(this, "", returnSeq);
            }
            Sequence sequence = returnSeq;
            return sequence;
        }
        catch (XPathException e) {
            if (e.getLine() <= 0) {
                e.setLocation(this.expression.getLine(), this.expression.getColumn());
            }
            e.addFunctionCall(this.functionDef, this);
            throw e;
        }
        finally {
            this.context.popInScopeNamespaces();
            this.context.popLocalVariables(mark, returnSeq);
            this.context.functionEnd();
            this.context.stackLeave(this);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.expression.needsReset() || postOptimization) {
            this.expression.resetState(postOptimization);
        }
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.functionDef.setContextDocSet(contextSet);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitFunctionCall(this);
    }

    protected void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private static class DeferredFunctionCallImpl
    extends DeferredFunctionCall {
        private final FunctionCall call;
        private UserDefinedFunction functionDef;
        private Expression expression;
        private Sequence contextSequence;
        private Item contextItem;
        private final Sequence[] seq;
        private final DocumentSet[] contextDocs;

        private DeferredFunctionCallImpl(FunctionCall call, Sequence contextSequence, Item contextItem, Sequence[] seq, DocumentSet[] contextDocs) {
            super(call.mySignature);
            this.contextSequence = contextSequence;
            this.contextItem = contextItem;
            this.seq = seq != null ? Arrays.copyOf(seq, seq.length) : null;
            this.contextDocs = contextDocs;
            this.call = call;
            this.setup();
        }

        private void setup() {
            this.functionDef = (UserDefinedFunction)this.call.functionDef.clone();
            this.expression = this.functionDef;
            this.functionDef.setCaller(this.call);
            SequenceType returnType = this.functionDef.getSignature().getReturnType();
            XQueryContext context = this.call.context;
            if (returnType.getCardinality() != 7) {
                this.expression = new DynamicCardinalityCheck(context, returnType.getCardinality(), this.expression, new Error("D01"));
            }
            if (Type.subTypeOf(returnType.getPrimaryType(), 20)) {
                this.expression = new Atomize(context, this.expression);
            }
            if (Type.subTypeOf(returnType.getPrimaryType(), 30)) {
                this.expression = new UntypedValueCheck(context, returnType.getPrimaryType(), this.expression, new Error("D03"));
            } else if (returnType.getPrimaryType() != 11) {
                this.expression = new DynamicTypeCheck(context, returnType.getPrimaryType(), this.expression);
            }
        }

        @Override
        protected Sequence execute() throws XPathException {
            XQueryContext context = this.call.context;
            context.pushDocumentContext();
            context.functionStart(this.functionDef.getSignature());
            LocalVariable mark = context.markLocalVariables(true);
            Sequence returnSeq = null;
            try {
                this.functionDef.setArguments(this.seq, this.contextDocs);
                returnSeq = this.expression.eval(this.contextSequence, this.contextItem);
                PathExpr.LOG.trace("Returning from execute()");
                Sequence sequence = returnSeq;
                context.popLocalVariables(mark, returnSeq);
                context.functionEnd();
                context.popDocumentContext();
                return sequence;
            }
            catch (XPathException e) {
                try {
                    if (e.getLine() == 0) {
                        e.setLocation(this.call.line, this.call.column);
                    }
                    e.addFunctionCall(this.functionDef, this.call);
                    throw e;
                }
                catch (Throwable throwable) {
                    context.popLocalVariables(mark, returnSeq);
                    context.functionEnd();
                    context.popDocumentContext();
                    throw throwable;
                }
            }
        }
    }
}

