/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Arrays;
import java.util.stream.Stream;
import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;

public class FunctionDSL {
    public static FunctionDef functionDef(FunctionSignature functionSignature, Class<? extends Function> clazz) {
        return new FunctionDef(functionSignature, clazz);
    }

    public static FunctionDef[] functionDefs(Class<? extends Function> clazz, FunctionSignature ... functionSignatures) {
        return (FunctionDef[])Arrays.stream(functionSignatures).map(fs -> FunctionDSL.functionDef(fs, clazz)).toArray(FunctionDef[]::new);
    }

    public static FunctionDef[] functionDefs(FunctionDef[] ... functionDefss) {
        return Arrays.stream(functionDefss).map(Arrays::stream).reduce(Stream::concat).map(s -> (FunctionDef[])s.toArray(FunctionDef[]::new)).orElse(new FunctionDef[0]);
    }

    public static FunctionSignature functionSignature(QName name, String description, FunctionReturnSequenceType returnType, FunctionParameterSequenceType ... paramTypes) {
        return new FunctionSignature(name, description, paramTypes, returnType);
    }

    public static FunctionSignature deprecated(String deprecationDescription, FunctionSignature functionSignature) {
        return new FunctionSignature(functionSignature.getName(), functionSignature.getDescription(), functionSignature.getArgumentTypes(), functionSignature.getReturnType(), deprecationDescription);
    }

    public static FunctionSignature deprecated(FunctionSignature fsDeprecates, FunctionSignature functionSignature) {
        return new FunctionSignature(functionSignature.getName(), functionSignature.getDescription(), functionSignature.getArgumentTypes(), functionSignature.getReturnType(), fsDeprecates);
    }

    public static FunctionSignature[] functionSignatures(QName name, String description, FunctionReturnSequenceType returnType, FunctionParameterSequenceType[][] variableParamTypes) {
        return (FunctionSignature[])Arrays.stream(variableParamTypes).map(paramTypes -> FunctionDSL.functionSignature(name, description, returnType, paramTypes)).toArray(FunctionSignature[]::new);
    }

    public static FunctionParameterSequenceType[][] arities(FunctionParameterSequenceType[] ... variableParamTypes) {
        return variableParamTypes;
    }

    public static FunctionParameterSequenceType[] arity(FunctionParameterSequenceType ... paramTypes) {
        return paramTypes;
    }

    public static FunctionParameterSequenceType[] params(FunctionParameterSequenceType ... paramTypes) {
        return paramTypes;
    }

    public static FunctionParameterSequenceType optParam(String name, int type, String description) {
        return FunctionDSL.param(name, type, 3, description);
    }

    public static FunctionParameterSequenceType param(String name, int type, String description) {
        return FunctionDSL.param(name, type, 2, description);
    }

    public static FunctionParameterSequenceType manyParam(String name, int type, String description) {
        return FunctionDSL.param(name, type, 6, description);
    }

    public static FunctionParameterSequenceType optManyParam(String name, int type, String description) {
        return FunctionDSL.param(name, type, 7, description);
    }

    public static FunctionParameterSequenceType param(String name, int type, int cardinality, String description) {
        return new FunctionParameterSequenceType(name, type, cardinality, description);
    }

    public static FunctionReturnSequenceType returnsOpt(int type) {
        return FunctionDSL.returns(type, 3);
    }

    public static FunctionReturnSequenceType returnsOpt(int type, String description) {
        return FunctionDSL.returns(type, 3, description);
    }

    public static FunctionReturnSequenceType returns(int type) {
        return FunctionDSL.returns(type, 2);
    }

    public static FunctionReturnSequenceType returns(int type, String description) {
        return FunctionDSL.returns(type, 2, description);
    }

    public static FunctionReturnSequenceType returnsMany(int type) {
        return FunctionDSL.returns(type, 6);
    }

    public static FunctionReturnSequenceType returnsMany(int type, String description) {
        return FunctionDSL.returns(type, 6, description);
    }

    public static FunctionReturnSequenceType returnsOptMany(int type) {
        return FunctionDSL.returns(type, 7);
    }

    public static FunctionReturnSequenceType returnsOptMany(int type, String description) {
        return FunctionDSL.returns(type, 7, description);
    }

    public static FunctionReturnSequenceType returnsNothing() {
        return new FunctionReturnSequenceType(10, 1, null);
    }

    public static FunctionReturnSequenceType returns(int type, int cardinality) {
        return FunctionDSL.returns(type, cardinality, null);
    }

    public static FunctionReturnSequenceType returns(int type, int cardinality, String description) {
        return new FunctionReturnSequenceType(type, cardinality, description);
    }
}

