/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.CastExpression;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.InternalModule;
import org.exist.xquery.JavaCall;
import org.exist.xquery.Module;
import org.exist.xquery.PathExpr;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunctionFactory {
    public static final String ENABLE_JAVA_BINDING_ATTRIBUTE = "enable-java-binding";
    public static final String PROPERTY_ENABLE_JAVA_BINDING = "xquery.enable-java-binding";
    public static final String DISABLE_DEPRECATED_FUNCTIONS_ATTRIBUTE = "disable-deprecated-functions";
    public static final String PROPERTY_DISABLE_DEPRECATED_FUNCTIONS = "xquery.disable-deprecated-functions";
    public static final boolean DISABLE_DEPRECATED_FUNCTIONS_BY_DEFAULT = false;

    public static Expression createFunction(XQueryContext context, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        QName qname = null;
        try {
            qname = QName.parse(context, ast.getText(), context.getDefaultFunctionNamespace());
        }
        catch (QName.IllegalQNameException xpe) {
            throw new XPathException(ErrorCodes.XPST0081, "Invalid qname " + ast.getText());
        }
        return FunctionFactory.createFunction(context, qname, ast, parent, params);
    }

    public static Expression createFunction(XQueryContext context, QName qname, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        return FunctionFactory.createFunction(context, qname, ast, parent, params, true);
    }

    public static Expression createFunction(XQueryContext context, QName qname, XQueryAST ast, PathExpr parent, List<Expression> params, boolean optimizeStrFuncs) throws XPathException {
        String local = qname.getLocalPart();
        String uri = qname.getNamespaceURI();
        AbstractExpression step = null;
        if (optimizeStrFuncs && ("http://www.w3.org/2005/xpath-functions".equals(uri) || "http://www.w3.org/1999/XSL/Transform".equals(uri))) {
            if ("starts-with".equals(local)) {
                step = FunctionFactory.startsWith(context, ast, parent, params);
            } else if ("ends-with".equals(local)) {
                step = FunctionFactory.endsWith(context, ast, parent, params);
            } else if ("contains".equals(local)) {
                step = FunctionFactory.contains(context, ast, parent, params);
            } else if ("equals".equals(local)) {
                step = FunctionFactory.equals(context, ast, parent, params);
            }
        } else if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            step = FunctionFactory.castExpression(context, ast, params, qname);
        } else if (uri.startsWith("java:")) {
            step = FunctionFactory.javaFunctionBinding(context, ast, params, qname);
        }
        if (step == null) {
            step = FunctionFactory.functionCall(context, ast, params, qname);
        }
        return step;
    }

    private static GeneralComparison startsWith(XQueryContext context, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        if (params.size() < 2) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function starts-with() requires two or three arguments");
        }
        if (params.size() > 3) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function starts-with() requires two or three arguments");
        }
        PathExpr p0 = (PathExpr)params.get(0);
        PathExpr p1 = (PathExpr)params.get(1);
        if (p1.getLength() == 0) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Second argument of starts-with() is empty");
        }
        GeneralComparison op = new GeneralComparison(context, p0, p1, Constants.Comparison.EQ, Constants.StringTruncationOperator.RIGHT);
        op.setLocation(ast.getLine(), ast.getColumn());
        context.getProfiler().message((Expression)parent, 2, "OPTIMIZATION", "Rewritten start-with as a general comparison with a right truncations");
        if (params.size() == 3) {
            op.setCollation(params.get(2));
        }
        return op;
    }

    private static GeneralComparison endsWith(XQueryContext context, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        if (params.size() < 2) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function ends-with() requires two or three arguments");
        }
        if (params.size() > 3) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function ends-with() requires two or three arguments");
        }
        PathExpr p0 = (PathExpr)params.get(0);
        PathExpr p1 = (PathExpr)params.get(1);
        if (p1.getLength() == 0) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Second argument of ends-with() is empty");
        }
        GeneralComparison op = new GeneralComparison(context, p0, p1, Constants.Comparison.EQ, Constants.StringTruncationOperator.LEFT);
        context.getProfiler().message((Expression)parent, 2, "OPTIMIZATION", "Rewritten ends-with as a general comparison with a left truncations");
        op.setLocation(ast.getLine(), ast.getColumn());
        if (params.size() == 3) {
            op.setCollation(params.get(2));
        }
        return op;
    }

    private static GeneralComparison contains(XQueryContext context, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        if (params.size() < 2) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function contains() requires two or three arguments");
        }
        if (params.size() > 3) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function contains() requires two or three arguments");
        }
        PathExpr p0 = (PathExpr)params.get(0);
        PathExpr p1 = (PathExpr)params.get(1);
        if (p1.getLength() == 0) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Second argument of contains() is empty");
        }
        GeneralComparison op = new GeneralComparison(context, p0, p1, Constants.Comparison.EQ, Constants.StringTruncationOperator.BOTH);
        context.getProfiler().message((Expression)parent, 2, "OPTIMIZATION", "Rewritten contains() as a general comparison with left and right truncations");
        op.setLocation(ast.getLine(), ast.getColumn());
        if (params.size() == 3) {
            op.setCollation(params.get(2));
        }
        return op;
    }

    private static GeneralComparison equals(XQueryContext context, XQueryAST ast, PathExpr parent, List<Expression> params) throws XPathException {
        if (params.size() < 2) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function equals() requires two or three arguments");
        }
        if (params.size() > 3) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function equals() requires two or three arguments");
        }
        PathExpr p0 = (PathExpr)params.get(0);
        PathExpr p1 = (PathExpr)params.get(1);
        if (p1.getLength() == 0) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Second argument of equals() is empty");
        }
        GeneralComparison op = new GeneralComparison(context, p0, p1, Constants.Comparison.EQ, Constants.StringTruncationOperator.EQUALS);
        context.getProfiler().message((Expression)parent, 2, "OPTIMIZATION", "Rewritten contains() as a general comparison with no truncations");
        op.setLocation(ast.getLine(), ast.getColumn());
        if (params.size() == 3) {
            op.setCollation(params.get(2));
        } else {
            op.setCollation(new StringValue("?strength=identical"));
        }
        return op;
    }

    private static CastExpression castExpression(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname) throws XPathException {
        if (params.size() != 1) {
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Wrong number of arguments for constructor function");
        }
        Expression arg = params.get(0);
        int code = Type.getType(qname);
        CastExpression castExpr = new CastExpression(context, arg, code, 3);
        castExpr.setLocation(ast.getLine(), ast.getColumn());
        return castExpr;
    }

    private static JavaCall javaFunctionBinding(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname) throws XPathException {
        String javabinding = (String)context.getBroker().getConfiguration().getProperty(PROPERTY_ENABLE_JAVA_BINDING);
        if (javabinding == null || !"yes".equals(javabinding)) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Java binding is disabled in the current configuration (see conf.xml). Call to " + qname.getStringValue() + " denied.");
        }
        JavaCall call = new JavaCall(context, qname);
        call.setLocation(ast.getLine(), ast.getColumn());
        call.setArguments(params);
        return call;
    }

    private static Function functionCall(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname) throws XPathException {
        String uri = qname.getNamespaceURI();
        Module module = context.getModule(uri);
        Function fn = module != null ? (module.isInternalModule() ? FunctionFactory.getInternalModuleFunction(context, ast, params, qname, module) : FunctionFactory.getXQueryModuleFunction(context, ast, params, qname, module)) : FunctionFactory.getUserDefinedFunction(context, ast, params, qname);
        return fn;
    }

    private static Function getInternalModuleFunction(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname, Module module) throws XPathException {
        Module _module_;
        FunctionDef def = ((InternalModule)module).getFunctionDef(qname, params.size());
        if (def == null && "http://www.w3.org/1999/XSL/Transform".equals(qname.getNamespaceURI()) && (_module_ = context.getModule("http://www.w3.org/2005/xpath-functions")) != null) {
            module = _module_;
            qname = new QName(qname.getLocalPart(), "http://www.w3.org/2005/xpath-functions", qname.getPrefix());
            def = ((InternalModule)module).getFunctionDef(qname, params.size());
        }
        if (def == null) {
            List<FunctionSignature> funcs = ((InternalModule)module).getFunctionsByName(qname);
            if (funcs.isEmpty()) {
                throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function " + qname.getStringValue() + "()  is not defined in module namespace: " + qname.getNamespaceURI());
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Unexpectedly received ");
            buf.append(params.size());
            buf.append(" parameter(s) in call to function ");
            buf.append("'");
            buf.append(qname.getStringValue());
            buf.append("()'. ");
            buf.append("Defined function signatures are:\r\n");
            for (FunctionSignature sig : funcs) {
                buf.append(sig.toString()).append("\r\n");
            }
            throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, buf.toString());
        }
        if (((Boolean)context.getBroker().getConfiguration().getProperty(PROPERTY_DISABLE_DEPRECATED_FUNCTIONS)).booleanValue() && def.getSignature().isDeprecated()) {
            throw new XPathException(ast.getLine(), ast.getColumn(), "Access to deprecated functions is not allowed. Call to '" + qname.getStringValue() + "()' denied. " + def.getSignature().getDeprecated());
        }
        Function fn = Function.createFunction(context, ast, def);
        fn.setArguments(params);
        fn.setASTNode(ast);
        return new InternalFunctionCall(fn);
    }

    private static FunctionCall getUserDefinedFunction(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname) throws XPathException {
        FunctionCall fc;
        UserDefinedFunction func = context.resolveFunction(qname, params.size());
        if (func != null) {
            fc = new FunctionCall(context, func);
            fc.setLocation(ast.getLine(), ast.getColumn());
            fc.setArguments(params);
        } else {
            fc = new FunctionCall(context, qname, params);
            fc.setLocation(ast.getLine(), ast.getColumn());
            context.addForwardReference(fc);
        }
        return fc;
    }

    private static FunctionCall getXQueryModuleFunction(XQueryContext context, XQueryAST ast, List<Expression> params, QName qname, Module module) throws XPathException {
        FunctionCall fc;
        UserDefinedFunction func = ((ExternalModule)module).getFunction(qname, params.size(), context);
        if (func == null) {
            if (module.isReady()) {
                throw new XPathException(ast.getLine(), ast.getColumn(), ErrorCodes.XPST0017, "Function " + qname.getStringValue() + "() is not defined in namespace '" + qname.getNamespaceURI() + "'");
            }
            fc = new FunctionCall(((ExternalModule)module).getContext(), qname, params);
            fc.setLocation(ast.getLine(), ast.getColumn());
            if (((ExternalModule)module).getContext() == context) {
                context.addForwardReference(fc);
            } else {
                context.getRootContext().addForwardReference(fc);
            }
        } else {
            fc = new FunctionCall(context, func);
            fc.setArguments(params);
            fc.setLocation(ast.getLine(), ast.getColumn());
        }
        return fc;
    }

    public static FunctionCall wrap(XQueryContext context, Function call) throws XPathException {
        int argCount = call.getArgumentCount();
        QName[] variables = new QName[argCount];
        ArrayList<Expression> innerArgs = new ArrayList<Expression>(argCount);
        ArrayList<Expression> wrapperArgs = new ArrayList<Expression>(argCount);
        FunctionSignature signature = call.getSignature();
        ArrayList<SequenceType> newParamTypes = new ArrayList<SequenceType>();
        SequenceType[] paramTypes = signature.getArgumentTypes();
        for (int i = 0; i < argCount; ++i) {
            QName varName;
            Expression param = call.getArgument(i);
            wrapperArgs.add(param);
            variables[i] = varName = new QName("vp" + i, "");
            VariableReference variableReference = new VariableReference(context, varName);
            innerArgs.add(variableReference);
            if (i < paramTypes.length) {
                newParamTypes.add(paramTypes[i]);
                continue;
            }
            newParamTypes.add(paramTypes[paramTypes.length - 1]);
        }
        SequenceType[] newParamArray = newParamTypes.toArray(new SequenceType[newParamTypes.size()]);
        FunctionSignature newSignature = new FunctionSignature(signature);
        newSignature.setArgumentTypes(newParamArray);
        UserDefinedFunction func = new UserDefinedFunction(context, newSignature);
        for (QName varName : variables) {
            func.addVariable(varName);
        }
        call.setArguments(innerArgs);
        func.setFunctionBody(call);
        FunctionCall functionCall = new FunctionCall(context, func);
        functionCall.setArguments(wrapperArgs);
        return functionCall;
    }
}

