/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.HashMap;
import java.util.Map;
import org.exist.dom.QName;
import org.exist.xquery.Annotation;
import org.exist.xquery.FunctionId;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.SequenceType;

public class FunctionSignature {
    public static final SequenceType DEFAULT_TYPE = new SequenceType(11, 7);
    public static final SequenceType[] NO_ARGS = new SequenceType[0];
    private static final String DEPRECATION_REMOVAL_MESSAGE = "\nThis function could be removed in the next major release version.";
    private Annotation[] annotations;
    private final QName name;
    private SequenceType[] arguments;
    private SequenceType returnType;
    private boolean isOverloaded = false;
    private String description = null;
    private String deprecated = null;
    private Map<String, String> metadata = null;

    public static SequenceType[] singleArgument(SequenceType arg) {
        return new SequenceType[]{arg};
    }

    public FunctionSignature(FunctionSignature other) {
        this.name = other.name;
        this.arguments = other.arguments;
        this.returnType = other.returnType;
        this.annotations = other.annotations;
        this.isOverloaded = other.isOverloaded;
        this.deprecated = other.deprecated;
        this.description = other.description;
        this.metadata = other.metadata;
    }

    public FunctionSignature(QName name) {
        this(name, null, DEFAULT_TYPE, false);
    }

    public FunctionSignature(QName name, SequenceType[] arguments, SequenceType returnType) {
        this(name, null, arguments, returnType);
    }

    public FunctionSignature(QName name, SequenceType[] arguments, SequenceType returnType, boolean overloaded) {
        this(name, null, arguments, returnType, overloaded);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType) {
        this(name, description, arguments, returnType, false);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, String deprecated) {
        this(name, description, arguments, returnType, false);
        this.setDeprecated(deprecated);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, FunctionSignature deprecatedBy) {
        this(name, description, arguments, returnType, false, "Moved to the module: " + deprecatedBy.getName().getNamespaceURI() + ", you should now use '" + deprecatedBy.getName().getPrefix() + ":" + deprecatedBy.getName().getLocalPart() + "' instead!");
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, boolean overloaded, String deprecated) {
        this(name, description, arguments, returnType, overloaded);
        this.setDeprecated(deprecated);
    }

    public FunctionSignature(QName name, String description, SequenceType[] arguments, SequenceType returnType, boolean overloaded) {
        this.name = name;
        this.arguments = arguments;
        this.returnType = returnType;
        this.isOverloaded = overloaded;
        this.description = description;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public QName getName() {
        return this.name;
    }

    public int getArgumentCount() {
        if (this.isOverloaded) {
            return -1;
        }
        return this.arguments != null ? this.arguments.length : 0;
    }

    public FunctionId getFunctionId() {
        return new FunctionId(this.name, this.getArgumentCount());
    }

    public SequenceType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(SequenceType type) {
        this.returnType = type;
    }

    public SequenceType[] getArgumentTypes() {
        return this.arguments;
    }

    public void setArgumentTypes(SequenceType[] types) {
        this.arguments = types;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addMetadata(String key, String value) {
        String old;
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>(5);
        }
        if ((old = this.metadata.get(key)) != null) {
            value = old + ", " + value;
        }
        this.metadata.put(key, value);
    }

    public String getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean isOverloaded() {
        return this.isOverloaded;
    }

    public boolean isDeprecated() {
        return this.deprecated != null;
    }

    public String getDeprecated() {
        if (this.deprecated != null && this.deprecated.length() > 0) {
            return this.deprecated + DEPRECATION_REMOVAL_MESSAGE;
        }
        return null;
    }

    public final void setDeprecated(String message) {
        this.deprecated = message;
    }

    public boolean isPrivate() {
        Annotation[] annotations = this.getAnnotations();
        if (annotations != null) {
            for (Annotation annot : annotations) {
                QName qn = annot.getName();
                if (!qn.getNamespaceURI().equals("http://www.w3.org/2005/xpath-functions") || !"private".equals(qn.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name.getStringValue());
        buf.append('(');
        if (this.arguments != null) {
            int var = 97;
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append('$');
                if (this.arguments[i] instanceof FunctionParameterSequenceType) {
                    buf.append(((FunctionParameterSequenceType)this.arguments[i]).getAttributeName());
                } else {
                    buf.append((char)(97 + i));
                }
                buf.append(" as ");
                buf.append(this.arguments[i].toString());
            }
            if (this.isOverloaded) {
                buf.append(", ...");
            }
        }
        buf.append(") ");
        buf.append(this.returnType.toString());
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature other = (FunctionSignature)obj;
        if (this.name == null) {
            if (other.name != null) {
                return false;
            }
            return this.getArgumentCount() == other.getArgumentCount();
        }
        if (this.name.equals(other.name)) {
            return this.getArgumentCount() == other.getArgumentCount();
        }
        return false;
    }
}

