/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.ibm.icu.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Cardinality;
import org.exist.xquery.CastExpression;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.IndexUseReporter;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.pragmas.Optimize;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class GeneralComparison
extends BinaryOp
implements Optimizable,
IndexUseReporter {
    protected Constants.Comparison relation = Constants.Comparison.EQ;
    protected Constants.StringTruncationOperator truncation = Constants.StringTruncationOperator.NONE;
    protected CachedResult cached = null;
    protected Object collationArg = null;
    protected boolean inWhereClause = false;
    protected boolean invalidNodeEvaluation = false;
    protected int rightOpDeps;
    private boolean hasUsedIndex = false;
    private int actualReturnType = 11;
    private LocationStep contextStep = null;
    private QName contextQName = null;
    protected boolean optimizeSelf = false;
    protected boolean optimizeChild = false;
    private int axis = -1;
    private NodeSet preselectResult = null;
    private IndexFlags idxflags = new IndexFlags();

    public GeneralComparison(XQueryContext context, Constants.Comparison relation) {
        this(context, relation, Constants.StringTruncationOperator.NONE);
    }

    public GeneralComparison(XQueryContext context, Constants.Comparison relation, Constants.StringTruncationOperator truncation) {
        super(context);
        this.relation = relation;
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, Constants.Comparison relation) {
        this(context, left, right, relation, Constants.StringTruncationOperator.NONE);
    }

    public GeneralComparison(XQueryContext context, Expression left, Expression right, Constants.Comparison relation, Constants.StringTruncationOperator truncation) {
        super(context);
        boolean didLeftSimplification = false;
        boolean didRightSimplification = false;
        this.relation = relation;
        this.truncation = truncation;
        if (left instanceof PathExpr && ((PathExpr)left).getLength() == 1) {
            left = ((PathExpr)left).getExpression(0);
            didLeftSimplification = true;
        }
        this.add(left);
        if (right instanceof PathExpr && ((PathExpr)right).getLength() == 1) {
            right = ((PathExpr)right).getExpression(0);
            didRightSimplification = true;
        }
        this.add(right);
        if (didLeftSimplification) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Marked left argument as a child expression");
        }
        if (didRightSimplification) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Marked right argument as a child expression");
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.addFlag(16);
        contextInfo.setParent(this);
        super.analyze(contextInfo);
        this.inWhereClause = (contextInfo.getFlags() & 4) != 0;
        this.invalidNodeEvaluation = false;
        if (!Type.subTypeOf(contextInfo.getStaticType(), -1)) {
            this.invalidNodeEvaluation = this.getLeft() instanceof LocationStep && ((LocationStep)this.getLeft()).axis == 12;
        }
        this.rightOpDeps = this.getRight().getDependencies();
        this.getRight().accept(new BasicExpressionVisitor(){

            @Override
            public void visitCastExpr(CastExpression expression) {
                if (PathExpr.LOG.isTraceEnabled()) {
                    PathExpr.LOG.debug("Right operand is a cast expression");
                }
                GeneralComparison.this.rightOpDeps = expression.getInnerExpression().getDependencies();
            }
        });
        contextInfo.removeFlag(16);
        List<LocationStep> steps = BasicExpressionVisitor.findLocationSteps(this.getLeft());
        if (!steps.isEmpty()) {
            NodeTest test;
            LocationStep firstStep = steps.get(0);
            LocationStep lastStep = steps.get(steps.size() - 1);
            if (firstStep != null && steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test2;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test2 = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test2.getName() != null) {
                    this.contextQName = outerStep.getAxis() == 6 || outerStep.getAxis() == 13 ? new QName(test2.getName(), 1) : new QName(test2.getName());
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else if (firstStep != null && lastStep != null && !(test = lastStep.getTest()).isWildcardTest() && test.getName() != null) {
                this.contextQName = lastStep.getAxis() == 6 || lastStep.getAxis() == 13 ? new QName(test.getName(), 1) : new QName(test.getName());
                this.contextStep = lastStep;
                this.axis = firstStep.getAxis();
                if (this.axis == 12 && steps.size() > 1) {
                    if (steps.get(1) != null) {
                        this.axis = steps.get(1).getAxis();
                    } else {
                        this.contextQName = null;
                        this.contextStep = null;
                        this.axis = -1;
                        this.optimizeChild = false;
                    }
                }
                this.optimizeChild = steps.size() == 1 && (this.axis == 5 || this.axis == 6);
            }
        }
    }

    @Override
    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName) != 11;
    }

    @Override
    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    @Override
    public boolean optimizeOnChild() {
        return this.optimizeChild;
    }

    @Override
    public int getOptimizeAxis() {
        return this.axis;
    }

    @Override
    public int returnsType() {
        if (this.inPredicate && !Dependency.dependsOn(this, 2)) {
            return this.getLeft().returnsType();
        }
        return 23;
    }

    @Override
    public int getDependencies() {
        Expression left = this.getLeft();
        int deps = left.getDependencies() & 0xC;
        if (!(!Type.subTypeOf(left.returnsType(), -1) || Dependency.dependsOn(left, 2) || this.inWhereClause && Dependency.dependsOn(left, 8))) {
            return deps + 1;
        }
        return deps + 1 + 2;
    }

    public Constants.Comparison getRelation() {
        return this.relation;
    }

    public Constants.StringTruncationOperator getTruncation() {
        return this.truncation;
    }

    @Override
    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        Sequence rightSeq;
        this.preselectResult = null;
        long start = System.currentTimeMillis();
        int indexType = Optimize.getQNameIndexType(this.context, contextSequence, this.contextQName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using QName index on type " + Type.getTypeName(indexType));
        }
        if ((rightSeq = this.getRight().eval(contextSequence)).getItemCount() > 1) {
            this.preselectResult = new NewArrayNodeSet();
        }
        SequenceIterator itRightSeq = Atomize.atomize(rightSeq).iterate();
        while (itRightSeq.hasNext()) {
            NodeSet temp;
            Collator collator;
            Item key = itRightSeq.nextItem();
            if (this.truncation != Constants.StringTruncationOperator.NONE) {
                if (!Type.subTypeOf(key.getType(), 22)) {
                    LOG.info("Truncated key. Converted from " + Type.getTypeName(key.getType()) + " to xs:string");
                    key = key.convertTo(22);
                }
            } else if (key.getType() != indexType) {
                try {
                    key = key.convertTo(indexType);
                }
                catch (XPathException xpe) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cannot convert key: " + Type.getTypeName(key.getType()) + " to required index type: " + Type.getTypeName(indexType));
                    }
                    throw new XPathException((Expression)this, "Cannot convert key to required index type");
                }
            }
            if (!(key instanceof Indexable)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using QName range index for key: " + key.getStringValue());
            }
            NodeSet contextSet = useContext ? contextSequence.toNodeSet() : null;
            Collator collator2 = collator = this.collationArg != null ? this.getCollator(contextSequence) : null;
            if (this.truncation == Constants.StringTruncationOperator.NONE) {
                temp = this.context.getBroker().getValueIndex().find(this.context.getWatchDog(), this.relation, contextSequence.getDocumentSet(), contextSet, 1, this.contextQName, (Indexable)((Object)key));
                this.hasUsedIndex = true;
            } else {
                try {
                    String matchString = key.getStringValue();
                    int matchType = this.getMatchType(this.truncation);
                    temp = this.context.getBroker().getValueIndex().match(this.context.getWatchDog(), contextSequence.getDocumentSet(), contextSet, 1, matchString, this.contextQName, matchType, collator, this.truncation);
                    this.hasUsedIndex = true;
                }
                catch (EXistException e) {
                    throw new XPathException((Expression)this, "Error during index lookup: " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.preselectResult == null) {
                this.preselectResult = temp;
                continue;
            }
            this.preselectResult.addAll(temp);
        }
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "range", this, 2, System.currentTimeMillis() - start);
        }
        return this.preselectResult == null ? NodeSet.EMPTY_SET : this.preselectResult;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.cached != null && this.cached.isValid(contextSequence, contextItem)) {
            LOG.debug("Using cached results");
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Returned cached result");
            }
            result = this.cached.getResult();
        } else {
            boolean canCache;
            if (this.preselectResult != null && this.preselectResult.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else if (this.contextStep == null || this.preselectResult == null) {
                if (this.inPredicate && !this.invalidNodeEvaluation && !Dependency.dependsOn(this, 2) && Type.subTypeOf(this.getLeft().returnsType(), -1) && (contextSequence == null || contextSequence.isPersistentSet())) {
                    if (contextItem != null) {
                        contextSequence = contextItem.toSequence();
                    }
                    if (!Dependency.dependsOn(this.rightOpDeps, 2)) {
                        result = this.quickNodeSetCompare(contextSequence);
                    } else {
                        NodeSet nodes = (NodeSet)this.getLeft().eval(contextSequence);
                        result = this.nodeSetCompare(nodes, contextSequence);
                    }
                } else {
                    result = this.genericCompare(contextSequence, contextItem);
                }
            } else {
                this.contextStep.setPreloadedData(this.preselectResult.getDocumentSet(), this.preselectResult);
                result = this.getLeft().eval(contextSequence).toNodeSet();
                this.preselectResult = null;
            }
            boolean bl = canCache = contextSequence != null && contextSequence.isCacheable() && !Dependency.dependsOn(this.getLeft(), 2) && !Dependency.dependsOn(this.getRight(), 2) && !Dependency.dependsOnVar(this.getLeft()) && !Dependency.dependsOnVar(this.getRight());
            if (canCache) {
                this.cached = new CachedResult(contextSequence, contextItem, result);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        this.actualReturnType = result.getItemType();
        return result;
    }

    protected Sequence genericCompare(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "genericCompare");
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        return this.genericCompare(ls, contextSequence, contextItem);
    }

    protected Sequence genericCompare(Sequence ls, Sequence contextSequence, Item contextItem) throws XPathException {
        long start = System.currentTimeMillis();
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence);
        BooleanValue result = BooleanValue.FALSE;
        if (ls.isEmpty() && rs.isEmpty()) {
            result = BooleanValue.valueOf(this.compareAtomic(collator, AtomicValue.EMPTY_VALUE, AtomicValue.EMPTY_VALUE));
        } else if (ls.isEmpty() && !rs.isEmpty()) {
            SequenceIterator i2 = Atomize.atomize(rs).iterate();
            while (i2.hasNext()) {
                if (!this.compareAtomic(collator, AtomicValue.EMPTY_VALUE, i2.nextItem().atomize())) continue;
                result = BooleanValue.TRUE;
                break;
            }
        } else if (!ls.isEmpty() && rs.isEmpty()) {
            SequenceIterator i1 = Atomize.atomize(ls).iterate();
            while (i1.hasNext()) {
                AtomicValue lv = i1.nextItem().atomize();
                if (!this.compareAtomic(collator, lv, AtomicValue.EMPTY_VALUE)) continue;
                result = BooleanValue.TRUE;
                break;
            }
        } else if (ls.hasOne() && rs.hasOne() && ls.itemAt(0).getType() != 103 && rs.itemAt(0).getType() != 103) {
            result = BooleanValue.valueOf(this.compareAtomic(collator, ls.itemAt(0).atomize(), rs.itemAt(0).atomize()));
        } else {
            SequenceIterator i1 = Atomize.atomize(ls).iterate();
            block2: while (i1.hasNext()) {
                AtomicValue lv = i1.nextItem().atomize();
                if (rs.isEmpty()) {
                    if (!this.compareAtomic(collator, lv, AtomicValue.EMPTY_VALUE)) continue;
                    result = BooleanValue.TRUE;
                    break;
                }
                if (rs.hasOne() && rs.itemAt(0).getType() != 103) {
                    if (!this.compareAtomic(collator, lv, rs.itemAt(0).atomize())) continue;
                    result = BooleanValue.TRUE;
                    break;
                }
                SequenceIterator i2 = Atomize.atomize(rs).iterate();
                while (i2.hasNext()) {
                    if (!this.compareAtomic(collator, lv, i2.nextItem().atomize())) continue;
                    result = BooleanValue.TRUE;
                    continue block2;
                }
            }
        }
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "range", this, 0, System.currentTimeMillis() - start);
        }
        return result;
    }

    protected Sequence nodeSetCompare(NodeSet nodes, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "nodeSetCompare");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No index: fall back to nodeSetCompare");
        }
        long start = System.currentTimeMillis();
        NewArrayNodeSet result = new NewArrayNodeSet();
        Collator collator = this.getCollator(contextSequence);
        if (contextSequence != null && !contextSequence.isEmpty() && !contextSequence.getDocumentSet().contains(nodes.getDocumentSet())) {
            for (NodeProxy item : nodes) {
                ContextItem context = item.getContext();
                if (context == null) {
                    throw new XPathException((Expression)this, "Internal error: context node missing");
                }
                AtomicValue lv = item.atomize();
                do {
                    Sequence rs = this.getRight().eval(context.getNode().toSequence());
                    SequenceIterator i2 = Atomize.atomize(rs).iterate();
                    while (i2.hasNext()) {
                        AtomicValue rv = i2.nextItem().atomize();
                        if (!this.compareAtomic(collator, lv, rv)) continue;
                        result.add(item);
                    }
                } while ((context = context.getNextDirect()) != null);
            }
        } else {
            for (NodeProxy item : nodes) {
                AtomicValue lv = item.atomize();
                Sequence rs = this.getRight().eval(contextSequence);
                SequenceIterator i2 = Atomize.atomize(rs).iterate();
                while (i2.hasNext()) {
                    AtomicValue rv = i2.nextItem().atomize();
                    if (!this.compareAtomic(collator, lv, rv)) continue;
                    result.add(item);
                }
            }
        }
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "range", this, 0, System.currentTimeMillis() - start);
        }
        return result;
    }

    protected Sequence quickNodeSetCompare(Sequence contextSequence) throws XPathException {
        NodeSet nodes;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "quickNodeSetCompare");
        }
        long start = System.currentTimeMillis();
        Sequence leftSeq = this.getLeft().eval(contextSequence);
        if (!leftSeq.isPersistentSet()) {
            return this.genericCompare(leftSeq, contextSequence, null);
        }
        NodeSet nodeSet = nodes = leftSeq.isEmpty() ? NodeSet.EMPTY_SET : (NodeSet)leftSeq;
        if (!(nodes instanceof VirtualNodeSet) && nodes.isEmpty()) {
            this.hasUsedIndex = true;
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence rightSeq = this.getRight().eval(contextSequence);
        if (rightSeq.isEmpty()) {
            this.hasUsedIndex = true;
            return Sequence.EMPTY_SEQUENCE;
        }
        int indexType = nodes.getIndexType();
        if (indexType != 11) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("found an index of type: " + Type.getTypeName(indexType));
            }
            boolean indexScan = false;
            boolean indexMixed = false;
            QName myContextQName = this.contextQName;
            if (contextSequence != null) {
                IndexFlags iflags = GeneralComparison.checkForQNameIndex(this.idxflags, this.context, contextSequence, myContextQName);
                boolean indexFound = false;
                if (!iflags.indexOnQName) {
                    boolean bl = indexFound = myContextQName != null;
                    if (iflags.partialIndexOnQName) {
                        indexMixed = true;
                    } else {
                        myContextQName = null;
                    }
                }
                if (!indexFound && myContextQName == null && iflags.hasIndexOnQNames) {
                    indexScan = true;
                }
            } else {
                return this.nodeSetCompare(nodes, contextSequence);
            }
            DocumentSet docs = nodes.getDocumentSet();
            NodeSet result = null;
            SequenceIterator itRightSeq = Atomize.atomize(rightSeq).iterate();
            while (itRightSeq.hasNext()) {
                Item key = itRightSeq.nextItem();
                if (this.truncation != Constants.StringTruncationOperator.NONE) {
                    if (!Type.subTypeOf(key.getType(), 22)) {
                        LOG.info("Truncated key. Converted from " + Type.getTypeName(key.getType()) + " to xs:string");
                        key = key.convertTo(22);
                    }
                } else if (key.getType() != indexType) {
                    try {
                        key = key.convertTo(indexType);
                    }
                    catch (XPathException xpe) {
                        if (this.context.getProfiler().isEnabled()) {
                            this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (" + xpe.getMessage() + ")");
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Cannot convert key: " + Type.getTypeName(key.getType()) + " to required index type: " + Type.getTypeName(indexType));
                        }
                        return this.nodeSetCompare(nodes, contextSequence);
                    }
                }
                if (key instanceof Indexable) {
                    Collator collator;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Checking if range index can be used for key: " + key.getStringValue());
                    }
                    Collator collator2 = collator = this.collationArg != null ? this.getCollator(contextSequence) : null;
                    if (Type.subTypeOf(key.getType(), indexType)) {
                        NodeSet ns;
                        if (this.truncation == Constants.StringTruncationOperator.NONE) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Using range index for key: " + key.getStringValue());
                            }
                            this.context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using value index '" + this.context.getBroker().getValueIndex().toString() + "' to find key '" + Type.getTypeName(key.getType()) + "(" + key.getStringValue() + ")'");
                            ns = indexScan ? this.context.getBroker().getValueIndex().findAll(this.context.getWatchDog(), this.relation, docs, nodes, 0, (Indexable)((Object)key)) : this.context.getBroker().getValueIndex().find(this.context.getWatchDog(), this.relation, docs, nodes, 0, myContextQName, (Indexable)((Object)key), indexMixed);
                            this.hasUsedIndex = true;
                            if (result == null) {
                                result = ns;
                                continue;
                            }
                            result = result.union(ns);
                            continue;
                        }
                        if (LOG.isTraceEnabled()) {
                            this.context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using value index '" + this.context.getBroker().getValueIndex().toString() + "' to match key '" + Type.getTypeName(key.getType()) + "(" + key.getStringValue() + ")'");
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Using range index for key: " + key.getStringValue());
                        }
                        try {
                            String matchString = key.getStringValue();
                            int matchType = this.getMatchType(this.truncation);
                            ns = indexScan ? this.context.getBroker().getValueIndex().matchAll(this.context.getWatchDog(), docs, nodes, 0, matchString, matchType, 0, true, collator, this.truncation) : this.context.getBroker().getValueIndex().match(this.context.getWatchDog(), docs, nodes, 0, matchString, myContextQName, matchType, collator, this.truncation);
                            this.hasUsedIndex = true;
                            if (result == null) {
                                result = ns;
                                continue;
                            }
                            result = result.union(ns);
                            continue;
                        }
                        catch (EXistException e) {
                            throw new XPathException((Expression)this, (Throwable)e);
                        }
                    }
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (key is of type: " + Type.getTypeName(key.getType()) + ") whereas index is of type '" + Type.getTypeName(indexType) + "'");
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cannot use range index: key is of type: " + Type.getTypeName(key.getType()) + ") whereas index is of type '" + Type.getTypeName(indexType));
                    }
                    return this.nodeSetCompare(nodes, contextSequence);
                }
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION FALLBACK", "Falling back to nodeSetCompare (key is not an indexable type: " + key.getClass().getName());
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot use key which is of type '" + key.getClass().getName());
                }
                return this.nodeSetCompare(nodes, contextSequence);
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceIndexUsage(this.context, "range", this, 1, System.currentTimeMillis() - start);
            }
            return result;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No suitable index found for key: " + rightSeq.getStringValue());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION FALLBACK", "falling back to nodeSetCompare (no index available)");
        }
        return this.nodeSetCompare(nodes, contextSequence);
    }

    private int getMatchType(Constants.StringTruncationOperator truncation) throws XPathException {
        int matchType;
        switch (truncation) {
            case RIGHT: {
                matchType = 4;
                break;
            }
            case LEFT: {
                matchType = 5;
                break;
            }
            case BOTH: {
                matchType = 3;
                break;
            }
            case EQUALS: {
                matchType = 0;
                break;
            }
            default: {
                LOG.error("Invalid truncation type: " + (Object)((Object)truncation));
                throw new XPathException((Expression)this, "Invalid truncation type: " + (Object)((Object)truncation));
            }
        }
        return matchType;
    }

    private CharSequence getRegexp(String expr) {
        switch (this.truncation) {
            case LEFT: {
                return new StringBuilder().append(expr).append('$');
            }
            case RIGHT: {
                return new StringBuilder().append('^').append(expr);
            }
        }
        return expr;
    }

    private boolean compareAtomic(Collator collator, AtomicValue lv, AtomicValue rv) throws XPathException {
        try {
            int ltype = lv.getType();
            int rtype = rv.getType();
            if (ltype == 21) {
                lv = Type.subTypeOf(rtype, 30) ? lv.convertTo(34) : (rtype == 21 || rtype == 22 ? lv.convertTo(22) : lv.convertTo(rtype));
            }
            if (rtype == 21) {
                rv = Type.subTypeOf(ltype, 30) ? rv.convertTo(34) : (ltype == 21 || ltype == 22 ? rv.convertTo(22) : rv.convertTo(ltype));
            }
            if (this.truncation != Constants.StringTruncationOperator.NONE) {
                lv = lv.convertTo(22);
            }
            switch (this.truncation) {
                case RIGHT: {
                    return lv.startsWith(collator, rv);
                }
                case LEFT: {
                    return lv.endsWith(collator, rv);
                }
                case BOTH: {
                    return lv.contains(collator, rv);
                }
            }
            return rv.isEmpty() ? false : lv.compareTo(collator, this.relation, rv);
        }
        catch (XPathException e) {
            e.setLocation(e.getLine(), e.getColumn());
            throw e;
        }
    }

    private static boolean isEmptyString(AtomicValue lv) throws XPathException {
        return (Type.subTypeOf(lv.getType(), 22) || lv.getType() == 20) && lv.getStringValue().length() == 0;
    }

    @Override
    public boolean hasUsedIndex() {
        return this.hasUsedIndex;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.truncation == Constants.StringTruncationOperator.BOTH) {
            dumper.display("contains").display('(');
            this.getLeft().dump(dumper);
            dumper.display(", ");
            this.getRight().dump(dumper);
            dumper.display(")");
        } else {
            this.getLeft().dump(dumper);
            dumper.display(' ').display(this.relation.generalComparisonSymbol).display(' ');
            this.getRight().dump(dumper);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.truncation == Constants.StringTruncationOperator.BOTH) {
            result.append("contains").append('(');
            result.append(this.getLeft().toString());
            result.append(", ");
            result.append(this.getRight().toString());
            result.append(")");
        } else {
            result.append(this.getLeft().toString());
            result.append(' ').append(this.relation.generalComparisonSymbol).append(' ');
            result.append(this.getRight().toString());
        }
        return result.toString();
    }

    protected void switchOperands() {
        this.context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Switching operands");
        switch (this.relation) {
            case GT: {
                this.relation = Constants.Comparison.LT;
                break;
            }
            case LT: {
                this.relation = Constants.Comparison.GT;
                break;
            }
            case LTEQ: {
                this.relation = Constants.Comparison.GTEQ;
                break;
            }
            case GTEQ: {
                this.relation = Constants.Comparison.LTEQ;
            }
        }
        Expression right = this.getRight();
        this.setRight(this.getLeft());
        this.setLeft(right);
    }

    protected void simplifyOperands() {
        if (!Type.subTypeOf(this.getLeft().returnsType(), -1) && Type.subTypeOf(this.getRight().returnsType(), -1)) {
            this.switchOperands();
        } else if (Cardinality.checkCardinality(4, this.getLeft().getCardinality()) && !Cardinality.checkCardinality(4, this.getRight().getCardinality())) {
            this.switchOperands();
        }
    }

    protected Collator getCollator(Sequence contextSequence) throws XPathException {
        String collationURI;
        if (this.collationArg == null) {
            return this.context.getDefaultCollator();
        }
        if (this.collationArg instanceof Expression) {
            collationURI = ((Expression)this.collationArg).eval(contextSequence).getStringValue();
        } else if (this.collationArg instanceof StringValue) {
            collationURI = ((StringValue)this.collationArg).getStringValue();
        } else {
            return this.context.getDefaultCollator();
        }
        return this.context.getCollator(collationURI);
    }

    public void setCollation(Object collationArg) {
        this.collationArg = collationArg;
    }

    public static final IndexFlags checkForQNameIndex(IndexFlags idxflags, XQueryContext context, Sequence contextSequence, QName contextQName) {
        idxflags.reset(contextQName != null);
        Iterator<Collection> i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = i.next();
            if (collection.getURI().equalsInternal(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            IndexSpec idxcfg = collection.getIndexConfiguration(context.getBroker());
            if (idxflags.indexOnQName && idxcfg.getIndexByQName(contextQName) == null) {
                idxflags.indexOnQName = false;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("cannot use index on QName: " + contextQName + ". Collection " + collection.getURI() + " does not define an index");
                }
            }
            if (!idxflags.hasIndexOnQNames && idxcfg.hasIndexesByQName()) {
                idxflags.hasIndexOnQNames = true;
            }
            if (idxflags.hasIndexOnPaths || !idxcfg.hasIndexesByPath()) continue;
            idxflags.hasIndexOnPaths = true;
        }
        return idxflags;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.getLeft().resetState(postOptimization);
        this.getRight().resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
            this.preselectResult = null;
            this.hasUsedIndex = false;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitGeneralComparison(this);
    }

    public static final class IndexFlags {
        public boolean indexOnQName = true;
        public boolean partialIndexOnQName = false;
        public boolean hasIndexOnPaths = false;
        public boolean hasIndexOnQNames = false;

        public boolean indexOnQName() {
            return this.indexOnQName;
        }

        public boolean hasIndexOnPaths() {
            return this.hasIndexOnPaths;
        }

        public boolean hasIndexOnQNames() {
            return this.hasIndexOnQNames;
        }

        public void reset(boolean indexOnQName) {
            this.indexOnQName = indexOnQName;
            this.partialIndexOnQName = false;
            this.hasIndexOnPaths = false;
            this.hasIndexOnQNames = false;
        }
    }
}

