/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayDeque;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ClosureVariable;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class InlineFunction
extends AbstractExpression {
    public static final QName INLINE_FUNCTION_QNAME = QName.EMPTY_QNAME;
    private UserDefinedFunction function;
    private ArrayDeque<FunctionCall> calls = new ArrayDeque();
    private AnalyzeContextInfo cachedContextInfo;

    public InlineFunction(XQueryContext context, UserDefinedFunction function) {
        super(context);
        this.function = function;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        this.cachedContextInfo.addFlag(1);
        this.cachedContextInfo.setParent(this);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("function");
        this.function.dump(dumper);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        List<ClosureVariable> closureVars = this.context.getLocalStack();
        FunctionCall call = new FunctionCall(this.context, this.function);
        call.getFunction().setClosureVariables(closureVars);
        call.setLocation(this.function.getLine(), this.function.getColumn());
        call.analyze(new AnalyzeContextInfo(this.cachedContextInfo));
        this.calls.push(call);
        return new FunctionReference(call);
    }

    @Override
    public int returnsType() {
        return 101;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.calls.forEach(call -> call.getFunction().setClosureVariables(null));
        }
        this.calls.clear();
        this.function.resetState(postOptimization);
    }
}

