/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class InstanceOfExpression
extends AbstractExpression {
    private final Expression expression;
    private final SequenceType type;

    public InstanceOfExpression(XQueryContext context, Expression expr, SequenceType type) {
        super(context);
        this.expression = expr;
        this.type = type;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        BooleanValue result = BooleanValue.TRUE;
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        int requiredCardinality = this.type.getCardinality();
        if (!seq.isEmpty() && requiredCardinality == 1) {
            result = BooleanValue.FALSE;
        } else if (seq.isEmpty() && (requiredCardinality & 1) == 0) {
            result = BooleanValue.FALSE;
        } else if (seq.hasMany() && (requiredCardinality & 4) == 0) {
            result = BooleanValue.FALSE;
        } else {
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (this.type.checkType(next)) continue;
                result = BooleanValue.FALSE;
                break;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" instance of ");
        dumper.display(this.type.toString());
    }

    public String toString() {
        return String.valueOf(this.expression) + " instance of " + this.type.toString();
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }
}

