/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.Writer;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class InternalFunctionCall
extends Function {
    private final Function function;

    public InternalFunctionCall(Function f) {
        super(f.getContext(), f.getSignature());
        this.function = f;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.proceed(this);
        long start = System.currentTimeMillis();
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceFunctionStart(this);
        }
        this.context.stackEnter(this);
        try {
            Sequence sequence = this.function.eval(contextSequence, contextItem);
            return sequence;
        }
        catch (XPathException e) {
            if (e.getLine() <= 0) {
                e.setLocation(this.line, this.column, this.getSource());
            }
            throw e;
        }
        finally {
            this.context.stackLeave(this);
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceFunctionEnd(this, System.currentTimeMillis() - start);
            }
        }
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public int getArgumentCount() {
        return this.function.getArgumentCount();
    }

    @Override
    public QName getName() {
        return this.function.getName();
    }

    @Override
    public int returnsType() {
        return this.function.returnsType();
    }

    @Override
    public int getCardinality() {
        return this.function.getCardinality();
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        try {
            this.function.analyze(contextInfo);
        }
        catch (XPathException e) {
            if (e.getLine() <= 0) {
                e.setLocation(this.line, this.column, this.getSource());
            }
            throw e;
        }
    }

    @Override
    public void setParent(Expression parent) {
        this.function.setParent(parent);
    }

    @Override
    public Expression getParent() {
        return this.function.getParent();
    }

    @Override
    public XQueryContext getContext() {
        return this.function.getContext();
    }

    @Override
    public int getLine() {
        return this.function.getLine();
    }

    @Override
    public int getColumn() {
        return this.function.getColumn();
    }

    @Override
    public void setASTNode(XQueryAST ast) {
        this.function.setASTNode(ast);
    }

    @Override
    public void setLocation(int line, int column) {
        this.function.setLocation(line, column);
    }

    @Override
    public void add(Expression s) {
        this.function.add(s);
    }

    @Override
    public void add(PathExpr path) {
        this.function.add(path);
    }

    @Override
    public void addPath(PathExpr path) {
        this.function.addPath(path);
    }

    @Override
    public void addPredicate(Predicate pred) {
        this.function.addPredicate(pred);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.function.dump(dumper);
    }

    @Override
    public void dump(Writer writer) {
        this.function.dump(writer);
    }

    @Override
    public Expression getArgument(int pos) {
        return this.function.getArgument(pos);
    }

    @Override
    public Sequence[] getArguments(Sequence contextSequence, Item contextItem) throws XPathException {
        return this.function.getArguments(contextSequence, contextItem);
    }

    @Override
    public DocumentSet getContextDocSet() {
        return this.function.getContextDocSet();
    }

    @Override
    public int getDependencies() {
        return this.function.getDependencies();
    }

    @Override
    public DocumentSet getDocumentSet() {
        return this.function.getDocumentSet();
    }

    @Override
    public Expression getExpression(int pos) {
        return this.function.getExpression(pos);
    }

    @Override
    public Expression getLastExpression() {
        return this.function.getLastExpression();
    }

    @Override
    public int getLength() {
        return this.function.getLength();
    }

    @Override
    public String getLiteralValue() {
        return this.function.getLiteralValue();
    }

    @Override
    public FunctionSignature getSignature() {
        return this.function.getSignature();
    }

    @Override
    public boolean isCalledAs(String localName) {
        return this.function.isCalledAs(localName);
    }

    @Override
    public void replaceLastExpression(Expression s) {
        this.function.replaceLastExpression(s);
    }

    @Override
    public void reset() {
        this.function.reset();
    }

    @Override
    public void resetState(boolean postOptimization) {
        this.function.resetState(postOptimization);
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        this.function.setArguments(arguments);
    }

    @Override
    public void setContext(XQueryContext context) {
        this.function.setContext(context);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        this.function.setContextDocSet(contextSet);
    }

    @Override
    public String toString() {
        return this.function.toString();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.function.accept(visitor);
    }
}

