/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;

public class JavaCall
extends Function {
    private final QName qname;
    private String name;
    private Class<?> myClass = null;
    private List<AccessibleObject> candidateMethods = new ArrayList<AccessibleObject>(5);

    public JavaCall(XQueryContext context, QName qname) throws XPathException {
        super(context, null);
        this.qname = qname;
        String namespaceURI = context.getURIForPrefix(qname.getPrefix());
        if (!namespaceURI.startsWith("java:")) {
            throw new XPathException((Expression)this, "Internal error: prefix " + qname.getPrefix() + " does not resolve to a Java class");
        }
        namespaceURI = namespaceURI.substring("java:".length());
        try {
            LOG.debug("Trying to find class " + namespaceURI);
            this.myClass = Class.forName(namespaceURI);
        }
        catch (ClassNotFoundException e) {
            throw new XPathException((Expression)this, "Class: " + namespaceURI + " not found", (Throwable)e);
        }
        this.name = qname.getLocalPart();
        if (this.name.indexOf(45) > 0) {
            StringBuilder buf = new StringBuilder();
            boolean afterHyphen = false;
            for (int i = 0; i < this.name.length(); ++i) {
                char ch = this.name.charAt(i);
                if (ch == '-') {
                    afterHyphen = true;
                    continue;
                }
                if (afterHyphen) {
                    buf.append(Character.toUpperCase(ch));
                    afterHyphen = false;
                    continue;
                }
                buf.append(ch);
            }
            this.name = buf.toString();
            LOG.debug("converted method name to " + this.name);
        }
    }

    @Override
    public QName getName() {
        return this.qname;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        int argCount = arguments.size();
        for (Expression expression : arguments) {
            this.steps.add(expression);
        }
        if ("new".equals(this.name)) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = this.myClass.getConstructors()) {
                Class<?>[] paramTypes;
                if (!Modifier.isPublic(constructor.getModifiers()) || (paramTypes = constructor.getParameterTypes()).length != argCount) continue;
                LOG.debug("Found constructor " + constructor.toString());
                this.candidateMethods.add(constructor);
            }
            if (this.candidateMethods.size() == 0) {
                String string = "no constructor found with " + argCount + " arguments";
                throw new XPathException((Expression)this, string, (Throwable)new NoSuchMethodException(string));
            }
        } else {
            Method[] methods;
            for (Method method : methods = this.myClass.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(this.name)) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (Modifier.isStatic(method.getModifiers())) {
                    if (paramTypes.length != argCount) continue;
                    LOG.debug("Found static method " + method.toString());
                    this.candidateMethods.add(method);
                    continue;
                }
                if (paramTypes.length != argCount - 1) continue;
                LOG.debug("Found method " + method.toString());
                this.candidateMethods.add(method);
            }
            if (this.candidateMethods.size() == 0) {
                String string = "no method matches " + this.name + " with " + argCount + " arguments";
                throw new XPathException((Expression)this, string, (Throwable)new NoSuchMethodException(string));
            }
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        int i;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence[] args = this.getArguments(contextSequence, contextItem);
        AccessibleObject bestMethod = this.candidateMethods.get(0);
        int[] conversionPrefs = this.getConversionPreferences(bestMethod, args);
        block6: for (AccessibleObject nextMethod : this.candidateMethods) {
            int[] prefs = this.getConversionPreferences(nextMethod, args);
            for (int j = 0; j < prefs.length; ++j) {
                if (prefs[j] >= conversionPrefs[j]) continue;
                bestMethod = nextMethod;
                conversionPrefs = prefs;
                continue block6;
            }
        }
        Class<?>[] paramTypes = null;
        boolean isStatic = true;
        if (bestMethod instanceof Constructor) {
            paramTypes = ((Constructor)bestMethod).getParameterTypes();
        } else {
            paramTypes = ((Method)bestMethod).getParameterTypes();
            isStatic = Modifier.isStatic(((Method)bestMethod).getModifiers());
        }
        Object[] params = new Object[isStatic ? args.length : args.length - 1];
        if (isStatic) {
            for (i = 0; i < args.length; ++i) {
                params[i] = args[i].toJavaObject(paramTypes[i]);
            }
        } else {
            for (i = 1; i < args.length; ++i) {
                params[i - 1] = args[i].toJavaObject(paramTypes[i - 1]);
            }
        }
        if (bestMethod instanceof Constructor) {
            try {
                Object object = ((Constructor)bestMethod).newInstance(params);
                result = new JavaObjectValue(object);
            }
            catch (IllegalArgumentException e) {
                throw new XPathException((Expression)this, "illegal argument to constructor " + bestMethod.toString() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof XPathException) {
                    throw (XPathException)e;
                }
                throw new XPathException((Expression)this, "exception while calling constructor " + bestMethod.toString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            Object invocationResult = isStatic ? ((Method)bestMethod).invoke(null, params) : ((Method)bestMethod).invoke(args[0].toJavaObject(this.myClass), params);
            result = XPathUtil.javaObjectToXPath(invocationResult, this.getContext());
        }
        catch (IllegalArgumentException e) {
            throw new XPathException((Expression)this, "illegal argument to method " + bestMethod.toString() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof XPathException) {
                throw (XPathException)e;
            }
            throw new XPathException((Expression)this, "exception while calling method " + bestMethod.toString() + ": " + e.getMessage(), (Throwable)e);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        if (result == null) {
            result = Sequence.EMPTY_SEQUENCE;
        }
        return result;
    }

    @Override
    public int returnsType() {
        return 11;
    }

    private int[] getConversionPreferences(AccessibleObject method, Sequence[] args) {
        int[] prefs = new int[args.length];
        Class<?>[] paramTypes = null;
        boolean isStatic = true;
        if (method instanceof Constructor) {
            paramTypes = ((Constructor)method).getParameterTypes();
        } else {
            paramTypes = ((Method)method).getParameterTypes();
            isStatic = Modifier.isStatic(((Method)method).getModifiers());
            if (!isStatic) {
                Class[] nonStaticTypes = new Class[paramTypes.length + 1];
                nonStaticTypes[0] = this.myClass;
                System.arraycopy(paramTypes, 0, nonStaticTypes, 1, paramTypes.length);
                paramTypes = nonStaticTypes;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            prefs[i] = args[i].conversionPreference(paramTypes[i]);
        }
        return prefs;
    }
}

