/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Cardinality;
import org.exist.xquery.DeferredFunctionCall;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class LetExpr
extends BindingExpression {
    public LetExpr(XQueryContext context) {
        super(context);
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return FLWORClause.ClauseType.LET;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            contextInfo.setParent(this);
            AnalyzeContextInfo varContextInfo = new AnalyzeContextInfo(contextInfo);
            this.inputSequence.analyze(varContextInfo);
            LocalVariable inVar = new LocalVariable(QName.parse(this.context, this.varName, null));
            inVar.setSequenceType(this.sequenceType);
            inVar.setStaticType(varContextInfo.getStaticReturnType());
            this.context.declareVariableBinding(inVar);
            this.context.setContextSequencePosition(0, null);
            this.returnExpr.analyze(contextInfo);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + this.varName);
        }
        finally {
            this.context.popLocalVariables(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        this.context.expressionStart(this);
        this.context.pushDocumentContext();
        try {
            Sequence in;
            LocalVariable mark = this.context.markLocalVariables(false);
            Sequence resultSequence = null;
            try {
                in = this.inputSequence.eval(contextSequence, null);
                LetExpr.clearContext(this.getExpressionId(), in);
                LocalVariable var = this.createVariable(this.varName);
                var.setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(var);
                var.setValue(in);
                if (this.sequenceType == null) {
                    var.checkType();
                }
                var.setContextDocs(this.inputSequence.getContextDocSet());
                this.registerUpdateListener(in);
                resultSequence = this.returnExpr.eval(contextSequence, null);
                if (this.sequenceType != null) {
                    int actualCardinality = var.getValue().isEmpty() ? 1 : (var.getValue().hasMany() ? 4 : 2);
                    if (!Cardinality.checkCardinality(this.sequenceType.getCardinality(), actualCardinality)) {
                        throw new XPathException(this, ErrorCodes.XPTY0004, "Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(actualCardinality), in);
                    }
                    if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1) ? !var.getValue().isEmpty() && !Type.subTypeOf(var.getValue().getItemType(), this.sequenceType.getPrimaryType()) : !var.getValue().isEmpty() && !Type.subTypeOf(var.getValue().getItemType(), this.sequenceType.getPrimaryType())) {
                        throw new XPathException(this, ErrorCodes.XPTY0004, "Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(var.getValue().getItemType()), in);
                    }
                }
                this.context.popLocalVariables(mark, resultSequence);
            }
            catch (Throwable throwable) {
                this.context.popLocalVariables(mark, resultSequence);
                throw throwable;
            }
            LetExpr.clearContext(this.getExpressionId(), in);
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "", resultSequence);
            }
            if (resultSequence == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            if (!(resultSequence instanceof DeferredFunctionCall)) {
                this.setActualReturnType(resultSequence.getItemType());
            }
            if (this.getPreviousClause() == null) {
                resultSequence = this.postEval(resultSequence);
            }
            Sequence sequence = resultSequence;
            return sequence;
        }
        finally {
            this.context.popDocumentContext();
            this.context.expressionEnd(this);
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("let ", this.line);
        dumper.startIndent();
        dumper.display("$").display(this.varName);
        dumper.display(" := ");
        this.inputSequence.dump(dumper);
        dumper.endIndent();
        if (this.returnExpr instanceof LetExpr) {
            dumper.display(", ");
        } else {
            dumper.nl().display("return ");
        }
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("let ");
        result.append("$").append(this.varName);
        result.append(" := ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        if (this.returnExpr instanceof LetExpr) {
            result.append(", ");
        } else {
            result.append("return ");
        }
        result.append(this.returnExpr.toString());
        return result.toString();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitLetExpression(this);
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return true;
    }
}

