/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.exist.dom.memtree.InMemoryNodeSet;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtNodeSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.indexing.StructuralIndex;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.stax.StaXUtil;
import org.exist.storage.UpdateListener;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AnyNodeTest;
import org.exist.xquery.CachedResult;
import org.exist.xquery.ChildSelector;
import org.exist.xquery.Dependency;
import org.exist.xquery.DescendantOrSelfSelector;
import org.exist.xquery.DescendantSelector;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Predicate;
import org.exist.xquery.SelfSelector;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocationStep
extends Step {
    private static final int INDEX_SCAN_THRESHOLD = 10000;
    protected NodeSet currentSet = null;
    protected DocumentSet currentDocs = null;
    protected UpdateListener listener = null;
    protected Expression parent = null;
    protected CachedResult cached = null;
    protected int parentDeps = -1;
    protected boolean preloadedData = false;
    protected boolean optimized = false;
    protected boolean inUpdate = false;
    protected boolean useDirectChildSelect = false;
    protected boolean applyPredicate = true;
    private Integer nodeTestType = null;

    public LocationStep(XQueryContext context, int axis) {
        super(context, axis);
    }

    public LocationStep(XQueryContext context, int axis, NodeTest test) {
        super(context, axis, test);
    }

    @Override
    public int getDependencies() {
        int deps = 1;
        if (!this.inPredicate && (this.axis == 12 || this.parent != null && this.parent.getSubExpressionCount() > 0 && this.parent.getSubExpression(0) == this)) {
            deps |= 2;
        }
        for (Predicate pred : this.predicates) {
            deps |= pred.getDependencies();
        }
        return deps;
    }

    protected boolean hasPreloadedData() {
        if (this.preloadedData) {
            this.context.getProfiler().message((Expression)this, 2, null, "Preloaded NodeSets");
            return true;
        }
        return false;
    }

    public void setPreloadedData(DocumentSet docs, NodeSet nodes) {
        this.preloadedData = true;
        this.currentDocs = docs;
        this.currentSet = nodes;
        this.optimized = true;
    }

    protected Sequence applyPredicate(Sequence outerSequence, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (contextSequence == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.predicates.size() == 0 || !this.applyPredicate || !(contextSequence instanceof VirtualNodeSet) && contextSequence.isEmpty()) {
            return contextSequence;
        }
        Predicate pred = (Predicate)this.predicates.get(0);
        if (this.abbreviatedStep && (pred.getExecutionMode() != 0 || !contextSequence.isPersistentSet())) {
            result = new ValueSequence();
            ((ValueSequence)result).keepUnOrdered(this.unordered);
            if (contextSequence.isPersistentSet()) {
                NodeSet contextSet = contextSequence.toNodeSet();
                outerSequence = contextSet.getParents(-1);
                SequenceIterator i = outerSequence.iterate();
                while (i.hasNext()) {
                    NodeValue node = (NodeValue)i.nextItem();
                    NodeSet newContextSeq = contextSet.selectParentChild((NodeSet)((Object)node), 1, this.getExpressionId());
                    Sequence temp = this.processPredicate(outerSequence, newContextSeq);
                    result.addAll(temp);
                }
            } else {
                MemoryNodeSet nodes = contextSequence.toMemNodeSet();
                outerSequence = nodes.getParents(new AnyNodeTest());
                SequenceIterator i = outerSequence.iterate();
                while (i.hasNext()) {
                    NodeValue node = (NodeValue)i.nextItem();
                    InMemoryNodeSet newSet = new InMemoryNodeSet();
                    ((NodeImpl)node).selectChildren(this.test, newSet);
                    Sequence temp = this.processPredicate(outerSequence, newSet);
                    result.addAll(temp);
                }
            }
        } else {
            result = this.processPredicate(outerSequence, contextSequence);
        }
        return result;
    }

    private Sequence processPredicate(Sequence outerSequence, Sequence contextSequence) throws XPathException {
        Sequence result = contextSequence;
        Iterator i = this.predicates.iterator();
        while (i.hasNext() && (result instanceof VirtualNodeSet || !result.isEmpty())) {
            Predicate pred = (Predicate)i.next();
            pred.setContextDocSet(this.getContextDocSet());
            result = pred.evalPredicate(outerSequence, result, this.axis);
            outerSequence = null;
            this.context.setContextSequencePosition(-1, null);
        }
        return result;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        this.parentDeps = this.parent.getDependencies();
        if ((contextInfo.getFlags() & 8) > 0) {
            this.inUpdate = true;
        }
        if ((contextInfo.getFlags() & 0x20) > 0) {
            this.useDirectChildSelect = true;
        }
        if (this.axis == 12 && this.test.getType() == -1) {
            contextInfo.addFlag(128);
        }
        if (this.axis == 8 && this.isAbbreviated()) {
            this.axis = 7;
        }
        switch (this.axis) {
            case 12: {
                Expression contextStep;
                if (this.getTest().getType() == -1 || !((contextStep = contextInfo.getContextStep()) instanceof LocationStep)) break;
                LocationStep cStep = (LocationStep)contextStep;
                if (this.parent.getSubExpressionCount() == 1 && !Type.subTypeOf(this.getTest().getType(), cStep.getTest().getType())) {
                    throw new XPathException((Expression)this, ErrorCodes.XPST0005, "Got nothing from self::" + this.getTest() + ", because parent node kind " + Type.getTypeName(cStep.getTest().getType()));
                }
                if (this.parent.getSubExpressionCount() != 1 || cStep.getTest().isWildcardTest() || this.getTest().isWildcardTest() || cStep.getTest().equals(this.getTest())) break;
                throw new XPathException((Expression)this, ErrorCodes.XPST0005, "Self::" + this.getTest() + " called on set of nodes which do not contain any nodes of this name.");
            }
            case 8: {
                LocationStep cStep;
                Expression contextStep = contextInfo.getContextStep();
                if (!(contextStep instanceof LocationStep) || (cStep = (LocationStep)contextStep).getTest().getType() != 2 && cStep.getTest().getType() != 3 || cStep.getTest() == this.getTest()) break;
                throw new XPathException((Expression)this, ErrorCodes.XPST0005, "Descendant-or-self::" + this.getTest() + " from an attribute gets nothing.");
            }
        }
        super.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.needsComputation()) {
            if (contextSequence == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context sequence for '" + this.toString() + "'");
            }
            try {
                switch (this.axis) {
                    case 7: 
                    case 8: {
                        result = this.getDescendants(this.context, contextSequence);
                        break;
                    }
                    case 5: {
                        result = this.getChildren(this.context, contextSequence);
                        break;
                    }
                    case 0: 
                    case 1: {
                        result = this.getAncestors(this.context, contextSequence);
                        break;
                    }
                    case 2: {
                        result = this.getParents(this.context, contextSequence);
                        break;
                    }
                    case 12: {
                        if (!(contextSequence instanceof VirtualNodeSet) && Type.subTypeOf(contextSequence.getItemType(), 20)) {
                            if (!this.test.isWildcardTest()) {
                                throw new XPathException((Expression)this, this.test.toString() + " cannot be applied to an atomic value.");
                            }
                            result = contextSequence;
                            break;
                        }
                        result = this.getSelf(this.context, contextSequence);
                        break;
                    }
                    case 6: 
                    case 13: {
                        result = this.getAttributes(this.context, contextSequence);
                        break;
                    }
                    case 3: {
                        result = this.getPreceding(this.context, contextSequence);
                        break;
                    }
                    case 9: {
                        result = this.getFollowing(this.context, contextSequence);
                        break;
                    }
                    case 4: 
                    case 10: {
                        result = this.getSiblings(this.context, contextSequence);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported axis specified");
                    }
                }
            }
            catch (XPathException e) {
                if (e.getLine() <= 0) {
                    e.setLocation(this.getLine(), this.getColumn(), this.getSource());
                }
                throw e;
            }
        } else {
            result = NodeSet.EMPTY_SET;
        }
        if (this.axis != 12 && contextSequence != null && contextSequence.isCacheable()) {
            this.cached = new CachedResult(contextSequence, contextItem, result);
            this.registerUpdateListener();
        }
        result.removeDuplicates();
        result = this.applyPredicate(contextSequence, result);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private boolean needsComputation() {
        switch (this.axis) {
            case 1: 
            case 2: {
                if (this.nodeTestType == null) {
                    this.nodeTestType = this.test.getType();
                }
                if (this.nodeTestType == -1 || this.nodeTestType == 1 || this.nodeTestType == 4) break;
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "avoid useless computations");
                }
                return false;
            }
        }
        return true;
    }

    protected Sequence getSelf(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.getSelf(this.test);
        }
        if (this.hasPreloadedData() && !this.test.isWildcardTest()) {
            NodeSet ns = null;
            if (contextSequence instanceof NodeSet) {
                ns = (NodeSet)contextSequence;
            }
            NodeProxy np = null;
            for (NodeProxy p : this.currentSet) {
                p.addContextNode(this.contextId, p);
                if (ns == null || (np = ns.get(p)) == null || np.getMatches() == null) continue;
                p.addMatch(np.getMatches());
            }
            return this.currentSet;
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            if (this.nodeTestType == null) {
                this.nodeTestType = this.test.getType();
            }
            if (Type.subTypeOf(this.nodeTestType, -1)) {
                if (-1 != this.contextId) {
                    if (contextSet instanceof VirtualNodeSet) {
                        ((VirtualNodeSet)contextSet).setInPredicate(true);
                        ((VirtualNodeSet)contextSet).setContextId(this.contextId);
                        ((VirtualNodeSet)contextSet).setSelfIsContext();
                    } else if (Type.subTypeOf(contextSet.getItemType(), -1)) {
                        for (NodeProxy p : contextSet) {
                            if (!this.test.matches(p)) continue;
                            p.addContextNode(this.contextId, p);
                        }
                    }
                }
                return contextSet;
            }
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        SelfSelector selector = new SelfSelector(contextSet, this.contextId);
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector, this);
    }

    protected Sequence getAttributes(XQueryContext context, Sequence contextSequence) throws XPathException {
        NodeSelector selector;
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            if (this.axis == 13) {
                return nodes.getDescendantAttributes(this.test);
            }
            return nodes.getAttributes(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (!this.hasPreloadedData() && this.test.isWildcardTest()) {
            VirtualNodeSet result = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            result.setInPredicate(-1 != this.contextId);
            return result;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)1, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 6: {
                        return this.currentSet.selectParentChild(contextSet, 1, this.contextId);
                    }
                    case 13: {
                        return this.currentSet.selectAncestorDescendant(contextSet, 1, false, this.contextId, true);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (!contextSet.getProcessInReverseOrder()) {
            return index.findDescendantsByTagName((byte)1, this.test.getName(), this.axis, docs, contextSet, this.contextId, this);
        }
        switch (this.axis) {
            case 6: {
                selector = new ChildSelector(contextSet, this.contextId);
                break;
            }
            case 13: {
                selector = new DescendantSelector(contextSet, this.contextId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        return index.findElementsByTagName((byte)1, docs, this.test.getName(), selector, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sequence getChildren(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.getChildren(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (!this.hasPreloadedData() && this.test.isWildcardTest() || this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.useDirectChildSelect) {
            NewArrayNodeSet result = new NewArrayNodeSet();
            for (NodeProxy p : contextSet) {
                result.addAll(p.directSelectChild(this.test.getName(), this.contextId));
            }
            return result;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                return this.currentSet.selectParentChild(contextSet, 1, this.contextId);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (!contextSet.getProcessInReverseOrder() && !(contextSet instanceof VirtualNodeSet) && contextSet.getLength() < 10000) {
            return index.findDescendantsByTagName((byte)0, this.test.getName(), this.axis, docs, contextSet, this.contextId, this.parent);
        }
        ChildSelector selector = new ChildSelector(contextSet, this.contextId);
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector, this);
    }

    protected Sequence getDescendants(XQueryContext context, Sequence contextSequence) throws XPathException {
        DescendantSelector selector;
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.getDescendants(this.axis == 8, this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (!this.hasPreloadedData() && this.test.isWildcardTest() || this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 8: {
                        NodeSet tempSet = this.currentSet.selectAncestorDescendant(contextSet, 1, true, this.contextId, true);
                        return tempSet;
                    }
                    case 7: {
                        return this.currentSet.selectAncestorDescendant(contextSet, 1, false, this.contextId, true);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = contextSet.getDocumentSet();
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (!contextSet.getProcessInReverseOrder() && (contextSet instanceof VirtualNodeSet || contextSet.getLength() < 10000)) {
            return index.findDescendantsByTagName((byte)0, this.test.getName(), this.axis, docs, contextSet, this.contextId, this);
        }
        switch (this.axis) {
            case 8: {
                selector = new DescendantOrSelfSelector(contextSet, this.contextId);
                break;
            }
            case 7: {
                selector = new DescendantSelector(contextSet, this.contextId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector, this);
    }

    protected Sequence getSiblings(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            if (this.axis == 4) {
                return nodes.getPrecedingSiblings(this.test);
            }
            return nodes.getFollowingSiblings(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            NewArrayNodeSet result = new NewArrayNodeSet();
            try {
                for (NodeProxy current : contextSet) {
                    if (NodeId.ROOT_NODE.equals(current.getNodeId())) continue;
                    NodeProxy parent = new NodeProxy(current.getOwnerDocument(), current.getNodeId().getParentId());
                    StreamFilter filter = this.axis == 4 ? new PrecedingSiblingFilter(this.test, current, result, this.contextId) : new FollowingSiblingFilter(this.test, current, result, this.contextId);
                    IEmbeddedXMLStreamReader reader = context.getBroker().getXMLStreamReader(parent, false);
                    reader.filter(filter);
                }
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
            return result;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equalDocs(this.currentDocs)) {
                StructuralIndex index = context.getBroker().getStructuralIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            switch (this.axis) {
                case 4: {
                    return this.currentSet.selectPrecedingSiblings(contextSet, this.contextId);
                }
                case 10: {
                    return this.currentSet.selectFollowingSiblings(contextSet, this.contextId);
                }
            }
            throw new IllegalArgumentException("Unsupported axis specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sequence getPreceding(XQueryContext context, Sequence contextSequence) throws XPathException {
        Predicate pred;
        Sequence seq;
        NumericValue v;
        int position = -1;
        if (this.hasPositionalPredicate && !(v = (NumericValue)(seq = (pred = (Predicate)this.predicates.get(0)).preprocess()).itemAt(0)).hasFractionalPart() && !v.isZero()) {
            position = v.getInt();
        }
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            if (this.hasPositionalPredicate && position > -1) {
                this.applyPredicate = false;
            }
            return nodes.getPreceding(this.test, position);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            try {
                NewArrayNodeSet result = new NewArrayNodeSet();
                for (NodeProxy next : contextSet) {
                    NodeList cl = next.getOwnerDocument().getChildNodes();
                    for (int j = 0; j < cl.getLength(); ++j) {
                        NodeHandle node = (NodeHandle)((Object)cl.item(j));
                        NodeProxy root = new NodeProxy(node);
                        PrecedingFilter filter = new PrecedingFilter(this.test, next, result, this.contextId);
                        IEmbeddedXMLStreamReader reader = context.getBroker().getXMLStreamReader(root, false);
                        reader.filter(filter);
                    }
                }
                return result;
            }
            catch (XMLStreamException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equalDocs(this.currentDocs)) {
                StructuralIndex index = context.getBroker().getStructuralIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            if (this.hasPositionalPredicate) {
                try {
                    this.applyPredicate = false;
                    return this.currentSet.selectPreceding(contextSet, position, this.contextId);
                }
                catch (UnsupportedOperationException e) {
                    return this.currentSet.selectPreceding(contextSet, this.contextId);
                }
            }
            return this.currentSet.selectPreceding(contextSet, this.contextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sequence getFollowing(XQueryContext context, Sequence contextSequence) throws XPathException {
        Predicate pred;
        Sequence seq;
        NumericValue v;
        int position = -1;
        if (this.hasPositionalPredicate && !(v = (NumericValue)(seq = (pred = (Predicate)this.predicates.get(0)).preprocess()).itemAt(0)).hasFractionalPart() && !v.isZero()) {
            position = v.getInt();
        }
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            if (this.hasPositionalPredicate && position > -1) {
                this.applyPredicate = false;
            }
            return nodes.getFollowing(this.test, position);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest() && this.test.getType() != 4) {
            try {
                NewArrayNodeSet result = new NewArrayNodeSet();
                for (NodeProxy next : contextSet) {
                    NodeList cl = next.getOwnerDocument().getChildNodes();
                    for (int j = 0; j < cl.getLength(); ++j) {
                        NodeHandle node = (NodeHandle)((Object)cl.item(j));
                        NodeProxy root = new NodeProxy(node);
                        FollowingFilter filter = new FollowingFilter(this.test, next, result, this.contextId);
                        IEmbeddedXMLStreamReader reader = context.getBroker().getXMLStreamReader(root, false);
                        reader.filter(filter);
                    }
                }
                return result;
            }
            catch (XMLStreamException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equalDocs(this.currentDocs)) {
                StructuralIndex index = context.getBroker().getStructuralIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            if (this.hasPositionalPredicate) {
                try {
                    this.applyPredicate = false;
                    return this.currentSet.selectFollowing(contextSet, position, this.contextId);
                }
                catch (UnsupportedOperationException e) {
                    return this.currentSet.selectFollowing(contextSet, this.contextId);
                }
            }
            return this.currentSet.selectFollowing(contextSet, this.contextId);
        }
    }

    protected Sequence getAncestors(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.getAncestors(this.axis == 1, this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.isWildcardTest()) {
            NewArrayNodeSet result = new NewArrayNodeSet();
            result.setProcessInReverseOrder(true);
            for (NodeProxy current : contextSet) {
                NodeProxy ancestor;
                if (this.axis == 1 && this.test.matches(current)) {
                    ancestor = new NodeProxy(current);
                    ancestor.setNodeType((short)1);
                    NodeProxy t = result.get(ancestor);
                    if (t == null) {
                        if (-1 != this.contextId) {
                            ancestor.addContextNode(this.contextId, current);
                        } else {
                            ancestor.copyContext(current);
                        }
                        ancestor.addMatches(current);
                        result.add(ancestor);
                    } else {
                        t.addContextNode(this.contextId, current);
                        t.addMatches(current);
                    }
                }
                for (NodeId parentID = current.getNodeId().getParentId(); parentID != null; parentID = parentID.getParentId()) {
                    ancestor = new NodeProxy(current.getOwnerDocument(), parentID, 1);
                    if (parentID == NodeId.DOCUMENT_NODE || parentID.getTreeLevel() == 1 && current.getOwnerDocument().getCollection().isTempCollection() || !this.test.matches(ancestor)) continue;
                    NodeProxy t = result.get(ancestor);
                    if (t == null) {
                        if (-1 != this.contextId) {
                            ancestor.addContextNode(this.contextId, current);
                        } else {
                            ancestor.copyContext(current);
                        }
                        ancestor.addMatches(current);
                        result.add(ancestor);
                        continue;
                    }
                    t.addContextNode(this.contextId, current);
                    t.addMatches(current);
                }
            }
            return result;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 1: {
                        return this.currentSet.selectAncestors(contextSet, true, this.contextId);
                    }
                    case 0: {
                        return this.currentSet.selectAncestors(contextSet, false, this.contextId);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        return index.findAncestorsByTagName((byte)0, this.test.getName(), this.axis, docs, contextSet, this.contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sequence getParents(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.getParents(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.isWildcardTest()) {
            NodeSet temp = contextSet.getParents(this.contextId);
            NewArrayNodeSet result = new NewArrayNodeSet();
            for (NodeProxy p : temp) {
                if (!this.test.matches(p)) continue;
                result.add(p);
            }
            return result;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext result = context;
            synchronized (result) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                return contextSet.selectParentChild(this.currentSet, 0);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        return index.findAncestorsByTagName((byte)0, this.test.getName(), 2, docs, contextSet, this.contextId);
    }

    protected DocumentSet getDocumentSet(NodeSet contextSet) {
        DocumentSet ds = this.getContextDocSet();
        if (ds == null) {
            ds = contextSet.getDocumentSet();
        }
        return ds;
    }

    public Expression getParentExpression() {
        return this.parent;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                @Override
                public void documentUpdated(DocumentImpl document, int event) {
                    LocationStep.this.cached = null;
                    if (document == null || event == 0 || event == 2) {
                        LocationStep.this.currentDocs = null;
                        LocationStep.this.currentSet = null;
                    } else if (LocationStep.this.currentDocs != null && LocationStep.this.currentDocs.contains(document.getDocId())) {
                        LocationStep.this.currentDocs = null;
                        LocationStep.this.currentSet = null;
                    }
                }

                @Override
                public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
                }

                @Override
                public void unsubscribe() {
                    LocationStep.this.listener = null;
                }

                @Override
                public void debug() {
                    Step.LOG.debug("UpdateListener: Line: " + LocationStep.this.toString() + "; id: " + LocationStep.this.getExpressionId());
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitLocationStep(this);
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.currentSet = null;
            this.currentDocs = null;
            this.optimized = false;
            this.cached = null;
            this.listener = null;
        }
    }

    @Override
    public Boolean match(Sequence contextSequence, Item contextItem) throws XPathException {
        Boolean result;
        block19: {
            block18: {
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().start(this);
                    this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
                    if (contextSequence != null) {
                        this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
                    }
                    if (contextItem != null) {
                        this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
                    }
                }
                if (!this.needsComputation()) break block18;
                if (contextSequence == null) {
                    throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context sequence for '" + this.toString() + "'");
                }
                switch (this.axis) {
                    case 7: 
                    case 8: {
                        result = null;
                        break block19;
                    }
                    case 5: {
                        if (this.test.getType() == 2) {
                            this.axis = 6;
                            result = this.matchAttributes(this.context, contextSequence);
                        } else {
                            result = this.matchChildren(this.context, contextItem.toSequence());
                        }
                        break block19;
                    }
                    case 0: 
                    case 1: {
                        result = null;
                        break block19;
                    }
                    case 2: {
                        result = null;
                        break block19;
                    }
                    case 12: {
                        result = this.matchSelf(this.context, contextItem.toSequence());
                        break block19;
                    }
                    case 6: 
                    case 13: {
                        result = null;
                        break block19;
                    }
                    case 3: {
                        result = null;
                        break block19;
                    }
                    case 9: {
                        result = null;
                        break block19;
                    }
                    case 4: 
                    case 10: {
                        result = null;
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported axis specified");
                    }
                }
            }
            result = null;
        }
        result = this.matchPredicate(contextSequence, (Node)((Object)contextItem), result);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", null);
        }
        return result;
    }

    private Boolean matchPredicate(Sequence contextSequence, Node contextItem, Boolean result) throws XPathException {
        if (result == null) {
            return false;
        }
        if (!result.booleanValue()) {
            return result;
        }
        if (contextSequence == null) {
            return false;
        }
        if (this.predicates.size() == 0) {
            return result;
        }
        for (Predicate pred : this.predicates) {
            pred.setContextDocSet(this.getContextDocSet());
            result = pred.matchPredicate(contextSequence, (Item)((Object)contextItem), this.axis);
            if (result.booleanValue()) continue;
            return false;
        }
        return result;
    }

    private Boolean matchSelf(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.matchSelf(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return !vset.isEmpty();
        }
        if (this.test.isWildcardTest()) {
            if (this.nodeTestType == null) {
                this.nodeTestType = this.test.getType();
            }
            if (Type.subTypeOf(this.nodeTestType, -1)) {
                if (-1 != this.contextId) {
                    if (contextSet instanceof VirtualNodeSet) {
                        ((VirtualNodeSet)contextSet).setInPredicate(true);
                        ((VirtualNodeSet)contextSet).setContextId(this.contextId);
                        ((VirtualNodeSet)contextSet).setSelfIsContext();
                    } else if (Type.subTypeOf(contextSet.getItemType(), -1)) {
                        for (NodeProxy p : contextSet) {
                            if (!this.test.matches(p)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return !vset.isEmpty();
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        SelfSelector selector = new SelfSelector(contextSet, this.contextId);
        return index.matchElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean matchChildren(XQueryContext context, Sequence contextSequence) throws XPathException {
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            return nodes.matchChildren(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.isWildcardTest() || this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return !vset.isEmpty();
        }
        if (this.useDirectChildSelect) {
            for (NodeProxy p : contextSet) {
                if (!p.directMatchChild(this.test.getName(), this.contextId)) continue;
                return true;
            }
            return false;
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext p = context;
            synchronized (p) {
                StructuralIndex index = context.getBroker().getStructuralIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                return index.matchElementsByTagName((byte)0, docs, this.test.getName(), null);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (contextSet instanceof ExtNodeSet && !contextSet.getProcessInReverseOrder()) {
            return index.matchDescendantsByTagName((byte)0, this.test.getName(), this.axis, docs, (ExtNodeSet)contextSet, this.contextId);
        }
        ChildSelector selector = new ChildSelector(contextSet, this.contextId);
        return index.matchElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected boolean matchAttributes(XQueryContext context, Sequence contextSequence) throws XPathException {
        NodeSelector selector;
        if (!contextSequence.isPersistentSet()) {
            MemoryNodeSet nodes = contextSequence.toMemNodeSet();
            if (this.axis == 13) {
                return nodes.matchDescendantAttributes(this.test);
            }
            return nodes.matchAttributes(this.test);
        }
        NodeSet contextSet = contextSequence.toNodeSet();
        if (this.test.isWildcardTest()) {
            VirtualNodeSet result = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            result.setInPredicate(-1 != this.contextId);
            return !result.isEmpty();
        }
        if (this.hasPreloadedData()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equalDocs(this.currentDocs)) {
                    StructuralIndex index = context.getBroker().getStructuralIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)1, docs, this.test.getName(), null, this);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 6: {
                        return this.currentSet.matchParentChild(contextSet, 1, this.contextId);
                    }
                    case 13: {
                        return this.currentSet.matchAncestorDescendant(contextSet, 1, false, this.contextId, true);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        StructuralIndex index = context.getBroker().getStructuralIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, 2, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (contextSet instanceof ExtNodeSet && !contextSet.getProcessInReverseOrder()) {
            return index.matchDescendantsByTagName((byte)1, this.test.getName(), this.axis, docs, (ExtNodeSet)contextSet, this.contextId);
        }
        switch (this.axis) {
            case 6: {
                selector = new ChildSelector(contextSet, this.contextId);
                break;
            }
            case 13: {
                selector = new DescendantSelector(contextSet, this.contextId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        return index.matchElementsByTagName((byte)1, docs, this.test.getName(), selector);
    }

    private static class PrecedingFilter
    implements StreamFilter {
        private NodeTest test;
        private NodeProxy referenceNode;
        private NodeSet result;
        private int contextId;

        private PrecedingFilter(NodeTest test, NodeProxy referenceNode, NodeSet result, int contextId) {
            this.test = test;
            this.referenceNode = referenceNode;
            this.result = result;
            this.contextId = contextId;
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (reader.getEventType() == 2) {
                return true;
            }
            NodeId refId = this.referenceNode.getNodeId();
            NodeId currentId = (NodeId)reader.getProperty("node-id");
            if (currentId.compareTo(refId) >= 0) {
                return false;
            }
            if (!refId.isDescendantOf(currentId) && this.test.matches(reader)) {
                NodeProxy proxy = new NodeProxy(this.referenceNode.getOwnerDocument(), currentId, StaXUtil.streamType2DOM(reader.getEventType()), ((EmbeddedXMLStreamReader)reader).getCurrentPosition());
                if (-2 != this.contextId) {
                    if (-1 == this.contextId) {
                        proxy.copyContext(this.referenceNode);
                    } else {
                        proxy.addContextNode(this.contextId, this.referenceNode);
                    }
                }
                this.result.add(proxy);
            }
            return true;
        }
    }

    private static class FollowingFilter
    implements StreamFilter {
        private NodeTest test;
        private NodeProxy referenceNode;
        private NodeSet result;
        private int contextId;
        private boolean isAfter = false;

        private FollowingFilter(NodeTest test, NodeProxy referenceNode, NodeSet result, int contextId) {
            this.test = test;
            this.referenceNode = referenceNode;
            this.result = result;
            this.contextId = contextId;
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (reader.getEventType() == 2) {
                return true;
            }
            NodeId refId = this.referenceNode.getNodeId();
            NodeId currentId = (NodeId)reader.getProperty("node-id");
            if (!this.isAfter) {
                boolean bl = this.isAfter = currentId.compareTo(refId) > 0 && !currentId.isDescendantOf(refId);
            }
            if (this.isAfter && !refId.isDescendantOf(currentId) && this.test.matches(reader)) {
                NodeProxy proxy = new NodeProxy(this.referenceNode.getOwnerDocument(), currentId, StaXUtil.streamType2DOM(reader.getEventType()), ((EmbeddedXMLStreamReader)reader).getCurrentPosition());
                if (-2 != this.contextId) {
                    if (-1 == this.contextId) {
                        proxy.copyContext(this.referenceNode);
                    } else {
                        proxy.addContextNode(this.contextId, this.referenceNode);
                    }
                }
                this.result.add(proxy);
            }
            return true;
        }
    }

    private static class PrecedingSiblingFilter
    implements StreamFilter {
        private NodeTest test;
        private NodeProxy referenceNode;
        private NodeSet result;
        private int contextId;

        private PrecedingSiblingFilter(NodeTest test, NodeProxy referenceNode, NodeSet result, int contextId) {
            this.test = test;
            this.referenceNode = referenceNode;
            this.result = result;
            this.contextId = contextId;
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (reader.getEventType() == 2) {
                return true;
            }
            NodeId refId = this.referenceNode.getNodeId();
            NodeId currentId = (NodeId)reader.getProperty("node-id");
            if (currentId.equals(refId)) {
                return false;
            }
            if (currentId.getTreeLevel() == refId.getTreeLevel() && this.test.matches(reader)) {
                NodeProxy sibling = this.result.get(this.referenceNode.getOwnerDocument(), currentId);
                if (sibling == null) {
                    sibling = new NodeProxy(this.referenceNode.getOwnerDocument(), currentId, StaXUtil.streamType2DOM(reader.getEventType()), ((EmbeddedXMLStreamReader)reader).getCurrentPosition());
                    if (-2 != this.contextId) {
                        if (-1 == this.contextId) {
                            sibling.copyContext(this.referenceNode);
                        } else {
                            sibling.addContextNode(this.contextId, this.referenceNode);
                        }
                    }
                    this.result.add(sibling);
                } else if (-1 != this.contextId) {
                    sibling.addContextNode(this.contextId, this.referenceNode);
                }
            }
            return true;
        }
    }

    private static class FollowingSiblingFilter
    implements StreamFilter {
        private NodeTest test;
        private NodeProxy referenceNode;
        private NodeSet result;
        private int contextId;
        private boolean isAfter = false;

        private FollowingSiblingFilter(NodeTest test, NodeProxy referenceNode, NodeSet result, int contextId) {
            this.test = test;
            this.referenceNode = referenceNode;
            this.result = result;
            this.contextId = contextId;
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (reader.getEventType() == 2) {
                return true;
            }
            NodeId refId = this.referenceNode.getNodeId();
            NodeId currentId = (NodeId)reader.getProperty("node-id");
            if (!this.isAfter) {
                this.isAfter = currentId.equals(refId);
            } else if (currentId.getTreeLevel() == refId.getTreeLevel() && this.test.matches(reader)) {
                NodeProxy sibling = this.result.get(this.referenceNode.getOwnerDocument(), currentId);
                if (sibling == null) {
                    sibling = new NodeProxy(this.referenceNode.getOwnerDocument(), currentId, StaXUtil.streamType2DOM(reader.getEventType()), ((EmbeddedXMLStreamReader)reader).getCurrentPosition());
                    if (-2 != this.contextId) {
                        if (-1 == this.contextId) {
                            sibling.copyContext(this.referenceNode);
                        } else {
                            sibling.addContextNode(this.contextId, this.referenceNode);
                        }
                    }
                    this.result.add(sibling);
                } else if (-1 != this.contextId) {
                    sibling.addContextNode(this.contextId, this.referenceNode);
                }
            }
            return true;
        }
    }
}

