/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Map;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Lookup
extends AbstractExpression {
    private Expression contextExpression;
    private Sequence keys = null;
    private Expression keyExpression = null;

    public Lookup(XQueryContext context, Expression ctxExpr) {
        super(context);
        this.contextExpression = ctxExpr;
    }

    public Lookup(XQueryContext context, Expression ctxExpr, String keyString) {
        this(context, ctxExpr);
        this.keys = new StringValue(keyString);
    }

    public Lookup(XQueryContext context, Expression ctxExpr, int position) {
        this(context, ctxExpr);
        this.keys = new IntegerValue(position);
    }

    public Lookup(XQueryContext context, Expression ctxExpr, Expression keyExpression) {
        this(context, ctxExpr);
        this.keyExpression = keyExpression;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo contextCopy = new AnalyzeContextInfo(contextInfo);
        if (this.contextExpression != null) {
            this.contextExpression.analyze(contextCopy);
        }
        if (this.keyExpression != null) {
            this.keyExpression.analyze(contextCopy);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence leftSeq = this.contextExpression == null ? contextSequence : this.contextExpression.eval(contextSequence);
        int contextType = leftSeq.getItemType();
        if (leftSeq.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!Type.subTypeOf(contextType, 102) && !Type.subTypeOf(contextType, 103)) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "expression to the left of a lookup operator needs to be a sequence of maps or arrays");
        }
        if (this.keyExpression != null) {
            this.keys = this.keyExpression.eval(contextSequence);
            if (this.keys.isEmpty()) {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        try {
            ValueSequence result = new ValueSequence();
            SequenceIterator i = leftSeq.iterate();
            while (i.hasNext()) {
                LookupSupport item = (LookupSupport)((Object)i.nextItem());
                if (this.keys != null) {
                    SequenceIterator j = this.keys.iterate();
                    while (j.hasNext()) {
                        AtomicValue key = j.nextItem().atomize();
                        Sequence value = item.get(key);
                        if (value == null) continue;
                        result.addAll(value);
                    }
                    continue;
                }
                if (item instanceof ArrayType) {
                    result.addAll(item.keys());
                    continue;
                }
                if (!(item instanceof AbstractMapType)) continue;
                for (Map.Entry entry : (AbstractMapType)item) {
                    result.addAll((Sequence)entry.getValue());
                }
            }
            return result;
        }
        catch (XPathException e) {
            e.setLocation(this.getLine(), this.getColumn(), this.getSource());
            throw e;
        }
    }

    @Override
    public int returnsType() {
        return 11;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.contextExpression != null) {
            this.contextExpression.dump(dumper);
        }
        dumper.display("?");
        if (this.keyExpression == null && this.keys != null && this.keys.getItemCount() > 0) {
            try {
                dumper.display(this.keys.itemAt(0).getStringValue());
            }
            catch (XPathException xPathException) {}
        } else if (this.keyExpression != null) {
            this.keyExpression.dump(dumper);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.contextExpression != null) {
            this.contextExpression.resetState(postOptimization);
        }
        if (this.keyExpression != null) {
            this.keyExpression.resetState(postOptimization);
        }
    }

    public static interface LookupSupport {
        public Sequence get(AtomicValue var1) throws XPathException;

        public Sequence keys() throws XPathException;
    }
}

