/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import javax.xml.stream.XMLStreamReader;
import org.exist.dom.QName;
import org.exist.dom.memtree.ReferenceNode;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.TypeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.ExpressionDumper;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NameTest
extends TypeTest {
    protected final QName nodeName;

    public NameTest(int type, QName name) throws XPathException {
        super(type);
        if (name.isValid(true) != QName.Validity.VALID.val) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + name.getStringValue());
        }
        this.nodeName = name;
    }

    @Override
    public QName getName() {
        return this.nodeName;
    }

    @Override
    public boolean matches(NodeProxy proxy) {
        Node node = null;
        short type = proxy.getNodeType();
        if (proxy.getType() == 11) {
            node = proxy.getNode();
            type = node.getNodeType();
        }
        if (!this.isOfType(type)) {
            return false;
        }
        if (node == null) {
            node = proxy.getNode();
        }
        return this.matchesName(node);
    }

    @Override
    public boolean matches(Node other) {
        if (other.getNodeType() == 100) {
            return this.matches(((ReferenceNode)other).getReference());
        }
        if (!this.isOfType(other.getNodeType())) {
            return false;
        }
        return this.matchesName(other);
    }

    @Override
    public boolean matches(QName name) {
        return this.nodeName.matches(name);
    }

    public boolean matchesName(Node other) {
        if (other.getNodeType() == 100) {
            return this.matchesName(((ReferenceNode)other).getReference().getNode());
        }
        if (this.nodeName == QName.WildcardQName.getInstance()) {
            return true;
        }
        if (!(this.nodeName instanceof QName.WildcardNamespaceURIQName)) {
            String otherNs = other.getNamespaceURI();
            if (otherNs == null) {
                otherNs = "";
            }
            if (!this.nodeName.getNamespaceURI().equals(otherNs)) {
                return false;
            }
        }
        if (!(this.nodeName instanceof QName.WildcardLocalPartQName)) {
            if (other.getNodeType() == 7) {
                return this.nodeName.getLocalPart().equals(((ProcessingInstruction)other).getTarget());
            }
            return this.nodeName.getLocalPart().equals(other.getLocalName());
        }
        return true;
    }

    @Override
    public boolean matches(XMLStreamReader reader) {
        int ev = reader.getEventType();
        if (!this.isOfEventType(ev)) {
            return false;
        }
        if (this.nodeName == QName.WildcardQName.getInstance()) {
            return true;
        }
        switch (ev) {
            case 1: {
                if (!(this.nodeName instanceof QName.WildcardNamespaceURIQName)) {
                    String readerNs = reader.getNamespaceURI();
                    if (readerNs == null) {
                        readerNs = "";
                    }
                    if (!this.nodeName.getNamespaceURI().equals(readerNs)) {
                        return false;
                    }
                }
                if (this.nodeName instanceof QName.WildcardLocalPartQName) break;
                return this.nodeName.getLocalPart().equals(reader.getLocalName());
            }
            case 3: {
                if (this.nodeName instanceof QName.WildcardLocalPartQName) break;
                return this.nodeName.getLocalPart().equals(reader.getPITarget());
            }
        }
        return true;
    }

    @Override
    public boolean isWildcardTest() {
        return this.nodeName instanceof QName.PartialQName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NameTest) {
            NameTest other = (NameTest)obj;
            return other.nodeType == this.nodeType && other.nodeName.equals(this.nodeName);
        }
        return false;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display(this.nodeName.getStringValue());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.nodeName.getPrefix() != null) {
            result.append(this.nodeName.getPrefix());
            result.append(":");
        } else if (!(this.nodeName instanceof QName.WildcardNamespaceURIQName)) {
            result.append("{");
            result.append(this.nodeName.getNamespaceURI());
            result.append("}");
        }
        result.append(this.nodeName.getLocalPart());
        return result.toString();
    }
}

