/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CastExpression;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionFactory;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class NamedFunctionReference
extends AbstractExpression {
    private QName qname;
    private int arity;
    private FunctionCall resolvedFunction = null;

    public NamedFunctionReference(XQueryContext context, QName qname, int arity) {
        super(context);
        this.qname = qname;
        this.arity = arity;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.resolvedFunction = NamedFunctionReference.lookupFunction(this, this.context, this.qname, this.arity);
        contextInfo.addFlag(1);
        this.resolvedFunction.analyze(contextInfo);
    }

    public static FunctionCall lookupFunction(Expression self, XQueryContext context, QName funcName, int arity) throws XPathException {
        XQueryAST ast = new XQueryAST();
        ast.setLine(self.getLine());
        ast.setColumn(self.getColumn());
        ArrayList<Expression> args = new ArrayList<Expression>(arity);
        for (int i = 0; i < arity; ++i) {
            args.add(new Function.Placeholder(context));
        }
        Expression fun = FunctionFactory.createFunction(context, funcName, ast, null, args, false);
        if (fun == null) {
            throw new XPathException(self, ErrorCodes.XPST0017, "Function not found: " + funcName);
        }
        if (fun instanceof FunctionCall) {
            if (((FunctionCall)fun).getFunction() == null) {
                throw new XPathException(self, ErrorCodes.XPST0017, "Function not found: " + funcName);
            }
            fun.setLocation(-1, -1);
            return (FunctionCall)fun;
        }
        if (fun instanceof Function) {
            InternalFunctionCall funcCall = fun instanceof InternalFunctionCall ? (InternalFunctionCall)fun : new InternalFunctionCall((Function)fun);
            funcCall.setLocation(-1, -1);
            return FunctionFactory.wrap(context, funcCall);
        }
        if (fun instanceof CastExpression) {
            InternalFunctionCall funcCall = new InternalFunctionCall(((CastExpression)fun).toFunction());
            funcCall.setLocation(-1, -1);
            return FunctionFactory.wrap(context, funcCall);
        }
        throw new XPathException(self, ErrorCodes.XPST0017, "Named function reference should point to a function; found: " + fun.getClass().getName());
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display(this.qname);
        dumper.display('#');
        dumper.display(Integer.toString(this.arity));
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        return new FunctionReference(this.resolvedFunction);
    }

    @Override
    public int returnsType() {
        return 101;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.resolvedFunction != null) {
            this.resolvedFunction.resetState(postOptimization);
        }
    }
}

