/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class NamespaceConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private Expression content = null;

    public NamespaceConstructor(XQueryContext context) {
        super(context);
    }

    public void setContentExpr(PathExpr path) {
        path.setUseStaticContext(true);
        DynamicCardinalityCheck expr = new DynamicCardinalityCheck(this.context, 2, path, new Error("D02"));
        this.content = expr;
    }

    public void setNameExpr(Expression expr) {
        expr = new Atomize(this.context, expr);
        this.qnameExpr = expr = new DynamicCardinalityCheck(this.context, 3, expr, new Error("D02"));
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setParent(this);
        newContextInfo.addFlag(256);
        this.qnameExpr.analyze(newContextInfo);
        if (this.content != null) {
            this.content.analyze(newContextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence prefixSeq = this.qnameExpr.eval(contextSequence, contextItem);
        if (!Type.subTypeOf(prefixSeq.getItemType(), 22) && prefixSeq.getItemType() != 21) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Prefix needs to be xs:string or xs:untypedAtomic");
        }
        String prefix = "";
        if (!prefixSeq.isEmpty() && (prefix = prefixSeq.getStringValue()).length() != 0 && !XMLChar.isValidNCName(prefix)) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0074, "Prefix cannot be cast to xs:NCName");
        }
        Sequence uriSeq = this.content.eval(contextSequence, contextItem);
        String value = uriSeq.getStringValue();
        if (prefix.equals("xmlns")) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0101, "Cannot bind xmlns prefix");
        }
        if (prefix.equals("xml") && !value.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0101, "Cannot bind xml prefix to another namespace");
        }
        if (value.equals("http://www.w3.org/XML/1998/namespace") && !prefix.equals("xml")) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0101, "Cannot bind prefix to XML namespace");
        }
        if (value.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0101, "Cannot bind prefix to xmlns namespace");
        }
        if (value.length() == 0) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0101, "Cannot bind prefix to empty or zero-length namespace");
        }
        int nodeNr = builder.namespaceNode(prefix, value);
        NodeImpl result = builder.getDocument().getNamespaceNode(nodeNr);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("namespace ");
        dumper.display("{");
        this.qnameExpr.dump(dumper);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        if (this.content != null) {
            this.content.dump(dumper);
        }
        dumper.endIndent().nl();
        dumper.display("} ");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("namespace ");
        result.append("{");
        result.append(this.qnameExpr.toString());
        result.append("} ");
        result.append("{");
        if (this.content != null) {
            result.append(this.content.toString());
        }
        result.append("} ");
        return result.toString();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.qnameExpr.resetState(postOptimization);
        if (this.content != null) {
            this.content.resetState(postOptimization);
        }
    }
}

