/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class OpAnd
extends LogicalOp {
    public OpAnd(XQueryContext context) {
        super(context);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getLength() == 0) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (contextItem != null) {
                contextSequence = contextItem.toSequence();
            }
            boolean doOptimize = this.optimize;
            if (contextSequence != null && !contextSequence.isPersistentSet()) {
                doOptimize = false;
            }
            Expression left = this.getLeft();
            Expression right = this.getRight();
            if (doOptimize && contextSequence != null) {
                contextSequence.setSelfAsContext(this.getContextId());
            }
            Sequence ls = left.eval(contextSequence, null);
            boolean bl = doOptimize = doOptimize && (ls.isPersistentSet() || ls.isEmpty());
            if (doOptimize) {
                if (this.inPredicate) {
                    NodeSet lr = ls.toNodeSet();
                    if ((lr = lr.getContextNodes(this.getContextId())).isEmpty()) {
                        return NodeSet.EMPTY_SET;
                    }
                    Sequence rs = right.eval(lr, null);
                    NodeSet rr = rs.toNodeSet();
                    result = rr.getContextNodes(this.getContextId());
                } else {
                    Sequence rs = right.eval(contextSequence, null);
                    boolean rl = ls.effectiveBooleanValue();
                    if (!rl) {
                        result = BooleanValue.FALSE;
                    } else {
                        boolean rr = rs.effectiveBooleanValue();
                        result = rl && rr ? BooleanValue.TRUE : BooleanValue.FALSE;
                    }
                }
            } else {
                boolean rl = ls.effectiveBooleanValue();
                if (!rl) {
                    result = BooleanValue.FALSE;
                } else {
                    Sequence rs = right.eval(contextSequence, null);
                    boolean rr = rs.effectiveBooleanValue();
                    Sequence sequence = result = rl && rr ? BooleanValue.TRUE : BooleanValue.FALSE;
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitAndExpr(this);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.getLength() == 0) {
            return;
        }
        this.getExpression(0).dump(dumper);
        for (int i = 1; i < this.getLength(); ++i) {
            dumper.display(") and (");
            this.getExpression(i).dump(dumper);
        }
    }

    @Override
    public String toString() {
        if (this.getLength() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder("(");
        result.append(this.getExpression(0).toString());
        for (int i = 1; i < this.getLength(); ++i) {
            result.append(") and (");
            result.append(this.getExpression(i).toString());
        }
        result.append(")");
        return result.toString();
    }
}

