/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Map;
import java.util.TreeMap;
import org.exist.dom.persistent.NodeSet;
import org.exist.storage.DBBroker;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class OpNumeric
extends BinaryOp {
    protected final Constants.ArithmeticOperator operator;
    protected int returnType = 20;
    protected NodeSet temp = null;
    protected DBBroker broker;
    private static final OpEntry[] OP_TABLE = new OpEntry[]{new OpEntry(Constants.ArithmeticOperator.ADDITION, 30, 30, 30), new OpEntry(Constants.ArithmeticOperator.ADDITION, 51, 54, 51), new OpEntry(Constants.ArithmeticOperator.ADDITION, 54, 51, 51), new OpEntry(Constants.ArithmeticOperator.ADDITION, 51, 55, 51), new OpEntry(Constants.ArithmeticOperator.ADDITION, 55, 51, 51), new OpEntry(Constants.ArithmeticOperator.ADDITION, 52, 55, 52), new OpEntry(Constants.ArithmeticOperator.ADDITION, 55, 52, 52), new OpEntry(Constants.ArithmeticOperator.ADDITION, 50, 54, 50), new OpEntry(Constants.ArithmeticOperator.ADDITION, 54, 50, 50), new OpEntry(Constants.ArithmeticOperator.ADDITION, 50, 55, 50), new OpEntry(Constants.ArithmeticOperator.ADDITION, 55, 50, 50), new OpEntry(Constants.ArithmeticOperator.ADDITION, 54, 54, 54), new OpEntry(Constants.ArithmeticOperator.ADDITION, 55, 55, 55), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 30, 30, 30), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 51, 51, 55), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 51, 54, 51), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 51, 55, 51), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 52, 52, 55), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 52, 55, 52), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 50, 50, 55), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 50, 54, 50), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 50, 55, 50), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 54, 54, 54), new OpEntry(Constants.ArithmeticOperator.SUBTRACTION, 55, 55, 55), new OpEntry(Constants.ArithmeticOperator.MULTIPLICATION, 30, 30, 30), new OpEntry(Constants.ArithmeticOperator.MULTIPLICATION, 54, 30, 54), new OpEntry(Constants.ArithmeticOperator.MULTIPLICATION, 30, 54, 54), new OpEntry(Constants.ArithmeticOperator.MULTIPLICATION, 55, 30, 55), new OpEntry(Constants.ArithmeticOperator.MULTIPLICATION, 30, 55, 55), new OpEntry(Constants.ArithmeticOperator.DIVISION_INTEGER, 30, 30, 31), new OpEntry(Constants.ArithmeticOperator.DIVISION, 30, 30, 30), new OpEntry(Constants.ArithmeticOperator.DIVISION, 54, 30, 54), new OpEntry(Constants.ArithmeticOperator.DIVISION, 55, 30, 55), new OpEntry(Constants.ArithmeticOperator.DIVISION, 54, 54, 32), new OpEntry(Constants.ArithmeticOperator.DIVISION, 55, 55, 32), new OpEntry(Constants.ArithmeticOperator.MODULUS, 30, 30, 30)};
    private static final Map<OpEntry, OpEntry> OP_TYPES = new TreeMap<OpEntry, OpEntry>();

    public OpNumeric(XQueryContext context, Constants.ArithmeticOperator operator) {
        super(context);
        this.operator = operator;
    }

    public OpNumeric(XQueryContext context, Expression left, Expression right, Constants.ArithmeticOperator operator) {
        super(context);
        this.operator = operator;
        int ltype = left.returnsType();
        int rtype = right.returnsType();
        if (Type.subTypeOf(ltype, 30) && Type.subTypeOf(rtype, 30)) {
            if (ltype > rtype) {
                right = new UntypedValueCheck(context, ltype, right);
            } else if (rtype > ltype) {
                left = new UntypedValueCheck(context, rtype, left);
            }
            this.returnType = operator == Constants.ArithmeticOperator.DIVISION && ltype == 31 && rtype == 31 ? 32 : (operator == Constants.ArithmeticOperator.DIVISION_INTEGER ? 31 : Math.max(ltype, rtype));
        } else {
            OpEntry entry;
            if (Type.subTypeOf(ltype, 30)) {
                ltype = 30;
            }
            if (Type.subTypeOf(rtype, 30)) {
                rtype = 30;
            }
            if ((entry = OP_TYPES.get(new OpEntry(operator, ltype, rtype))) != null) {
                this.returnType = entry.typeResult;
            } else if (ltype == 30 || rtype == 30) {
                this.returnType = 30;
            }
        }
        this.add(left);
        this.add(right);
    }

    @Override
    public int getDependencies() {
        return this.getLeft().getDependencies() | this.getRight().getDependencies();
    }

    @Override
    public int returnsType() {
        return this.returnType;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setStaticReturnType(this.returnType);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence lseq = Atomize.atomize(this.getLeft().eval(contextSequence, contextItem));
        Sequence rseq = Atomize.atomize(this.getRight().eval(contextSequence, contextItem));
        if (lseq.hasMany()) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Too many operands at the left of " + this.operator.symbol);
        }
        if (rseq.hasMany()) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Too many operands at the right of " + this.operator.symbol);
        }
        if (rseq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else if (lseq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item lvalue = lseq.itemAt(0);
            Item rvalue = rseq.itemAt(0);
            try {
                if (lvalue.getType() == 21 || lvalue.getType() == 20) {
                    lvalue = lvalue.convertTo(30);
                }
                if (rvalue.getType() == 21 || rvalue.getType() == 20) {
                    rvalue = rvalue.convertTo(30);
                }
                if (!(lvalue instanceof ComputableValue)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")' can not be an operand for " + this.operator.symbol);
                }
                if (!(rvalue instanceof ComputableValue)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")' can not be an operand for " + this.operator.symbol);
                }
                if (this.operator == Constants.ArithmeticOperator.DIVISION_INTEGER) {
                    if (!Type.subTypeOf(lvalue.getType(), 30)) {
                        throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")' can not be an operand for " + this.operator.symbol);
                    }
                    if (!Type.subTypeOf(rvalue.getType(), 30)) {
                        throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")' can not be an operand for " + this.operator.symbol);
                    }
                    if (((NumericValue)rvalue).isZero()) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAR0001, "Division by zero");
                    }
                    if (((NumericValue)lvalue).isNaN()) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAR0002, "Division of " + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")'");
                    }
                    if (((NumericValue)rvalue).isNaN()) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAR0002, "Division of " + Type.getTypeName(rvalue.getType()) + "(" + rvalue + ")'");
                    }
                    if (((NumericValue)lvalue).isInfinite()) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAR0002, "Division of " + Type.getTypeName(lvalue.getType()) + "(" + lvalue + ")'");
                    }
                    result = ((NumericValue)lvalue).idiv((NumericValue)rvalue);
                } else {
                    result = this.applyOperator((ComputableValue)lvalue, (ComputableValue)rvalue);
                }
            }
            catch (XPathException e) {
                e.setLocation(this.line, this.column);
                throw e;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        if (this.returnType == 20) {
            this.returnType = result.getItemType();
        }
        return result;
    }

    public ComputableValue applyOperator(ComputableValue left, ComputableValue right) throws XPathException {
        switch (this.operator) {
            case SUBTRACTION: {
                return left.minus(right);
            }
            case ADDITION: {
                return left.plus(right);
            }
            case MULTIPLICATION: {
                return left.mult(right);
            }
            case DIVISION: {
                return left.div(right);
            }
            case MODULUS: {
                if (!Type.subTypeOf(left.getType(), 30)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(left.getType()) + "(" + left + ")' is not numeric");
                }
                if (!Type.subTypeOf(right.getType(), 30)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + Type.getTypeName(right.getType()) + "(" + right + ")' is not numeric");
                }
                return ((NumericValue)left).mod((NumericValue)right);
            }
        }
        throw new RuntimeException("Unknown numeric operator " + (Object)((Object)this.operator));
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.getLeft().dump(dumper);
        dumper.display(' ').display(this.operator.symbol).display(' ');
        this.getRight().dump(dumper);
    }

    @Override
    public String toString() {
        return this.getLeft().toString() + ' ' + this.operator.symbol + ' ' + this.getRight();
    }

    static {
        for (OpEntry entry : OP_TABLE) {
            OP_TYPES.put(entry, entry);
        }
    }

    private static class OpEntry
    implements Comparable<OpEntry> {
        public final Constants.ArithmeticOperator op;
        public final int typeA;
        public final int typeB;
        public final int typeResult;

        public OpEntry(Constants.ArithmeticOperator op, int typeA, int typeB) {
            this(op, typeA, typeB, 20);
        }

        public OpEntry(Constants.ArithmeticOperator op, int typeA, int typeB, int typeResult) {
            this.op = op;
            this.typeA = typeA;
            this.typeB = typeB;
            this.typeResult = typeResult;
        }

        @Override
        public int compareTo(OpEntry that) {
            if (this.op != that.op) {
                return this.op.ordinal() - that.op.ordinal();
            }
            if (this.typeA != that.typeA) {
                return this.typeA - that.typeA;
            }
            if (this.typeB != that.typeB) {
                return this.typeB - that.typeB;
            }
            return 0;
        }

        public boolean equals(Object o) {
            try {
                OpEntry that = (OpEntry)o;
                return this.op == that.op && this.typeA == that.typeA && this.typeB == that.typeB;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

