/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class OpOr
extends LogicalOp {
    public OpOr(XQueryContext context) {
        super(context);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        boolean doOptimize = this.optimize;
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            doOptimize = false;
        }
        Expression left = this.getLeft();
        Expression right = this.getRight();
        Sequence ls = left.eval(contextSequence, null);
        boolean bl = doOptimize = doOptimize && (ls.isPersistentSet() || ls.isEmpty());
        if (doOptimize) {
            Sequence rs = right.eval(contextSequence, null);
            if (this.inPredicate) {
                NodeSet lr = ls.toNodeSet();
                lr = lr.getContextNodes(this.getContextId());
                NodeSet rr = rs.toNodeSet();
                rr = rr.getContextNodes(this.contextId);
                result = lr.union(rr);
            } else {
                boolean rl = ls.effectiveBooleanValue();
                if (rl) {
                    result = BooleanValue.TRUE;
                } else {
                    boolean rr = rs.effectiveBooleanValue();
                    result = rl || rr ? BooleanValue.TRUE : BooleanValue.FALSE;
                }
            }
        } else {
            boolean rl = ls.effectiveBooleanValue();
            if (rl) {
                result = BooleanValue.TRUE;
            } else {
                Sequence rs = right.eval(contextSequence, null);
                boolean rr = rs.effectiveBooleanValue();
                BooleanValue booleanValue = result = rl || rr ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitOrExpr(this);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.getLength() == 0) {
            return;
        }
        dumper.display("(");
        this.getExpression(0).dump(dumper);
        for (int i = 1; i < this.getLength(); ++i) {
            dumper.display(") or (");
            this.getExpression(i).dump(dumper);
        }
        dumper.display(")");
    }

    @Override
    public String toString() {
        if (this.getLength() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder("(");
        result.append(this.getExpression(0).toString());
        for (int i = 1; i < this.getLength(); ++i) {
            result.append(") or (");
            result.append(this.getExpression(i).toString());
        }
        result.append(")");
        return result.toString();
    }
}

