/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.Atomize;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.CastExpression;
import org.exist.xquery.ConcatExpr;
import org.exist.xquery.ConditionalExpression;
import org.exist.xquery.DefaultExpressionVisitor;
import org.exist.xquery.DocumentConstructor;
import org.exist.xquery.DynamicAttributeConstructor;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicNameCheck;
import org.exist.xquery.DynamicTextConstructor;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.ElementConstructor;
import org.exist.xquery.Expression;
import org.exist.xquery.ExtensionExpression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FilteredExpression;
import org.exist.xquery.ForExpr;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.GroupByClause;
import org.exist.xquery.Intersect;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.LocationStep;
import org.exist.xquery.Module;
import org.exist.xquery.OpAnd;
import org.exist.xquery.OpNumeric;
import org.exist.xquery.OpOr;
import org.exist.xquery.Optimizable;
import org.exist.xquery.OrderByClause;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.Predicate;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.SequenceConstructor;
import org.exist.xquery.Step;
import org.exist.xquery.TryCatchExpression;
import org.exist.xquery.Union;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.VariableReference;
import org.exist.xquery.WhereClause;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayConstructor;
import org.exist.xquery.pragmas.Optimize;
import org.exist.xquery.util.ExpressionDumper;

public class Optimizer
extends DefaultExpressionVisitor {
    private static final Logger LOG = LogManager.getLogger(Optimizer.class);
    private XQueryContext context;
    private int predicates = 0;
    private boolean hasOptimized = false;
    private List<QueryRewriter> rewriters = new ArrayList<QueryRewriter>(5);

    public Optimizer(XQueryContext context) {
        this.context = context;
        this.rewriters = context.getBroker().getIndexController().getQueryRewriters(context);
    }

    public boolean hasOptimized() {
        return this.hasOptimized;
    }

    @Override
    public void visitLocationStep(LocationStep locationStep) {
        super.visitLocationStep(locationStep);
        Pragma optimizePragma = null;
        for (QueryRewriter rewriter : this.rewriters) {
            try {
                optimizePragma = rewriter.rewriteLocationStep(locationStep);
                if (optimizePragma == null) continue;
                this.hasOptimized = true;
                break;
            }
            catch (XPathException e) {
                LOG.warn("Exception called while rewriting location step: " + e.getMessage(), (Throwable)e);
            }
        }
        boolean optimize = false;
        if (locationStep.hasPredicates()) {
            List<Predicate> preds = locationStep.getPredicates();
            for (Predicate pred : preds) {
                FindOptimizable find = new FindOptimizable();
                pred.accept(find);
                List<Optimizable> list = find.getOptimizables();
                if (list.size() <= 0 || !this.canOptimize(list)) continue;
                optimize = true;
                break;
            }
        }
        Expression parent = locationStep.getParentExpression();
        if (optimize) {
            if (!(parent instanceof RewritableExpression)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Parent expression of step is not a PathExpr: " + parent);
                }
                return;
            }
            this.hasOptimized = true;
            RewritableExpression path = (RewritableExpression)((Object)parent);
            try {
                ExtensionExpression extension = new ExtensionExpression(this.context);
                if (optimizePragma != null) {
                    extension.addPragma(optimizePragma);
                }
                extension.addPragma(new Optimize(this.context, Optimize.OPTIMIZE_PRAGMA, null, false));
                extension.setExpression(locationStep);
                path.replace(locationStep, extension);
                int reverseAxis = this.reverseAxis(locationStep.getAxis());
                Expression previous = path.getPrevious(extension);
                if (previous != null && reverseAxis != -1) {
                    Step prevStep;
                    ArrayList<Step> prevSteps = new ArrayList<Step>();
                    while (previous != null && previous != path.getFirst() && previous instanceof Step && ((prevStep = (Step)previous).getAxis() != 5 || path.getPrevious(prevStep) instanceof LocationStep) && (reverseAxis = this.reverseAxis(prevStep.getAxis())) != -1 && !prevStep.hasPredicates() && !prevStep.getTest().isWildcardTest()) {
                        prevSteps.add(prevStep);
                        previous = path.getPrevious(prevStep);
                        path.remove(prevStep);
                    }
                    if (prevSteps.size() > 0) {
                        reverseAxis = this.reverseAxis(locationStep.getAxis());
                        Predicate predicate = new Predicate(this.context);
                        for (Step expr : prevSteps) {
                            int axis = expr.getAxis();
                            expr.setAxis(reverseAxis);
                            reverseAxis = this.reverseAxis(axis);
                            predicate.add(expr);
                        }
                        locationStep.setAxis(7);
                        locationStep.addPredicate(predicate);
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rewritten expression: " + ExpressionDumper.dump(parent));
                }
            }
            catch (XPathException e) {
                LOG.warn("Failed to optimize expression: " + locationStep + ": " + e.getMessage(), (Throwable)e);
            }
        } else if (optimizePragma != null) {
            ExtensionExpression extension = new ExtensionExpression(this.context);
            extension.addPragma(optimizePragma);
            extension.setExpression(locationStep);
            RewritableExpression path = (RewritableExpression)((Object)parent);
            path.replace(locationStep, extension);
        }
    }

    @Override
    public void visitFilteredExpr(FilteredExpression filtered) {
        List<Predicate> preds;
        boolean optimize;
        super.visitFilteredExpr(filtered);
        if (filtered.getExpression() instanceof LocationStep) {
            List<Predicate> preds2;
            boolean optimizable;
            LocationStep step = (LocationStep)filtered.getExpression();
            Expression parent = filtered.getParent();
            if (parent instanceof RewritableExpression && (optimizable = this.hasOptimizable(preds2 = filtered.getPredicates()))) {
                for (Predicate pred : preds2) {
                    step.addPredicate(pred);
                }
                ((RewritableExpression)((Object)parent)).replace(filtered, step);
                step.setParent(parent);
                this.visitLocationStep(step);
                return;
            }
        }
        if (optimize = this.hasOptimizable(preds = filtered.getPredicates())) {
            Expression parent = filtered.getParent();
            if (!(parent instanceof RewritableExpression)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Parent expression: " + parent.getClass().getName() + " of step does not implement RewritableExpression");
                }
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rewriting expression: " + ExpressionDumper.dump(filtered));
            }
            this.hasOptimized = true;
            RewritableExpression path = (RewritableExpression)((Object)parent);
            try {
                ExtensionExpression extension = new ExtensionExpression(this.context);
                extension.addPragma(new Optimize(this.context, Optimize.OPTIMIZE_PRAGMA, null, false));
                extension.setExpression(filtered);
                path.replace(filtered, extension);
            }
            catch (XPathException e) {
                LOG.warn("Failed to optimize expression: " + filtered + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean hasOptimizable(List<Predicate> preds) {
        for (Predicate pred : preds) {
            FindOptimizable find = new FindOptimizable();
            pred.accept(find);
            List<Optimizable> list = find.getOptimizables();
            if (list.size() <= 0 || !this.canOptimize(list)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitAndExpr(OpAnd and) {
        if (this.predicates > 0) {
            PathExpr path;
            Predicate predicate;
            Expression parent = and.getParent();
            if (!(parent instanceof PathExpr)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Parent expression of boolean operator is not a PathExpr: " + parent);
                }
                return;
            }
            if (parent instanceof Predicate) {
                predicate = (Predicate)parent;
                path = predicate;
            } else {
                path = (PathExpr)parent;
                if (!((parent = path.getParent()) instanceof Predicate) || path.getLength() > 1) {
                    LOG.debug("Boolean operator is not a top-level expression in the predicate: " + (parent == null ? "?" : parent.getClass().getName()));
                    return;
                }
                predicate = (Predicate)parent;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rewriting boolean expression: " + ExpressionDumper.dump(and));
            }
            this.hasOptimized = true;
            LocationStep step = (LocationStep)predicate.getParent();
            Predicate newPred = new Predicate(this.context);
            newPred.add(this.simplifyPath(and.getRight()));
            step.insertPredicate(predicate, newPred);
            path.replace(and, this.simplifyPath(and.getLeft()));
        } else if (and.isRewritable()) {
            and.getLeft().accept(this);
            and.getRight().accept(this);
        }
    }

    @Override
    public void visitOrExpr(OpOr or) {
        if (or.isRewritable()) {
            or.getLeft().accept(this);
            or.getRight().accept(this);
        }
    }

    @Override
    public void visitGeneralComparison(GeneralComparison comparison) {
        comparison.getLeft().accept(this);
        comparison.getRight().accept(this);
    }

    @Override
    public void visitPredicate(Predicate predicate) {
        ++this.predicates;
        super.visitPredicate(predicate);
        --this.predicates;
    }

    @Override
    public void visitVariableReference(VariableReference ref) {
        Module module;
        String ns = ref.getName().getNamespaceURI();
        if (ns != null && ns.length() > 0 && (module = this.context.getModule(ns)) != null && !module.isInternalModule()) {
            Collection<VariableDeclaration> vars = ((ExternalModule)module).getVariableDeclarations();
            for (VariableDeclaration var : vars) {
                Expression parent;
                if (!var.getName().equals(ref.getName()) || !var.getExpression().isPresent()) continue;
                var.getExpression().get().accept(this);
                Expression expression = this.simplifyPath(var.getExpression().get());
                InlineableVisitor visitor = new InlineableVisitor();
                expression.accept(visitor);
                if (!visitor.isInlineable() || !((parent = ref.getParent()) instanceof RewritableExpression)) continue;
                ((RewritableExpression)((Object)parent)).replace(ref, expression);
            }
        }
    }

    private boolean canOptimize(List<Optimizable> list) {
        for (Optimizable optimizable : list) {
            int axis = optimizable.getOptimizeAxis();
            if (axis == 5 || axis == 7 || axis == 8 || axis == 6 || axis == 13 || axis == 12) continue;
            return false;
        }
        return true;
    }

    private int reverseAxis(int axis) {
        switch (axis) {
            case 5: {
                return 2;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
        }
        return -1;
    }

    private Expression simplifyPath(Expression expression) {
        if (!(expression instanceof PathExpr)) {
            return expression;
        }
        PathExpr path = (PathExpr)expression;
        if (path.getLength() != 1) {
            return path;
        }
        return path.getExpression(0);
    }

    static class InlineableVisitor
    extends DefaultExpressionVisitor {
        private boolean inlineable = true;

        InlineableVisitor() {
        }

        public boolean isInlineable() {
            return this.inlineable;
        }

        @Override
        public void visit(Expression expr) {
            if (expr instanceof LiteralValue) {
                return;
            }
            if (expr instanceof Atomize || expr instanceof DynamicCardinalityCheck || expr instanceof DynamicNameCheck || expr instanceof DynamicTypeCheck || expr instanceof UntypedValueCheck || expr instanceof ConcatExpr || expr instanceof ArrayConstructor) {
                expr.accept(this);
            } else {
                this.inlineable = false;
            }
        }

        @Override
        public void visitPathExpr(PathExpr expr) {
            if (expr instanceof OpNumeric || expr instanceof SequenceConstructor || expr.getLength() == 1) {
                super.visitPathExpr(expr);
            } else {
                this.inlineable = false;
            }
        }

        @Override
        public void visitUserFunction(UserDefinedFunction function) {
            this.inlineable = false;
        }

        @Override
        public void visitBuiltinFunction(Function function) {
            this.inlineable = false;
        }

        @Override
        public void visitFunctionCall(FunctionCall call) {
            this.inlineable = false;
        }

        @Override
        public void visitForExpression(ForExpr forExpr) {
            this.inlineable = false;
        }

        @Override
        public void visitLetExpression(LetExpr letExpr) {
            this.inlineable = false;
        }

        @Override
        public void visitOrderByClause(OrderByClause orderBy) {
            this.inlineable = false;
        }

        @Override
        public void visitGroupByClause(GroupByClause groupBy) {
            this.inlineable = false;
        }

        @Override
        public void visitWhereClause(WhereClause where) {
            this.inlineable = false;
        }

        @Override
        public void visitConditional(ConditionalExpression conditional) {
            this.inlineable = false;
        }

        @Override
        public void visitLocationStep(LocationStep locationStep) {
        }

        @Override
        public void visitPredicate(Predicate predicate) {
            super.visitPredicate(predicate);
        }

        @Override
        public void visitDocumentConstructor(DocumentConstructor constructor) {
            this.inlineable = false;
        }

        @Override
        public void visitElementConstructor(ElementConstructor constructor) {
            this.inlineable = false;
        }

        @Override
        public void visitTextConstructor(DynamicTextConstructor constructor) {
            this.inlineable = false;
        }

        @Override
        public void visitAttribConstructor(AttributeConstructor constructor) {
            this.inlineable = false;
        }

        @Override
        public void visitAttribConstructor(DynamicAttributeConstructor constructor) {
            this.inlineable = false;
        }

        @Override
        public void visitUnionExpr(Union union) {
            this.inlineable = false;
        }

        @Override
        public void visitIntersectionExpr(Intersect intersect) {
            this.inlineable = false;
        }

        @Override
        public void visitVariableDeclaration(VariableDeclaration decl) {
            this.inlineable = false;
        }

        @Override
        public void visitTryCatch(TryCatchExpression tryCatch) {
            this.inlineable = false;
        }

        @Override
        public void visitCastExpr(CastExpression expression) {
            this.inlineable = false;
        }

        @Override
        public void visitGeneralComparison(GeneralComparison comparison) {
            this.inlineable = false;
        }

        @Override
        public void visitAndExpr(OpAnd and) {
            this.inlineable = false;
        }

        @Override
        public void visitOrExpr(OpOr or) {
            this.inlineable = false;
        }

        @Override
        public void visitFilteredExpr(FilteredExpression filtered) {
            this.inlineable = false;
        }

        @Override
        public void visitVariableReference(VariableReference ref) {
            this.inlineable = false;
        }
    }

    public static class FindOptimizable
    extends BasicExpressionVisitor {
        List<Optimizable> optimizables = new ArrayList<Optimizable>();

        public List<Optimizable> getOptimizables() {
            return this.optimizables;
        }

        @Override
        public void visitPathExpr(PathExpr expression) {
            for (int i = 0; i < expression.getLength(); ++i) {
                Expression next = expression.getExpression(i);
                next.accept(this);
            }
        }

        @Override
        public void visitGeneralComparison(GeneralComparison comparison) {
            this.optimizables.add(comparison);
        }

        @Override
        public void visitPredicate(Predicate predicate) {
            predicate.getExpression(0).accept(this);
        }

        @Override
        public void visitBuiltinFunction(Function function) {
            if (function instanceof Optimizable) {
                this.optimizables.add((Optimizable)((Object)function));
            }
        }
    }
}

