/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Dependency;
import org.exist.xquery.EnclosedExpr;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.Predicate;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.Step;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.CompiledExpression;

public class PathExpr
extends AbstractExpression
implements CompiledXQuery,
CompiledExpression,
RewritableExpression {
    protected static final Logger LOG = LogManager.getLogger(PathExpr.class);
    protected final List<Expression> steps = new ArrayList<Expression>();
    private boolean staticContext = false;
    protected boolean inPredicate = false;
    protected Expression parent;

    public PathExpr(XQueryContext context) {
        super(context);
    }

    public void add(Expression expression) {
        this.steps.add(expression);
    }

    public void add(PathExpr path) {
        this.steps.addAll(path.steps);
    }

    public void addPath(PathExpr path) {
        this.steps.add(path);
    }

    public void addPredicate(Predicate predicate) {
        Expression e;
        if (!this.steps.isEmpty() && (e = this.steps.get(this.steps.size() - 1)) instanceof Step) {
            ((Step)e).addPredicate(predicate);
        }
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        int idx = this.steps.indexOf(oldExpr);
        if (idx < 0) {
            LOG.warn("Expression not found: " + ExpressionDumper.dump(oldExpr) + "; in: " + ExpressionDumper.dump(this));
            return;
        }
        this.steps.set(idx, newExpr);
    }

    @Override
    public Expression getPrevious(Expression current) {
        int idx = this.steps.indexOf(current);
        if (idx > 1) {
            return this.steps.get(idx - 1);
        }
        return null;
    }

    @Override
    public Expression getFirst() {
        return this.steps.isEmpty() ? null : this.steps.get(0);
    }

    @Override
    public void remove(Expression oldExpr) {
        int idx = this.steps.indexOf(oldExpr);
        if (idx < 0) {
            LOG.warn("Expression to remove not found: " + ExpressionDumper.dump(oldExpr) + "; in: " + ExpressionDumper.dump(this));
            return;
        }
        this.steps.remove(idx);
    }

    @Override
    public Expression getParent() {
        return this.parent;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        this.contextId = contextInfo.getContextId();
        for (int i = 0; i < this.steps.size(); ++i) {
            Expression expr = this.steps.get(i);
            if ((contextInfo.getFlags() & 2) > 0 && i == 1) {
                contextInfo.setFlags(contextInfo.getFlags() & 0xFFFFFFFD);
                if ((contextInfo.getFlags() & 4) == 0) {
                    contextInfo.setContextId(-1);
                }
            }
            if (i > 1) {
                contextInfo.setContextStep(this.steps.get(i - 1));
            }
            contextInfo.setParent(this);
            expr.analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence result = null;
        if (this.steps.size() == 0) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Variable var;
            result = contextSequence;
            Sequence currentContext = contextSequence;
            DocumentSet contextDocs = null;
            Expression expr = this.steps.get(0);
            if (expr instanceof VariableReference && (var = ((VariableReference)expr).getVariable()) != null) {
                contextDocs = var.getContextDocs();
            }
            this.setContextDocSet(contextDocs);
            boolean gotAtomicResult = false;
            Expression prev = null;
            Iterator<Expression> iter = this.steps.iterator();
            while (iter.hasNext()) {
                prev = expr;
                expr = iter.next();
                this.context.getWatchDog().proceed(expr);
                if (gotAtomicResult && !Type.subTypeOf(expr.returnsType(), -1) && !(expr instanceof EnclosedExpr)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0019, "left operand of '/' must be a node. Got '" + Type.getTypeName(result.getItemType()) + Cardinality.toString(result.getCardinality()) + "'");
                }
                expr.setContextDocSet(contextDocs);
                boolean inMemProcessing = currentContext != null && Type.subTypeOf(currentContext.getItemType(), -1) && !currentContext.isPersistentSet();
                int exprDeps = expr.getDependencies();
                if (inMemProcessing || (Dependency.dependsOn(exprDeps, 2) || Dependency.dependsOn(exprDeps, 16)) && (!(this instanceof Predicate) || !Type.subTypeOf(this.returnsType(), 30)) && currentContext != null && !currentContext.isEmpty()) {
                    Sequence exprResult = new ValueSequence(Type.subTypeOf(expr.returnsType(), -1));
                    exprResult.keepUnOrdered(this.unordered);
                    int p = this.context.getContextPosition();
                    Sequence seq = this.context.getContextSequence();
                    SequenceIterator iterInner = currentContext.iterate();
                    while (iterInner.hasNext()) {
                        this.context.setContextSequencePosition(p, seq);
                        this.context.getWatchDog().proceed(expr);
                        Item current = iterInner.nextItem();
                        if (!currentContext.hasMany()) {
                            exprResult = expr.eval(currentContext, current);
                        } else {
                            exprResult.addAll(expr.eval(currentContext, current));
                        }
                        ++p;
                    }
                    result = exprResult;
                } else {
                    result = expr.eval(currentContext);
                }
                if (result != null) {
                    if (!(this.steps.size() <= 1 || result instanceof VirtualNodeSet || expr instanceof EnclosedExpr || result.isEmpty() || Type.subTypeOf(result.getItemType(), -1))) {
                        gotAtomicResult = true;
                    }
                    if (this.steps.size() > 1 && this.getLastExpression() instanceof Step) {
                        result.removeDuplicates();
                    }
                }
                if (this.staticContext) continue;
                currentContext = result;
            }
            boolean allowMixedNodesInReturn = prev != null ? prev.allowMixedNodesInReturn() | expr.allowMixedNodesInReturn() : expr.allowMixedNodesInReturn();
            if (gotAtomicResult && result != null && !allowMixedNodesInReturn && !Type.subTypeOf(result.getItemType(), 20)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0018, "Cannot mix nodes and atomic values in the result of a path expression.");
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public XQueryContext getContext() {
        return this.context;
    }

    public DocumentSet getDocumentSet() {
        return null;
    }

    public Expression getExpression(int pos) {
        return this.steps.isEmpty() ? null : this.steps.get(pos);
    }

    @Override
    public Expression getSubExpression(int pos) {
        return this.steps.isEmpty() ? null : this.steps.get(pos);
    }

    public Expression getLastExpression() {
        return this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
    }

    public int getLength() {
        return this.steps.size();
    }

    @Override
    public int getSubExpressionCount() {
        return this.steps.size();
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        if (this.steps.size() == 1) {
            return this.steps.get(0).allowMixedNodesInReturn();
        }
        return super.allowMixedNodesInReturn();
    }

    public void setUseStaticContext(boolean staticContext) {
        this.staticContext = staticContext;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitPathExpr(this);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        Expression next2 = null;
        int count = 0;
        for (Expression next2 : this.steps) {
            if (next2 instanceof LogicalOp) {
                dumper.display('(');
            }
            if (count > 0) {
                if (next2 instanceof Step) {
                    dumper.display("/");
                } else {
                    dumper.nl();
                }
            }
            next2.dump(dumper);
            ++count;
        }
        if (next2 instanceof LogicalOp) {
            dumper.display(')');
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Expression next2 = null;
        if (this.steps.size() == 0) {
            result.append("()");
        } else {
            int count = 0;
            for (Expression next2 : this.steps) {
                if (next2 instanceof LogicalOp) {
                    result.append('(');
                }
                if (count > 0) {
                    if (next2 instanceof Step) {
                        result.append("/");
                    } else {
                        result.append(' ');
                    }
                }
                result.append(next2.toString());
                ++count;
            }
            if (next2 instanceof LogicalOp) {
                result.append(')');
            }
        }
        return result.toString();
    }

    @Override
    public int returnsType() {
        if (this.steps.size() == 0) {
            return -1;
        }
        return this.steps.get(this.steps.size() - 1).returnsType();
    }

    @Override
    public int getCardinality() {
        if (this.steps.size() == 0) {
            return 1;
        }
        return this.steps.get(this.steps.size() - 1).getCardinality();
    }

    @Override
    public int getDependencies() {
        int deps = 0;
        for (Expression step : this.steps) {
            deps |= step.getDependencies();
        }
        return deps;
    }

    public void replaceLastExpression(Expression s) {
        if (this.steps.size() == 0) {
            return;
        }
        this.steps.set(this.steps.size() - 1, s);
    }

    public String getLiteralValue() {
        if (this.steps.size() == 0) {
            return "";
        }
        Expression next = this.steps.get(0);
        if (next instanceof LiteralValue) {
            try {
                return ((LiteralValue)next).getValue().getStringValue();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (next instanceof PathExpr) {
            return ((PathExpr)next).getLiteralValue();
        }
        return "";
    }

    @Override
    public int getLine() {
        if (this.line < 0 && this.steps.size() > 0) {
            return this.steps.get(0).getLine();
        }
        return this.line;
    }

    @Override
    public int getColumn() {
        if (this.column < 0 && this.steps.size() > 0) {
            return this.steps.get(0).getColumn();
        }
        return this.column;
    }

    @Override
    public void setPrimaryAxis(int axis) {
        if (this.steps.size() > 0) {
            this.steps.get(0).setPrimaryAxis(axis);
        }
    }

    @Override
    public int getPrimaryAxis() {
        if (this.steps.size() > 0) {
            return this.steps.get(0).getPrimaryAxis();
        }
        return -1;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        for (int i = 0; i < this.steps.size(); ++i) {
            this.steps.get(i).resetState(postOptimization);
        }
    }

    @Override
    public void reset() {
        this.resetState(false);
    }

    @Override
    public boolean isValid() {
        return this.context.checkModulesValid();
    }

    @Override
    public void dump(Writer writer) {
        ExpressionDumper dumper = new ExpressionDumper(writer);
        this.dump(dumper);
    }

    @Override
    public void setContext(XQueryContext context) {
        this.context = context;
    }

    @Override
    public Expression simplify() {
        if (this.steps.size() == 1) {
            return this.steps.get(0).simplify();
        }
        return this;
    }
}

