/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.TreeSet;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Predicate
extends PathExpr {
    public static final int UNKNOWN = -1;
    public static final int NODE = 0;
    public static final int BOOLEAN = 1;
    public static final int POSITIONAL = 2;
    private CachedResult cached = null;
    private int executionMode = -1;
    private int outerContextId;
    private Expression parent;

    public Predicate(XQueryContext context) {
        super(context);
    }

    @Override
    public void addPath(PathExpr path) {
        if (path.getLength() == 1) {
            this.add(path.getExpression(0));
        } else {
            super.addPath(path);
        }
    }

    @Override
    public int getDependencies() {
        int deps = 0;
        deps = this.getLength() == 1 ? this.getExpression(0).getDependencies() : super.getDependencies();
        return deps;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        int innerType;
        this.parent = contextInfo.getParent();
        AnalyzeContextInfo newContextInfo = this.createContext(contextInfo);
        super.analyze(newContextInfo);
        Expression inner = this.getExpression(0);
        int staticReturnType = newContextInfo.getStaticReturnType();
        int n = innerType = staticReturnType != 11 ? staticReturnType : inner.returnsType();
        this.executionMode = Type.subTypeOf(innerType, -1) && !Dependency.dependsOn(inner, 2) ? 0 : (Type.subTypeOf(innerType, 30) && !Dependency.dependsOn(inner, 2) && Cardinality.checkCardinality(inner.getCardinality(), 2) ? 2 : 1);
        if (this.executionMode == 1) {
            newContextInfo = this.createContext(contextInfo);
            newContextInfo.addFlag(1);
            super.analyze(newContextInfo);
        }
        if (this.executionMode == 2 && staticReturnType != 11 && !Dependency.dependsOn(inner, 2)) {
            contextInfo.addFlag(64);
        }
    }

    private AnalyzeContextInfo createContext(AnalyzeContextInfo contextInfo) {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.addFlag(2);
        newContextInfo.removeFlag(4);
        newContextInfo.removeFlag(128);
        this.outerContextId = newContextInfo.getContextId();
        newContextInfo.setContextId(this.getExpressionId());
        newContextInfo.setStaticType(contextInfo.getStaticType());
        newContextInfo.setParent(this);
        return newContextInfo;
    }

    public Sequence preprocess() throws XPathException {
        Predicate inner = this.steps.size() == 1 ? this.getExpression(0) : this;
        return inner.eval(null);
    }

    public Boolean matchPredicate(Sequence contextSequence, Item contextItem, int mode) throws XPathException {
        Predicate inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        boolean result = false;
        Expression expression = inner = this.steps.size() == 1 ? this.getExpression(0) : this;
        if (inner == null) {
            result = false;
        } else {
            int recomputedExecutionMode = this.executionMode;
            Sequence innerSeq = null;
            if (Type.subTypeOf(contextSequence.getItemType(), 20)) {
                if (this.executionMode == 0 && !(contextSequence instanceof VirtualNodeSet)) {
                    recomputedExecutionMode = Type.subTypeOf(contextSequence.getItemType(), 30) ? 2 : 1;
                }
                if (!(this.executionMode != 1 || Dependency.dependsOn(inner, 2) || inner instanceof GeneralComparison && ((GeneralComparison)((Object)inner)).invalidNodeEvaluation || !(innerSeq = inner.eval(contextSequence)).hasOne() || !Type.subTypeOf(innerSeq.getItemType(), 30))) {
                    recomputedExecutionMode = 2;
                }
            } else if (this.executionMode == 0 && !contextSequence.isPersistentSet()) {
                recomputedExecutionMode = 1;
            } else if (this.executionMode == 1 && !Dependency.dependsOn(inner, 2)) {
                innerSeq = inner.eval(contextSequence);
                if (Type.subTypeOf(innerSeq.getItemType(), -1) && innerSeq.isPersistentSet()) {
                    recomputedExecutionMode = 0;
                } else if (innerSeq.hasOne() && Type.subTypeOf(innerSeq.getItemType(), 30)) {
                    recomputedExecutionMode = 2;
                }
            }
            switch (recomputedExecutionMode) {
                case 0: {
                    if (!this.context.getProfiler().isEnabled()) break;
                    this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Node selection");
                    break;
                }
                case 1: {
                    if (!this.context.getProfiler().isEnabled()) break;
                    this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Boolean evaluation");
                    break;
                }
                case 2: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Positional evaluation");
                    }
                    if (innerSeq != null) break;
                    innerSeq = inner.eval(contextSequence);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported execution mode: '" + recomputedExecutionMode + "'");
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", null);
        }
        return result;
    }

    public Sequence evalPredicate(Sequence outerSequence, Sequence contextSequence, int mode) throws XPathException {
        Sequence result;
        Predicate inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        Expression expression = inner = this.steps.size() == 1 ? this.getExpression(0) : this;
        if (inner == null) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (this.executionMode == -1) {
                this.executionMode = 1;
            }
            int recomputedExecutionMode = this.executionMode;
            Sequence innerSeq = null;
            if (Type.subTypeOf(contextSequence.getItemType(), 20)) {
                if (this.executionMode == 0 && !(contextSequence instanceof VirtualNodeSet)) {
                    recomputedExecutionMode = Type.subTypeOf(contextSequence.getItemType(), 30) ? 2 : 1;
                }
                if (!(this.executionMode != 1 || Dependency.dependsOn(inner, 2) || inner instanceof GeneralComparison && ((GeneralComparison)((Object)inner)).invalidNodeEvaluation || !(innerSeq = inner.eval(contextSequence)).hasOne() || !Type.subTypeOf(innerSeq.getItemType(), 30))) {
                    recomputedExecutionMode = 2;
                }
            } else if (this.executionMode == 0 && !contextSequence.isPersistentSet()) {
                recomputedExecutionMode = 1;
            } else if (this.executionMode == 1 && !Dependency.dependsOn(inner, 2)) {
                innerSeq = inner.eval(contextSequence);
                if (Type.subTypeOf(innerSeq.getItemType(), -1) && innerSeq.isPersistentSet()) {
                    recomputedExecutionMode = 0;
                } else if (innerSeq.hasOne() && Type.subTypeOf(innerSeq.getItemType(), 30)) {
                    recomputedExecutionMode = 2;
                }
            }
            switch (recomputedExecutionMode) {
                case 0: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Node selection");
                    }
                    result = this.selectByNodeSet(contextSequence);
                    break;
                }
                case 1: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Boolean evaluation");
                    }
                    result = this.evalBoolean(contextSequence, inner, mode);
                    break;
                }
                case 2: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, 3, "OPTIMIZATION CHOICE", "Positional evaluation");
                    }
                    if (innerSeq == null) {
                        this.context.setContextSequencePosition(0, contextSequence);
                        innerSeq = inner.eval(Dependency.dependsOn(inner.getDependencies(), 2) ? contextSequence : null);
                    }
                    result = this.selectByPosition(outerSequence, contextSequence, mode, innerSeq);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported execution mode: '" + recomputedExecutionMode + "'");
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalBoolean(Sequence contextSequence, Expression inner, int mode) throws XPathException {
        ValueSequence result = new ValueSequence();
        if (contextSequence instanceof NodeSet && ((NodeSet)contextSequence).getProcessInReverseOrder()) {
            int p = contextSequence.getItemCount();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                this.context.setContextSequencePosition(p - 1, contextSequence);
                Item item = i.nextItem();
                Sequence innerSeq = inner.eval(contextSequence, item);
                if (innerSeq.effectiveBooleanValue()) {
                    result.add(item);
                }
                --p;
            }
        } else {
            boolean reverseAxis;
            int p = 0;
            boolean bl = reverseAxis = Type.subTypeOf(contextSequence.getItemType(), -1) && (mode == 0 || mode == 1 || mode == 2 || mode == 3 || mode == 4);
            if (Type.subTypeOf(inner.returnsType(), 30) && Dependency.dependsOn(inner, 2)) {
                TreeSet<NumericValue> positions = new TreeSet<NumericValue>();
                SequenceIterator i = contextSequence.iterate();
                while (i.hasNext()) {
                    NumericValue nv;
                    this.context.setContextSequencePosition(p, contextSequence);
                    Item item = i.nextItem();
                    Sequence innerSeq = inner.eval(contextSequence, item);
                    if (innerSeq.hasOne() && !(nv = (NumericValue)innerSeq.itemAt(0)).hasFractionalPart() && !nv.isZero()) {
                        positions.add(nv);
                    }
                    ++p;
                }
                for (NumericValue pos : positions) {
                    int position = reverseAxis ? contextSequence.getItemCount() - pos.getInt() : pos.getInt() - 1;
                    if (position > contextSequence.getItemCount()) continue;
                    result.add(contextSequence.itemAt(position));
                }
            } else {
                TreeSet<NumericValue> positions = new TreeSet<NumericValue>();
                SequenceIterator i = contextSequence.iterate();
                while (i.hasNext()) {
                    this.context.setContextSequencePosition(reverseAxis ? contextSequence.getItemCount() - p - 1 : p, contextSequence);
                    Item item = i.nextItem();
                    Sequence innerSeq = inner.eval(contextSequence, item);
                    if (innerSeq.hasOne() && Type.subTypeOf(innerSeq.getItemType(), 30)) {
                        NumericValue nv = (NumericValue)innerSeq;
                        if (!nv.hasFractionalPart() && !nv.isZero()) {
                            positions.add(nv);
                        }
                    } else if (innerSeq.effectiveBooleanValue()) {
                        result.add(item);
                    }
                    ++p;
                }
                for (NumericValue pos : positions) {
                    int position = reverseAxis ? contextSequence.getItemCount() - pos.getInt() : pos.getInt() - 1;
                    if (position > contextSequence.getItemCount()) continue;
                    result.add(contextSequence.itemAt(position));
                }
            }
        }
        return result;
    }

    private Sequence selectByNodeSet(Sequence contextSequence) throws XPathException {
        NewArrayNodeSet result = new NewArrayNodeSet();
        NodeSet contextSet = contextSequence.toNodeSet();
        boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
        contextSet.setTrackMatches(false);
        NodeSet nodes = super.eval(contextSet, null).toNodeSet();
        if (this.cached != null && this.cached.isValid(contextSequence, null) && nodes.isCached()) {
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().message((Expression)this, 2, "Using cached results", result);
            }
            return this.cached.getResult();
        }
        DocumentImpl lastDoc = null;
        for (NodeProxy currentNode : nodes) {
            ContextItem contextItem;
            int sizeHint = -1;
            if (lastDoc == null || currentNode.getOwnerDocument() != lastDoc) {
                lastDoc = currentNode.getOwnerDocument();
                sizeHint = nodes.getSizeHint(lastDoc);
            }
            if ((contextItem = currentNode.getContext()) == null) {
                throw new XPathException((Expression)this, "Internal evaluation error: context is missing for node " + currentNode.getNodeId() + " !");
            }
            while (contextItem != null) {
                if (contextItem.getContextId() == this.getExpressionId()) {
                    NodeProxy next = contextItem.getNode();
                    if (contextIsVirtual || contextSet.contains(next)) {
                        next.addMatches(currentNode);
                        result.add(next, sizeHint);
                    }
                }
                contextItem = contextItem.getNextDirect();
            }
        }
        if (contextSequence.isCacheable()) {
            this.cached = new CachedResult(contextSequence, null, result);
        }
        contextSet.setTrackMatches(true);
        return result;
    }

    private Sequence selectByPosition(Sequence outerSequence, Sequence contextSequence, int mode, Sequence innerSeq) throws XPathException {
        if (outerSequence != null && !outerSequence.isEmpty() && Type.subTypeOf(contextSequence.getItemType(), -1) && contextSequence.isPersistentSet() && outerSequence.isPersistentSet()) {
            NewArrayNodeSet result = new NewArrayNodeSet();
            NodeSet contextSet = contextSequence.toNodeSet();
            switch (mode) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: {
                    NodeSet outerNodeSet = outerSequence.toNodeSet();
                    NodeSet ancestors = outerNodeSet.selectAncestors(contextSet, true, this.getExpressionId());
                    if (contextSet.getDocumentSet().intersection(outerNodeSet.getDocumentSet()).getDocumentCount() == 0) {
                        LOG.info("contextSet and outerNodeSet don't share any document");
                    }
                    NewArrayNodeSet temp = new NewArrayNodeSet();
                    SequenceIterator i = ancestors.iterate();
                    while (i.hasNext()) {
                        NodeProxy p = (NodeProxy)i.nextItem();
                        temp.reset();
                        for (ContextItem contextNode = p.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
                            if (contextNode.getContextId() != this.getExpressionId()) continue;
                            temp.add(contextNode.getNode());
                        }
                        p.clearContext(this.getExpressionId());
                        temp.sortInDocumentOrder();
                        SequenceIterator j = innerSeq.iterate();
                        while (j.hasNext()) {
                            NumericValue v = (NumericValue)j.nextItem();
                            if (v.hasFractionalPart() || v.isZero() || (p = temp.get(v.getInt() - 1)) == null) continue;
                            result.add((Item)p);
                        }
                    }
                    break;
                }
                default: {
                    SequenceIterator i = outerSequence.iterate();
                    while (i.hasNext()) {
                        NodeSet temp;
                        NodeProxy p = (NodeProxy)i.nextItem();
                        boolean reverseAxis = true;
                        switch (mode) {
                            case 0: {
                                temp = contextSet.selectAncestors(p, false, -2);
                                break;
                            }
                            case 1: {
                                temp = contextSet.selectAncestors(p, true, -2);
                                break;
                            }
                            case 2: {
                                temp = p.getParents(-1);
                                break;
                            }
                            case 3: {
                                temp = contextSet.selectPreceding(p, -2);
                                break;
                            }
                            case 4: {
                                temp = contextSet.selectPrecedingSiblings(p, -2);
                                break;
                            }
                            case 10: {
                                temp = contextSet.selectFollowingSiblings(p, -2);
                                reverseAxis = false;
                                break;
                            }
                            case 9: {
                                temp = contextSet.selectFollowing(p, -2);
                                reverseAxis = false;
                                break;
                            }
                            case 12: {
                                temp = p;
                                reverseAxis = false;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Tried to test unknown axis");
                            }
                        }
                        if (temp.isEmpty()) continue;
                        SequenceIterator j = innerSeq.iterate();
                        while (j.hasNext()) {
                            int pos;
                            NumericValue v = (NumericValue)j.nextItem();
                            if (v.hasFractionalPart() || v.isZero() || (pos = reverseAxis ? temp.getItemCount() - v.getInt() : v.getInt() - 1) < 0 || pos >= temp.getItemCount()) continue;
                            NodeProxy t = (NodeProxy)temp.itemAt(pos);
                            t.clearContext(-2);
                            for (ContextItem ctx = t.getContext(); ctx != null; ctx = ctx.getNextDirect()) {
                                if (ctx.getContextId() == this.outerContextId) {
                                    if (!ctx.getNode().getNodeId().equals(p.getNodeId())) continue;
                                    t.addContextNode(this.outerContextId, ctx.getNode());
                                    continue;
                                }
                                t.addContextNode(ctx.getContextId(), ctx.getNode());
                            }
                            result.add((Item)t);
                        }
                    }
                    break block0;
                }
            }
            return result;
        }
        boolean reverseAxis = Type.subTypeOf(contextSequence.getItemType(), -1) && (mode == 0 || mode == 1 || mode == 2 || mode == 3 || mode == 4);
        TreeSet<NumericValue> set = new TreeSet<NumericValue>();
        ValueSequence result = new ValueSequence();
        SequenceIterator i = innerSeq.iterate();
        while (i.hasNext()) {
            int pos;
            NumericValue v = (NumericValue)i.nextItem();
            if (v.hasFractionalPart() || v.isZero() || (pos = reverseAxis ? contextSequence.getItemCount() - v.getInt() : v.getInt() - 1) < 0 || pos >= contextSequence.getItemCount() || set.contains(v)) continue;
            result.add(contextSequence.itemAt(pos));
            set.add(v);
        }
        return result;
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        if (this.getLength() > 0) {
            this.getExpression(0).setContextDocSet(contextSet);
        }
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
        }
    }

    @Override
    public Expression getParent() {
        return this.parent;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitPredicate(this);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("[");
        super.dump(dumper);
        dumper.display("]");
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "]";
    }

    @Override
    public Expression simplify() {
        return this;
    }
}

