/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class QuantifiedExpression
extends BindingExpression {
    public static final int SOME = 0;
    public static final int EVERY = 1;
    private final int mode;

    public QuantifiedExpression(XQueryContext context, int mode) {
        super(context);
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("QuantifiedExpression");
            }
        }
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return this.mode == 0 ? FLWORClause.ClauseType.SOME : FLWORClause.ClauseType.EVERY;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            this.context.declareVariableBinding(new LocalVariable(QName.parse(this.context, this.varName, null)));
            contextInfo.setParent(this);
            this.inputSequence.analyze(contextInfo);
            this.returnExpr.analyze(contextInfo);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + this.varName);
        }
        finally {
            this.context.popLocalVariables(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        LocalVariable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        try {
            var = new LocalVariable(QName.parse(this.context, this.varName, null));
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + this.varName);
        }
        Sequence inSeq = this.inputSequence.eval(contextSequence, contextItem);
        if (this.sequenceType != null && !inSeq.isEmpty() && !Type.subTypeOf(inSeq.getItemType(), this.sequenceType.getPrimaryType())) {
            throw new XPathException(this, ErrorCodes.XPTY0004, "Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(inSeq.getItemType()), inSeq);
        }
        boolean found = this.mode == 1;
        boolean canDecide = this.mode == 1;
        SequenceIterator i = inSeq.iterate();
        while (i.hasNext()) {
            canDecide = true;
            Item item = i.nextItem();
            var.setValue(item.toSequence());
            if (this.sequenceType == null) {
                var.checkType();
            }
            Sequence satisfiesSeq = null;
            LocalVariable mark = this.context.markLocalVariables(false);
            try {
                this.context.declareVariableBinding(var);
                satisfiesSeq = this.returnExpr.eval(contextSequence, contextItem);
                this.context.popLocalVariables(mark, satisfiesSeq);
            }
            catch (Throwable throwable) {
                this.context.popLocalVariables(mark, satisfiesSeq);
                throw throwable;
            }
            if (this.sequenceType != null) {
                if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1)) {
                    if (!Type.subTypeOf(item.toSequence().getItemType(), this.sequenceType.getPrimaryType())) {
                        throw new XPathException(this, ErrorCodes.XPTY0004, "Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(contextItem.toSequence().getItemType()), inSeq);
                    }
                } else {
                    if (!Type.subTypeOf(item.getType(), -1)) {
                        throw new XPathException(this, ErrorCodes.XPTY0004, "Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(-1) + " (or more specific), got " + Type.getTypeName(item.getType()), inSeq);
                    }
                    var.checkType();
                }
            }
            found = satisfiesSeq.effectiveBooleanValue();
            if ((this.mode != 0 || !found) && (this.mode != 1 || found)) continue;
            break;
        }
        BooleanValue booleanValue = result = canDecide && found ? BooleanValue.TRUE : BooleanValue.FALSE;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display(this.mode == 0 ? "some" : "every");
        dumper.display(" $").display(this.varName).display(" in");
        dumper.startIndent();
        this.inputSequence.dump(dumper);
        dumper.endIndent().nl();
        dumper.display("satisfies");
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.mode == 0 ? "some" : "every");
        result.append(" $").append(this.varName).append(" in");
        result.append(" ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        result.append("satisfies");
        result.append(" ");
        result.append(this.returnExpr.toString());
        result.append(" ");
        return result.toString();
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public int getDependencies() {
        return 3;
    }
}

