/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class RangeSequence
extends AbstractSequence {
    private static final Logger LOG = LogManager.getLogger(AbstractSequence.class);
    private IntegerValue start;
    private IntegerValue end;

    public RangeSequence(IntegerValue start, IntegerValue end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void add(Item item) throws XPathException {
        throw new XPathException("Internal error: adding to an immutable sequence");
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        throw new XPathException("Internal error: adding to an immutable sequence");
    }

    @Override
    public int getItemType() {
        return 31;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new RangeSequenceIterator(this.start.getLong(), this.end.getLong());
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return new RangeSequenceIterator(this.start.getLong(), this.end.getLong());
    }

    public SequenceIterator iterateInReverse() throws XPathException {
        return new ReverseRangeSequenceIterator(this.start.getLong(), this.end.getLong());
    }

    @Override
    public int getItemCount() {
        if (this.start.compareTo(this.end) > 0) {
            return 0;
        }
        try {
            return ((IntegerValue)this.end.minus(this.start)).getInt() + 1;
        }
        catch (XPathException e) {
            LOG.warn("Unexpected exception when processing result of range expression: " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public boolean hasOne() {
        return this.getItemCount() == 1;
    }

    @Override
    public boolean hasMany() {
        return this.getItemCount() > 1;
    }

    @Override
    public Item itemAt(int pos) {
        if (pos <= this.getItemCount()) {
            try {
                return new IntegerValue(this.start.getLong() + (long)pos);
            }
            catch (XPathException e) {
                LOG.warn("Unexpected exception when processing result of range expression: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is xs:integer");
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is xs:integer");
    }

    @Override
    public void removeDuplicates() {
    }

    private static class ReverseRangeSequenceIterator
    implements SequenceIterator {
        private final long start;
        private long current;

        public ReverseRangeSequenceIterator(long start, long end) {
            this.start = start;
            this.current = end;
        }

        @Override
        public Item nextItem() {
            if (this.current >= this.start) {
                return new IntegerValue(this.current--);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.current >= this.start;
        }
    }

    private static class RangeSequenceIterator
    implements SequenceIterator {
        private long current;
        private final long end;

        public RangeSequenceIterator(long start, long end) {
            this.current = start;
            this.end = end;
        }

        @Override
        public Item nextItem() {
            if (this.current <= this.end) {
                return new IntegerValue(this.current++);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.current <= this.end;
        }
    }
}

