/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class RootNode
extends Step {
    private NodeSet cached = null;
    private DocumentSet cachedDocs = null;
    private UpdateListener listener = null;

    public RootNode(XQueryContext context) {
        super(context, 12);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet ds;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((ds = this.context.getStaticallyKnownDocuments()) == null || ds.getDocumentCount() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        try {
            if (!this.context.inProtectedMode()) {
                ds.lock(this.context.getBroker(), false);
            }
            Iterator<DocumentImpl> i = ds.getDocumentIterator();
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                if (this.context.inProtectedMode() && !this.context.getProtectedDocs().containsKey(doc.getDocId()) || doc.getResourceType() != 0) continue;
                result.add(new NodeProxy(doc));
            }
            this.cached = result;
            this.cachedDocs = ds;
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Failed to acquire lock on the context document set");
        }
        finally {
            if (!this.context.inProtectedMode()) {
                ds.unlock();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        this.registerUpdateListener();
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("[root-node]");
    }

    @Override
    public String toString() {
        return "[root-node]";
    }

    @Override
    public int returnsType() {
        return -1;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                @Override
                public void documentUpdated(DocumentImpl document, int event) {
                    RootNode.this.cachedDocs = null;
                    RootNode.this.cached = null;
                }

                @Override
                public void unsubscribe() {
                    RootNode.this.listener = null;
                }

                @Override
                public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
                }

                @Override
                public void debug() {
                    Step.LOG.debug("UpdateListener: Line: " + RootNode.this.toString());
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.cached = null;
        this.cachedDocs = null;
    }
}

