/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class SequenceConstructor
extends PathExpr {
    public SequenceConstructor(XQueryContext context) {
        super(context);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        this.contextId = contextInfo.getContextId();
        int staticType = 12;
        for (int i = 0; i < this.steps.size(); ++i) {
            Expression expr = (Expression)this.steps.get(i);
            AnalyzeContextInfo info = new AnalyzeContextInfo(contextInfo);
            expr.analyze(info);
            if (staticType == 12) {
                staticType = info.getStaticReturnType();
                continue;
            }
            if (staticType == 11 || staticType == info.getStaticReturnType()) continue;
            staticType = 11;
        }
        contextInfo.setStaticReturnType(staticType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        ValueSequence result = new ValueSequence();
        result.keepUnOrdered(this.unordered);
        for (Expression step : this.steps) {
            this.context.pushDocumentContext();
            try {
                Sequence temp = step.eval(contextSequence, contextItem);
                if (temp == null || temp.isEmpty()) continue;
                result.addAll(temp);
            }
            finally {
                this.context.popDocumentContext();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("(");
        dumper.startIndent();
        boolean moreThanOne = false;
        for (Expression step : this.steps) {
            if (moreThanOne) {
                dumper.display(", ");
            }
            moreThanOne = true;
            step.dump(dumper);
        }
        dumper.endIndent();
        dumper.nl().display(")");
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("( ");
        boolean moreThanOne = false;
        for (Expression step : this.steps) {
            if (moreThanOne) {
                result.append(", ");
            }
            moreThanOne = true;
            result.append(step.toString());
        }
        result.append(" )");
        return result.toString();
    }

    @Override
    public int returnsType() {
        return 11;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return true;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
    }
}

